/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners.controls;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.HashMap;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.TARDISCircuitChecker;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAreas;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDestinations;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetHomeLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public class TARDISKeyboardListener
implements Listener {
    private final TARDIS plugin;

    public TARDISKeyboardListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onKeyboardInteract(PlayerInteractEvent event) {
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Block b = event.getClickedBlock();
        if (b == null || !Tag.SIGNS.isTagged((Keyed)b.getType())) {
            return;
        }
        Player player = event.getPlayer();
        Sign sign = (Sign)b.getState();
        if (ComponentUtils.stripColour(sign.getSide(Side.FRONT).line(0)).equalsIgnoreCase("[TARDIS Wiki]")) {
            this.plugin.getMessenger().sendSign((CommandSender)player);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onSignChange(SignChangeEvent event) {
        String loc = event.getBlock().getLocation().toString();
        HashMap<String, Object> wherel = new HashMap<String, Object>();
        wherel.put("type", 7);
        wherel.put("location", loc);
        ResultSetControls rsc = new ResultSetControls(this.plugin, wherel, false);
        if (!rsc.resultSet()) {
            return;
        }
        Player p = event.getPlayer();
        TARDISCircuitChecker tcc = null;
        if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(p, false)) {
            tcc = new TARDISCircuitChecker(this.plugin, rsc.getTardis_id());
            tcc.getCircuits();
        }
        if (tcc != null && !tcc.hasInput()) {
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "INPUT_MISSING");
            return;
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", p.getUniqueId().toString());
        ResultSetTravellers rs = new ResultSetTravellers(this.plugin, where, false);
        if (!rs.resultSet()) {
            return;
        }
        String firstLine = ComponentUtils.stripColour(event.line(0));
        if (firstLine.isEmpty()) {
            return;
        }
        if (firstLine.equalsIgnoreCase("wiki")) {
            this.plugin.getMessenger().sendSign((CommandSender)p);
            return;
        }
        int id = rs.getTardis_id();
        if (this.plugin.getServer().getPlayer(firstLine) != null) {
            p.performCommand("tardistravel " + firstLine);
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, p.getName() + " issued server command: /tardistravel " + firstLine);
            return;
        }
        if (TARDISAliasResolver.getWorldFromAlias(firstLine) != null) {
            String command = firstLine + " " + ComponentUtils.stripColour(event.line(1)) + " " + ComponentUtils.stripColour(event.line(2)) + " " + ComponentUtils.stripColour(event.line(3));
            p.performCommand("tardistravel " + command);
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, p.getName() + " issued server command: /tardistravel " + command);
            return;
        }
        if (firstLine.equalsIgnoreCase("home")) {
            HashMap<String, Object> whereh = new HashMap<String, Object>();
            whereh.put("tardis_id", id);
            ResultSetHomeLocation rsh = new ResultSetHomeLocation(this.plugin, whereh);
            if (rsh.resultSet()) {
                ResultSetCurrentFromId rscl = new ResultSetCurrentFromId(this.plugin, id);
                if (rscl.resultSet()) {
                    if (this.currentIsNotHome(rsh, rscl.getCurrent().location())) {
                        p.performCommand("tardistravel home");
                        this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, p.getName() + " issued server command: /tardistravel home");
                    } else {
                        this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "HOME_ALREADY");
                    }
                } else {
                    this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                }
            } else {
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "HOME_NOT_FOUND");
            }
            return;
        }
        if (firstLine.equalsIgnoreCase("cave") && TARDISPermission.hasPermission(p, "tardis.timetravel.cave")) {
            p.performCommand("tardistravel cave");
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, p.getName() + " issued server command: /tardistravel cave");
            return;
        }
        if (firstLine.equalsIgnoreCase("village") && this.plugin.getConfig().getBoolean("allow.village_travel") && TARDISPermission.hasPermission(p, "tardis.timetravel.village")) {
            p.performCommand("tardistravel village");
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, p.getName() + " issued server command: /tardistravel village");
            return;
        }
        try {
            String upper = firstLine.toUpperCase(Locale.ROOT);
            Biome biome = (Biome)RegistryAccess.registryAccess().getRegistry(RegistryKey.BIOME).get(new NamespacedKey("minecraft", firstLine.toLowerCase(Locale.ROOT)));
            if (!(biome == null || upper.equals("HELL") || upper.equals("SKY") || upper.equals("VOID"))) {
                p.performCommand("tardistravel biome " + upper);
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, p.getName() + " issued server command: /tardistravel biome " + upper);
                return;
            }
        }
        catch (IllegalArgumentException iae) {
            this.plugin.debug(this.plugin.getLanguage().getString("BIOME_NOT_VALID"));
        }
        HashMap<String, Object> whered = new HashMap<String, Object>();
        whered.put("dest_name", firstLine);
        ResultSetDestinations rsd = new ResultSetDestinations(this.plugin, whered, false);
        if (rsd.resultSet()) {
            p.performCommand("tardistravel dest " + firstLine);
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, p.getName() + " issued server command: /tardistravel dest " + firstLine);
            return;
        }
        HashMap<String, Object> wherea = new HashMap<String, Object>();
        wherea.put("area_name", firstLine);
        ResultSetAreas rsa = new ResultSetAreas(this.plugin, wherea, false, false);
        if (rsa.resultSet()) {
            p.performCommand("tardistravel area " + firstLine);
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, p.getName() + " issued server command: /tardistravel area " + firstLine);
            return;
        }
        this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "KEYBOARD_ERROR");
    }

    private boolean currentIsNotHome(ResultSetHomeLocation rsh, Location rsc) {
        if (rsh.getWorld() != rsc.getWorld()) {
            return true;
        }
        if (rsh.getY() != rsc.getBlockY()) {
            return true;
        }
        if (rsh.getX() != rsc.getBlockX()) {
            return true;
        }
        return rsh.getZ() != rsc.getBlockZ();
    }
}

