/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.HashMap;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPaperBag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISPaperBagListener
implements Listener {
    private final TARDIS plugin;

    public TARDISPaperBagListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPaperBagInteract(InventoryClickEvent event) {
        Inventory inv = event.getView().getBottomInventory();
        if (!inv.getType().equals((Object)InventoryType.PLAYER)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!TARDISPermission.hasPermission(player, "tardis.paper_bag")) {
            return;
        }
        if (event.getRawSlot() < 0) {
            return;
        }
        ItemStack is = event.getCurrentItem();
        if (is == null || !is.getType().equals((Object)Material.PAPER)) {
            return;
        }
        ItemMeta im = is.getItemMeta();
        if (im == null || !im.hasDisplayName() || !ComponentUtils.endsWith(im.displayName(), "Paper Bag")) {
            return;
        }
        if (event.isRightClick()) {
            event.setCancelled(true);
            ResultSetPaperBag rs = new ResultSetPaperBag(this.plugin, player.getUniqueId());
            String flavour = rs.getJellyBaby();
            if (flavour != null) {
                ItemStack jb = ItemStack.of((Material)Material.MELON_SLICE, (int)1);
                ItemMeta jim = jb.getItemMeta();
                jim.displayName((Component)Component.text((String)(flavour + " Jelly Baby")));
                jb.setItemMeta(jim);
                int slot = inv.firstEmpty();
                if (slot != -1) {
                    inv.setItem(slot, jb);
                    player.updateInventory();
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PAPER_BAG_SLOT");
                }
            } else {
                if (!rs.resultSet()) {
                    HashMap<String, Object> bag = new HashMap<String, Object>();
                    bag.put("uuid", player.getUniqueId().toString());
                    this.plugin.getQueryFactory().doSyncInsert("paper_bag", bag);
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PAPER_BAG_EMPTY");
            }
        }
        if (event.isShiftClick()) {
            event.setCancelled(true);
            int jelly = inv.first(Material.MELON_SLICE);
            if (jelly >= 0) {
                int bagId;
                String flavour1 = "";
                String flavour2 = "";
                String flavour3 = "";
                String flavour4 = "";
                int amount1 = 0;
                int amount2 = 0;
                int amount3 = 0;
                int amount4 = 0;
                ResultSetPaperBag rs = new ResultSetPaperBag(this.plugin, player.getUniqueId());
                if (rs.resultSet()) {
                    bagId = rs.getPaperBagID();
                    flavour1 = rs.getFlavour1();
                    flavour2 = rs.getFlavour2();
                    flavour3 = rs.getFlavour3();
                    flavour4 = rs.getFlavour4();
                    amount1 = rs.getAmount1();
                    amount2 = rs.getAmount2();
                    amount3 = rs.getAmount3();
                    amount4 = rs.getAmount4();
                } else {
                    HashMap<String, Object> bag = new HashMap<String, Object>();
                    bag.put("uuid", player.getUniqueId().toString());
                    bagId = this.plugin.getQueryFactory().doSyncInsert("paper_bag", bag);
                }
                HashMap babies = inv.all(Material.MELON_SLICE);
                HashMap<Integer, Integer> adjustments = new HashMap<Integer, Integer>();
                for (Map.Entry entry : babies.entrySet()) {
                    int adjust;
                    String name;
                    ItemMeta jim;
                    if (!((ItemStack)entry.getValue()).hasItemMeta() || !(jim = ((ItemStack)entry.getValue()).getItemMeta()).hasDisplayName() || !(name = ComponentUtils.stripColour(jim.displayName())).endsWith("Jelly Baby")) continue;
                    int amount = ((ItemStack)entry.getValue()).getAmount();
                    String flavour = name.replace(" Jelly Baby", "");
                    if (flavour1.isEmpty()) {
                        flavour1 = flavour;
                        amount1 = amount;
                        adjustments.put((Integer)entry.getKey(), amount);
                        continue;
                    }
                    if (flavour1.equals(flavour) && amount1 < 64) {
                        adjust = amount1 + amount;
                        adjustments.put((Integer)entry.getKey(), adjust < 65 ? 0 : 64 - amount1);
                        amount1 = adjust < 65 ? adjust : 64;
                        continue;
                    }
                    if (flavour2.isEmpty()) {
                        flavour2 = flavour;
                        amount2 = amount;
                        adjustments.put((Integer)entry.getKey(), amount);
                        continue;
                    }
                    if (flavour2.equals(flavour) && amount2 < 64) {
                        adjust = amount2 + amount;
                        adjustments.put((Integer)entry.getKey(), adjust < 65 ? 0 : 64 - amount2);
                        amount2 = adjust < 65 ? adjust : 64;
                        continue;
                    }
                    if (flavour3.isEmpty()) {
                        flavour3 = flavour;
                        amount3 = amount;
                        adjustments.put((Integer)entry.getKey(), amount);
                        continue;
                    }
                    if (flavour3.equals(flavour) && amount3 < 64) {
                        adjust = amount3 + amount;
                        adjustments.put((Integer)entry.getKey(), adjust < 65 ? 0 : 64 - amount3);
                        amount3 = adjust < 65 ? adjust : 64;
                        continue;
                    }
                    if (flavour4.isEmpty()) {
                        flavour4 = flavour;
                        amount4 = amount;
                        adjustments.put((Integer)entry.getKey(), amount);
                        continue;
                    }
                    if (!flavour4.equals(flavour) || amount4 >= 64) continue;
                    adjust = amount4 + amount;
                    adjustments.put((Integer)entry.getKey(), adjust < 65 ? 0 : 64 - amount4);
                    amount4 = adjust < 65 ? adjust : 64;
                }
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("paper_bag_id", bagId);
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("flavour_1", flavour1);
                set.put("amount_1", amount1);
                set.put("flavour_2", flavour2);
                set.put("amount_2", amount2);
                set.put("flavour_3", flavour3);
                set.put("amount_3", amount3);
                set.put("flavour_4", flavour4);
                set.put("amount_4", amount4);
                this.plugin.getQueryFactory().doSyncUpdate("paper_bag", set, where);
                for (Map.Entry entry : adjustments.entrySet()) {
                    if ((Integer)entry.getValue() == 0) {
                        inv.clear(((Integer)entry.getKey()).intValue());
                        continue;
                    }
                    inv.getItem(((Integer)entry.getKey()).intValue()).setAmount(((Integer)entry.getValue()).intValue());
                }
                player.updateInventory();
            }
        }
    }
}

