/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.doors;

import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.move.TARDISTeleportLocation;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Vector;

public class DoorUtility {
    public static void set(TARDIS plugin, Player player, Location location) {
        ItemStack is = player.getInventory().getItemInMainHand();
        ItemStack single = is.clone();
        single.setAmount(1);
        if (!is.hasItemMeta()) {
            return;
        }
        ItemMeta im = is.getItemMeta();
        if (!(im.hasDisplayName() && im.getPersistentDataContainer().has(plugin.getCustomBlockKey(), PersistentDataType.STRING) && im.hasItemModel())) {
            return;
        }
        TARDISDisplayItemUtils.set(location, im.getItemModel().getKey(), true);
        ItemDisplay display = (ItemDisplay)location.getWorld().spawnEntity(location.add(0.5, 0.0, 0.5), EntityType.ITEM_DISPLAY);
        display.getPersistentDataContainer().set(plugin.getCustomBlockKey(), PersistentDataType.INTEGER, (Object)10000);
        display.setItemStack(single);
        display.setPersistent(true);
        display.setInvulnerable(true);
        display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.FIXED);
        float yaw = DoorUtility.getLookAtYaw(player);
        display.setRotation(yaw, 0.0f);
    }

    public static float getLookAtYaw(Player player) {
        Vector motion = player.getEyeLocation().getDirection().multiply(-1);
        double dx = motion.getX();
        double dz = motion.getZ();
        double yaw = 0.0;
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 4.71238898038469 : 1.5707963267948966;
            yaw -= Math.atan(dz / dx);
        } else if (dz < 0.0) {
            yaw = Math.PI;
        }
        double y = -yaw * 180.0 / Math.PI;
        return (float)Math.round(y / 90.0) * 90.0f;
    }

    public static void debugPortal(String block) {
        TARDIS.plugin.debug("Failed to remove portal entry!");
        TARDIS.plugin.debug(block);
        TARDIS.plugin.debug("Current stored locations:");
        for (Map.Entry<Location, TARDISTeleportLocation> map : TARDIS.plugin.getTrackerKeeper().getPortals().entrySet()) {
            if (map.getKey().getWorld().getName().contains("TARDIS") || map.getValue().isAbandoned()) continue;
            TARDIS.plugin.debug(map.getKey().toString());
        }
    }

    public static void playDoorSound(Player player, boolean open, Location location, boolean minecart) {
        if (open) {
            if (!minecart) {
                TARDISSounds.playTARDISSound(location, "tardis_door_close");
            } else {
                player.playSound(player.getLocation(), Sound.BLOCK_IRON_DOOR_CLOSE, 1.0f, 1.0f);
            }
        } else if (!minecart) {
            TARDISSounds.playTARDISSound(location, "tardis_door_open");
        } else {
            player.playSound(player.getLocation(), Sound.BLOCK_IRON_DOOR_OPEN, 1.0f, 1.0f);
        }
    }
}

