/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.doors;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.keys.TardisDoorVariant;
import me.eccentric_nz.TARDIS.doors.Door;
import me.eccentric_nz.TARDIS.doors.DoorAnimationData;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class DoorAnimator {
    private final TARDIS plugin;
    private final ItemDisplay display;
    private int taskID;
    private NamespacedKey model = null;
    private int frame = 0;

    public DoorAnimator(TARDIS plugin, ItemDisplay display) {
        this.plugin = plugin;
        this.display = display;
    }

    public void animate(boolean close) {
        Location location = this.display.getLocation();
        ItemStack is = this.display.getItemStack();
        Material material = is.getType();
        DoorAnimationData data = close ? Door.getCloseData(material) : Door.getOpenData(material);
        TARDISSounds.playTARDISSound(location, data.sound());
        this.taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
            if (this.frame > data.animation().length - 1) {
                this.plugin.getServer().getScheduler().cancelTask(this.taskID);
                this.taskID = 0;
                return;
            }
            if (material == Material.IRON_DOOR && !this.plugin.getConfig().getBoolean("police_box.animated_door")) {
                this.model = close ? TardisDoorVariant.TARDIS_DOOR_CLOSED.getKey() : TardisDoorVariant.TARDIS_DOOR_OPEN.getKey();
                this.frame = data.animation().length - 1;
            } else {
                this.model = data.animation()[this.frame];
            }
            ItemMeta im = is.getItemMeta();
            im.setItemModel(this.model);
            is.setItemMeta(im);
            this.display.setItemStack(is);
            ++this.frame;
        }, 2L, data.ticks());
    }
}

