/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import org.bukkit.Location;

public class ResultSetTransmat {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final int id;
    private final String name;
    private final String prefix;
    private int transmat_id;
    private int tardis_id;
    private String transmat_name;
    private String world;
    private float x;
    private float y;
    private float z;
    private float yaw;
    private Location location;

    public ResultSetTransmat(TARDIS plugin, int id, String name) {
        this.plugin = plugin;
        this.id = id;
        this.name = name;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block17: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT * FROM " + this.prefix + "transmats WHERE tardis_id = ? AND name = ?";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setInt(1, this.id);
                statement.setString(2, this.name);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        this.transmat_id = rs.getInt("transmat_id");
                        this.tardis_id = rs.getInt("tardis_id");
                        this.transmat_name = rs.getString("name");
                        this.world = rs.getString("world");
                        this.x = rs.getFloat("x");
                        this.y = rs.getFloat("y");
                        this.z = rs.getFloat("z");
                        this.yaw = rs.getFloat("yaw");
                        this.location = new Location(TARDISAliasResolver.getWorldFromAlias(this.world), (double)this.x, (double)this.y, (double)this.z, this.yaw, 0.0f);
                    }
                    break block17;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for transmats table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing transmats table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public int getTransmat_id() {
        return this.transmat_id;
    }

    public String getWorld() {
        return this.world;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public Location getLocation() {
        return this.location;
    }
}

