/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console.interaction;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.console.models.ThrottleModel;
import me.eccentric_nz.TARDIS.database.InteractionStateSaver;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;

public class ThrottleInteraction {
    private final TARDIS plugin;

    public ThrottleInteraction(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void process(Player player, Interaction interaction, int id) {
        if (this.plugin.getTrackerKeeper().getFlight().containsKey(player.getUniqueId())) {
            return;
        }
        String uuid = player.getUniqueId().toString();
        int unary = (Integer)interaction.getPersistentDataContainer().getOrDefault(this.plugin.getUnaryKey(), PersistentDataType.INTEGER, (Object)-1);
        ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid);
        if (rsp.resultSet()) {
            int delay = rsp.getThrottle() + unary;
            if (delay < 1) {
                delay = 2;
                unary = 1;
            }
            if (delay > 4) {
                delay = 3;
                unary = -1;
            }
            if (delay != 4 && this.plugin.getConfig().getBoolean("difficulty.system_upgrades")) {
                switch (delay) {
                    case 3: {
                        if (new SystemUpgradeChecker(this.plugin).has(uuid, SystemTree.FASTER)) break;
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Faster");
                        delay = 4;
                        break;
                    }
                    case 2: {
                        if (new SystemUpgradeChecker(this.plugin).has(uuid, SystemTree.RAPID)) break;
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Rapid");
                        delay = 4;
                        break;
                    }
                    case 1: {
                        if (new SystemUpgradeChecker(this.plugin).has(uuid, SystemTree.WARP)) break;
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Warp");
                        delay = 4;
                        break;
                    }
                }
            }
            interaction.getPersistentDataContainer().set(this.plugin.getUnaryKey(), PersistentDataType.INTEGER, (Object)unary);
            String throttle = TARDISStringUtils.capitalise(SpaceTimeThrottle.getByDelay().get(delay).toString());
            HashMap<String, Object> wherer = new HashMap<String, Object>();
            wherer.put("uuid", uuid);
            HashMap<String, Object> setr = new HashMap<String, Object>();
            setr.put("throttle", delay);
            this.plugin.getQueryFactory().doUpdate("player_prefs", setr, wherer);
            new InteractionStateSaver(this.plugin).write("THROTTLE", delay, id);
            this.plugin.getMessenger().announceRepeater(player, throttle);
            UUID model = (UUID)interaction.getPersistentDataContainer().get(this.plugin.getModelUuidKey(), this.plugin.getPersistentDataTypeUUID());
            if (model != null) {
                ItemDisplay display = (ItemDisplay)this.plugin.getServer().getEntity(model);
                new ThrottleModel().setState(display, delay);
            }
        }
    }
}

