/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.companionGUI;

import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.companionGUI.TARDISCompanionAddInventory;
import me.eccentric_nz.TARDIS.companionGUI.TARDISCompanionInventory;
import me.eccentric_nz.TARDIS.companionGUI.TARDISEveryoneCompanionInventory;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisCompanions;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISCompanionAddGUIListener
extends TARDISMenuListener {
    private final TARDIS plugin;

    public TARDISCompanionAddGUIListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    public static void addCompanion(int id, String comps, String puid) {
        HashMap<String, Object> tid = new HashMap<String, Object>();
        HashMap<String, Object> set = new HashMap<String, Object>();
        tid.put("tardis_id", id);
        if (comps != null && !comps.isEmpty() && !puid.equalsIgnoreCase("everyone")) {
            String newList = comps + ":" + puid;
            set.put("companions", newList);
        } else {
            set.put("companions", puid);
        }
        TARDIS.plugin.getQueryFactory().doUpdate("tardis", set, tid);
    }

    public static void addToRegion(String world, String owner, String companion) {
        Player player;
        World w = TARDISAliasResolver.getWorldFromAlias(world);
        if (w != null && (player = TARDIS.plugin.getServer().getPlayer(companion)) != null) {
            TARDIS.plugin.getWorldGuardUtils().addMemberToRegion(w, owner, player.getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCompanionAddGUIClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISCompanionAddInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        Player player = (Player)event.getWhoClicked();
        if (slot < 0 || slot > 53) {
            return;
        }
        ItemStack is = event.getView().getItem(slot);
        if (is == null) {
            return;
        }
        switch (slot) {
            case 45: {
                break;
            }
            case 47: {
                this.list(player);
                break;
            }
            case 49: {
                HashMap<String, Object> wherea = new HashMap<String, Object>();
                wherea.put("uuid", player.getUniqueId().toString());
                ResultSetTardis rsa = new ResultSetTardis(this.plugin, wherea, "", false);
                if (!rsa.resultSet()) break;
                Tardis tardis = rsa.getTardis();
                int id = tardis.getTardisId();
                String comps = tardis.getCompanions();
                TARDISCompanionAddGUIListener.addCompanion(id, comps, "everyone");
                if (this.plugin.isWorldGuardOnServer() && this.plugin.getConfig().getBoolean("preferences.use_worldguard")) {
                    String[] data = tardis.getChunk().split(":");
                    this.plugin.getWorldGuardUtils().removeAllMembersFromRegion(TARDISAliasResolver.getWorldFromAlias(data[0]), player.getName(), player.getUniqueId());
                    this.plugin.getWorldGuardUtils().setEntryExitFlags(data[0], player.getName(), true);
                }
                this.list(player);
                break;
            }
            case 53: {
                this.close(player);
                break;
            }
            default: {
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("uuid", player.getUniqueId().toString());
                ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
                if (!rs.resultSet()) break;
                Tardis tardis = rs.getTardis();
                int id = tardis.getTardisId();
                String comps = tardis.getCompanions();
                ItemMeta m = is.getItemMeta();
                List l = m.lore();
                String u = ComponentUtils.stripColour((Component)l.getFirst());
                TARDISCompanionAddGUIListener.addCompanion(id, comps, u);
                if (this.plugin.isWorldGuardOnServer() && this.plugin.getConfig().getBoolean("preferences.use_worldguard")) {
                    String[] data = tardis.getChunk().split(":");
                    TARDISCompanionAddGUIListener.addToRegion(data[0], tardis.getOwner(), ComponentUtils.stripColour(m.displayName()));
                    this.plugin.getWorldGuardUtils().setEntryExitFlags(data[0], player.getName(), false);
                }
                this.list(player);
            }
        }
    }

    private void list(Player player) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            ResultSetTardisCompanions rs = new ResultSetTardisCompanions(this.plugin);
            if (rs.fromUUID(player.getUniqueId().toString())) {
                String comps = rs.getCompanions();
                Object items = comps.equalsIgnoreCase("everyone") ? new TARDISEveryoneCompanionInventory(this.plugin, player) : new TARDISCompanionInventory(this.plugin, comps.split(":"));
                player.openInventory(items.getInventory());
            }
        }, 5L);
    }
}

