/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.utils;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.commands.utils.TARDISWeather;
import me.eccentric_nz.TARDIS.commands.utils.TARDISWeatherInventory;
import me.eccentric_nz.TARDIS.control.TARDISAtmosphericExcitation;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class TARDISWeatherListener
extends TARDISMenuListener {
    private final TARDIS plugin;

    public TARDISWeatherListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onWeatherMenuInteract(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISWeatherInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        Player player = (Player)event.getWhoClicked();
        if (!this.plugin.getConfig().getBoolean("allow.weather_set")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WEATHER_DISABLED");
            this.close(player);
            return;
        }
        if (slot < 0 || slot > 8) {
            return;
        }
        ItemStack is = event.getView().getItem(slot);
        if (is == null) {
            return;
        }
        HashMap<String, Object> wheres = new HashMap<String, Object>();
        wheres.put("uuid", player.getUniqueId().toString());
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheres, false);
        if (!rst.resultSet()) {
            return;
        }
        int id = rst.getTardis_id();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (!rs.resultSet()) {
            return;
        }
        Tardis tardis = rs.getTardis();
        if (!tardis.isTardisInit()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_NO_INIT");
            return;
        }
        if (this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
            return;
        }
        if (!tardis.isHandbrakeOn()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_TRAVELLING");
            return;
        }
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
        if (!rsc.resultSet()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
            this.close(player);
            return;
        }
        Current current = rsc.getCurrent();
        switch (slot) {
            case 0: {
                if (TARDISPermission.hasPermission(player, "tardis.weather.clear")) {
                    TARDISWeather.setClear(current.location().getWorld());
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WEATHER_SET", "clear");
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
                }
                this.close(player);
                break;
            }
            case 1: {
                if (TARDISPermission.hasPermission(player, "tardis.weather.rain")) {
                    TARDISWeather.setRain(current.location().getWorld());
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WEATHER_SET", "rain");
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
                }
                this.close(player);
                break;
            }
            case 2: {
                if (TARDISPermission.hasPermission(player, "tardis.weather.thunder")) {
                    TARDISWeather.setThunder(current.location().getWorld());
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WEATHER_SET", "thunder");
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
                }
                this.close(player);
                break;
            }
            case 5: {
                if (this.plugin.getTrackerKeeper().getExcitation().contains(player.getUniqueId())) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CMD_EXCITE");
                    return;
                }
                new TARDISAtmosphericExcitation(this.plugin).excite(tardis.getTardisId(), player);
                this.plugin.getTrackerKeeper().getExcitation().add(player.getUniqueId());
                this.close(player);
                break;
            }
            case 8: {
                this.close(player);
                break;
            }
        }
    }
}

