/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.utils;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.tardischunkgenerator.worldgen.RoomGenerator;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class TARDISTeleportCommand
extends TARDISCompleter
implements CommandExecutor,
TabCompleter {
    private final TARDIS plugin;
    private final List<String> ROOT_SUBS = new ArrayList<String>();

    public TARDISTeleportCommand(TARDIS plugin) {
        this.plugin = plugin;
        for (World w : plugin.getServer().getWorlds()) {
            this.ROOT_SUBS.add(TARDISAliasResolver.getWorldAlias(w));
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardisteleport")) {
            Player player = null;
            if (sender instanceof Player) {
                player = (Player)sender;
            }
            if (!(args.length != 2 || (player = this.plugin.getServer().getPlayer(args[1])) != null && player.isOnline())) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "COULD_NOT_FIND_NAME");
                return true;
            }
            if (player == null) {
                return true;
            }
            if (args.length < 1) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARG_TP");
                return false;
            }
            World world = TARDISAliasResolver.getWorldFromAlias(args[0]);
            if (world != null) {
                Location spawn;
                if (args[args.length - 1].equals("not_for_players")) {
                    int x = TARDISNumberParsers.parseInt(args[1]);
                    int y = args.length == 5 ? TARDISNumberParsers.parseInt(args[2]) : 64;
                    int z = TARDISNumberParsers.parseInt(args.length == 5 ? args[3] : args[2]);
                    spawn = new Location(world, (double)x, (double)y, (double)z);
                } else {
                    spawn = world.getGenerator() instanceof RoomGenerator ? new Location(world, 8.0, 68.0, 8.0) : world.getSpawnLocation();
                }
                while (!world.getChunkAt(spawn).isLoaded()) {
                    world.getChunkAt(spawn).load();
                }
                int highest = spawn.getBlockY();
                if (!spawn.getBlock().getType().isAir() || !spawn.getBlock().getRelative(BlockFace.UP).getType().isAir()) {
                    highest = world.getEnvironment() == World.Environment.NETHER ? spawn.getBlockY() : world.getHighestBlockYAt(spawn) + 1;
                }
                float yaw = player.getLocation().getYaw();
                float pitch = player.getLocation().getPitch();
                spawn.setYaw(yaw);
                spawn.setPitch(pitch);
                spawn.setY((double)highest);
                player.teleport(spawn);
            } else {
                this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "WORLD_NOT_FOUND", "/tardisworld", this.plugin);
            }
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length <= 1) {
            List<String> part = this.partial(args[0], this.ROOT_SUBS);
            return !part.isEmpty() ? part : null;
        }
        if (args.length == 2) {
            return null;
        }
        return ImmutableList.of();
    }
}

