/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.remote;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisPreset;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISRemoteHideCommand {
    private final TARDIS plugin;

    public TARDISRemoteHideCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean doRemoteHide(CommandSender sender, int id) {
        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NOT_IN_VORTEX");
            return true;
        }
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
        if (!rsc.resultSet()) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
            return true;
        }
        OfflinePlayer olp = null;
        if (sender instanceof Player) {
            olp = (OfflinePlayer)sender;
        } else {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (rs.resultSet()) {
                olp = this.plugin.getServer().getOfflinePlayer(rs.getTardis().getUuid());
            }
        }
        ResultSetTardisPreset rs = new ResultSetTardisPreset(this.plugin);
        if (rs.fromID(id) && rs.getPreset().equals((Object)ChameleonPreset.INVISIBLE) && olp != null) {
            this.plugin.getMessenger().send((CommandSender)olp.getPlayer(), TardisModule.TARDIS, "INVISIBILITY_ENGAGED");
            return true;
        }
        UUID uuid = olp.getUniqueId();
        Current current = rsc.getCurrent();
        DestroyData dd = new DestroyData();
        dd.setDirection(current.direction());
        dd.setLocation(current.location());
        dd.setPlayer(olp);
        dd.setHide(false);
        dd.setOutside(false);
        dd.setSubmarine(current.submarine());
        dd.setTardisID(id);
        dd.setThrottle(SpaceTimeThrottle.REBUILD);
        this.plugin.getPresetDestroyer().destroyPreset(dd);
        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TARDIS_HIDDEN", "/tardisremote [player] rebuild");
        HashMap<String, Object> whereh = new HashMap<String, Object>();
        whereh.put("tardis_id", id);
        HashMap<String, Object> seth = new HashMap<String, Object>();
        seth.put("hidden", 1);
        this.plugin.getQueryFactory().doUpdate("tardis", seth, whereh);
        if (this.plugin.getTrackerKeeper().getActiveForceFields().containsKey(uuid)) {
            this.plugin.getTrackerKeeper().getActiveForceFields().remove(uuid);
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "FORCE_FIELD", "OFF");
        }
        return true;
    }
}

