/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.handles;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TARDISHandlesTeleportCommand {
    private final TARDIS plugin;

    public TARDISHandlesTeleportCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void beamMeUp(Player player) {
        int travel;
        Location location = player.getLocation();
        if (this.plugin.getUtils().inTARDISWorld(location)) {
            this.plugin.getMessenger().handlesSend(player, "TARDIS_OUTSIDE");
            return;
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", player.getUniqueId().toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (!rs.resultSet()) {
            this.plugin.getMessenger().handlesSend(player, "NO_TARDIS");
            return;
        }
        Tardis tardis = rs.getTardis();
        int id = tardis.getTardisId();
        if (!tardis.isHandbrakeOn() && !this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
            this.plugin.getMessenger().handlesSend(player, "NOT_WHILE_TRAVELLING");
            return;
        }
        int level = tardis.getArtronLevel();
        if (level < (travel = this.plugin.getArtronConfig().getInt("travel"))) {
            this.plugin.getMessenger().handlesSend(player, "NOT_ENOUGH_ENERGY");
            return;
        }
        if (this.plugin.getPluginRespect().getRespect(location, new Parameters(player, Flag.getAPIFlags()))) {
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            if (!rsc.resultSet()) {
                this.plugin.getMessenger().handlesSend(player, "CURRENT_NOT_FOUND");
                return;
            }
            Current current = rsc.getCurrent();
            int[] start_loc = TARDISTimeTravel.getStartLocation(location, current.direction());
            int count = TARDISTimeTravel.safeLocation(start_loc[0], location.getBlockY(), start_loc[2], start_loc[1], start_loc[3], location.getWorld(), current.direction());
            if (count > 0) {
                this.plugin.getMessenger().handlesSend(player, "RESCUE_NOT_SAFE");
                return;
            }
            HashMap<String, Object> tid = new HashMap<String, Object>();
            tid.put("tardis_id", id);
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("world", location.getWorld().getName());
            set.put("x", location.getBlockX());
            set.put("y", location.getBlockY());
            set.put("z", location.getBlockZ());
            set.put("submarine", current.submarine() ? 1 : 0);
            this.plugin.getQueryFactory().doUpdate("current", set, tid);
            this.plugin.getTrackerKeeper().getHadsDamage().remove(id);
            long delay = 1L;
            this.plugin.getTrackerKeeper().getInVortex().add(id);
            UUID uuid = player.getUniqueId();
            this.plugin.getTrackerKeeper().getRescue().put(id, uuid);
            DestroyData dd = new DestroyData();
            dd.setDirection(current.direction());
            dd.setLocation(current.location());
            dd.setPlayer((OfflinePlayer)player);
            dd.setHide(false);
            dd.setOutside(true);
            dd.setSubmarine(current.submarine());
            dd.setTardisID(id);
            dd.setThrottle(SpaceTimeThrottle.NORMAL);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                this.plugin.getTrackerKeeper().getDematerialising().add(id);
                this.plugin.getPresetDestroyer().destroyPreset(dd);
            }, delay);
            BuildData bd = new BuildData(uuid.toString());
            bd.setDirection(current.direction());
            bd.setLocation(location);
            bd.setMalfunction(false);
            bd.setOutside(true);
            bd.setPlayer((OfflinePlayer)player);
            bd.setRebuild(false);
            bd.setSubmarine(current.submarine());
            bd.setTardisID(id);
            bd.setThrottle(SpaceTimeThrottle.NORMAL);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getPresetBuilder().buildPreset(bd), delay * 2L);
        }
    }
}

