/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.handles;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.handles.TARDISHandlesBrakeCommand;
import me.eccentric_nz.TARDIS.commands.handles.TARDISHandlesDiskCommand;
import me.eccentric_nz.TARDIS.commands.handles.TARDISHandlesLandCommand;
import me.eccentric_nz.TARDIS.commands.handles.TARDISHandlesLockUnlockCommand;
import me.eccentric_nz.TARDIS.commands.handles.TARDISHandlesRemindCommand;
import me.eccentric_nz.TARDIS.commands.handles.TARDISHandlesRemoveCommand;
import me.eccentric_nz.TARDIS.commands.handles.TARDISHandlesSayCommand;
import me.eccentric_nz.TARDIS.commands.handles.TARDISHandlesScanCommand;
import me.eccentric_nz.TARDIS.commands.handles.TARDISHandlesTakeoffCommand;
import me.eccentric_nz.TARDIS.commands.handles.TARDISHandlesTellCommand;
import me.eccentric_nz.TARDIS.commands.handles.TARDISHandlesTimeCommand;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.handles.TARDISHandlesWeirdness;
import me.eccentric_nz.TARDIS.handles.wiki.HandlesWiki;
import me.eccentric_nz.TARDIS.handles.wiki.SearchDialog;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.dialog.DialogLike;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISHandlesCommand
implements CommandExecutor {
    private final TARDIS plugin;

    public TARDISHandlesCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length < 1) {
            return false;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            switch (args[0]) {
                case "wiki": {
                    if (args.length < 2) {
                        Audience.audience((Audience[])new Audience[]{player}).showDialog((DialogLike)new SearchDialog().create());
                        return true;
                    }
                    new HandlesWiki(this.plugin).getLinks(args[1], player);
                    return true;
                }
                case "disk": {
                    return new TARDISHandlesDiskCommand(this.plugin).renameDisk(player, args);
                }
                case "remove": {
                    return new TARDISHandlesRemoveCommand(this.plugin).purge(player);
                }
                case "weird": {
                    TARDISHandlesWeirdness.say(player);
                    return true;
                }
            }
        } else {
            UUID uuid;
            if (args[0].equals("wiki")) {
                this.plugin.getMessenger().send(sender, TardisModule.HANDLES, "HANDLES_NO_COMMAND");
                return true;
            }
            if (!sender.hasPermission("tardis.admin")) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_ADMIN");
                return true;
            }
            if (args.length < 2) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "HANDLES_INTERNAL");
                return true;
            }
            if (args[0].equals("tell")) {
                return new TARDISHandlesTellCommand(this.plugin).message(args);
            }
            try {
                uuid = args[0].equals("brake") ? UUID.fromString(args[2]) : UUID.fromString(args[1]);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "HANDLES_INTERNAL");
                return true;
            }
            Player player = this.plugin.getServer().getPlayer(uuid);
            switch (args[0]) {
                case "land": {
                    return new TARDISHandlesLandCommand(this.plugin).exitVortex(player, TARDISNumberParsers.parseInt(args[2]), args[1]);
                }
                case "lock": 
                case "unlock": {
                    return new TARDISHandlesLockUnlockCommand(this.plugin).toggleLock(player, TARDISNumberParsers.parseInt(args[2]), Boolean.parseBoolean(args[3]));
                }
                case "name": {
                    this.plugin.getMessenger().handlesSend(player, "HANDLES_NAME", player.getName());
                    return true;
                }
                case "remind": {
                    return new TARDISHandlesRemindCommand(this.plugin).doReminder(player, args);
                }
                case "say": {
                    return new TARDISHandlesSayCommand(this.plugin).say(player, args);
                }
                case "scan": {
                    return new TARDISHandlesScanCommand(this.plugin, player, TARDISNumberParsers.parseInt(args[2])).sayScan();
                }
                case "takeoff": {
                    return new TARDISHandlesTakeoffCommand(this.plugin).enterVortex(player, args);
                }
                case "time": {
                    return new TARDISHandlesTimeCommand(this.plugin).sayTime(player);
                }
                case "brake": {
                    return new TARDISHandlesBrakeCommand(this.plugin).park(player, args);
                }
            }
        }
        return false;
    }
}

