/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.arch;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISChameleonArchEvent;
import me.eccentric_nz.TARDIS.api.event.TARDISChameleonArchOffEvent;
import me.eccentric_nz.TARDIS.arch.TARDISArchDisguise;
import me.eccentric_nz.TARDIS.arch.TARDISArchInventory;
import me.eccentric_nz.TARDIS.arch.TARDISArchLibsDisguise;
import me.eccentric_nz.TARDIS.arch.TARDISArchPersister;
import me.eccentric_nz.TARDIS.arch.TARDISRandomName;
import me.eccentric_nz.TARDIS.arch.TARDISWatchData;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISFobWatchListener
implements Listener {
    private final TARDIS plugin;

    public TARDISFobWatchListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onFobWatchClick(PlayerInteractEvent event) {
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_AIR)) {
            return;
        }
        ItemStack is = event.getItem();
        if (is == null || !is.getType().equals((Object)Material.CLOCK) || !is.hasItemMeta()) {
            return;
        }
        ItemMeta im = is.getItemMeta();
        if (!im.hasDisplayName() || !ComponentUtils.endsWith(im.displayName(), "Fob Watch")) {
            return;
        }
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        boolean inv = this.plugin.getConfig().getBoolean("arch.switch_inventory");
        if (!this.plugin.getTrackerKeeper().getJohnSmith().containsKey(uuid)) {
            if (!TARDISPermission.hasPermission(player, "tardis.chameleonarch")) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERM_CHAM_ARCH");
                return;
            }
            String name = TARDISRandomName.name();
            long time = System.currentTimeMillis() + this.plugin.getConfig().getLong("arch.min_time") * 60000L;
            TARDISWatchData twd = new TARDISWatchData(name, time);
            this.plugin.getTrackerKeeper().getJohnSmith().put(uuid, twd);
            if (this.plugin.isDisguisesOnServer()) {
                TARDISArchLibsDisguise.undisguise(player);
            } else {
                TARDISArchDisguise.undisguise(player);
            }
            player.getWorld().strikeLightningEffect(player.getLocation());
            double mh = player.getAttribute(Attribute.MAX_HEALTH).getValue();
            player.setHealth(mh / 10.0);
            if (inv) {
                new TARDISArchInventory().switchInventories(player, 0);
            }
            if (this.plugin.isDisguisesOnServer()) {
                TARDISArchLibsDisguise.disguise(player, name);
            } else {
                TARDISArchDisguise.disguise(player, name);
            }
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                TextComponent component = Component.text((String)name);
                player.displayName((Component)component);
                player.playerListName((Component)component);
            }, 5L);
            this.plugin.getPM().callEvent((Event)new TARDISChameleonArchEvent(player, twd));
        } else if (this.plugin.getTrackerKeeper().getJohnSmith().get(uuid).getTime() <= System.currentTimeMillis()) {
            if (this.plugin.isDisguisesOnServer()) {
                TARDISArchLibsDisguise.undisguise(player);
            } else {
                TARDISArchDisguise.undisguise(player);
            }
            if (inv) {
                new TARDISArchInventory().switchInventories(player, 1);
            }
            player.getWorld().strikeLightningEffect(player.getLocation());
            this.plugin.getTrackerKeeper().getJohnSmith().remove(uuid);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                TextComponent component = Component.text((String)player.getName());
                player.displayName((Component)component);
                player.playerListName((Component)component);
            }, 5L);
            new TARDISArchPersister(this.plugin).removeArch(uuid);
            this.plugin.getPM().callEvent((Event)new TARDISChameleonArchOffEvent(player));
        }
    }
}

