/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisvortexmanipulator.database;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.tardisvortexmanipulator.storage.TVMMessage;

public class TVMResultSetMessageById {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final int id;
    private final String prefix;
    private TVMMessage message;

    public TVMResultSetMessageById(TARDIS plugin, int id) {
        this.plugin = plugin;
        this.id = id;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block16: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT * FROM " + this.prefix + "messages WHERE message_id = ?";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setInt(1, this.id);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    rs.next();
                    this.message = new TVMMessage();
                    this.message.setId(rs.getInt("message_id"));
                    this.message.setWho(UUID.fromString(rs.getString("uuid_from")));
                    this.message.setMessage(rs.getString("message"));
                    this.message.setDate(this.getFormattedDate(rs.getLong("date")));
                    break block16;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("Warp error for saves table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing saves table for warp! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public TVMMessage getMessage() {
        return this.message;
    }

    private String getFormattedDate(long millis) {
        SimpleDateFormat sdf = new SimpleDateFormat(this.plugin.getVortexConfig().getString("date_format"));
        Date theDate = new Date(millis);
        return sdf.format(theDate);
    }
}

