/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.logging;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;

public class TextUtils {
    private static final Logger logger = (Logger)LogManager.getRootLogger();
    private static final String STANDARD_STACKTRACE_PREFIX = "at ";
    private static final String SKIPPING_LINES_STRING = "\t...";
    private static final String CAUSE_STACKTRACE_PREFIX = "Caused by:";
    private static final String SUPPRESSED_STACKTRACE_PREFIX = "Suppressed:";
    private static final String RELEVANT_PACKAGE_SYSTEM_ENVIRONMENT_VARIABLE = "MGNT_RELEVANT_PACKAGE";
    private static final String RELEVANT_PACKAGE_SYSTEM_PROPERTY = "mgnt.relevant.package";
    private static String RELEVANT_PACKAGE = null;

    private static void initRelevantPackageFromSystemProperty() {
        String relevantPackage = System.getProperty(RELEVANT_PACKAGE_SYSTEM_PROPERTY);
        if (TextUtils.isBlank(relevantPackage)) {
            relevantPackage = System.getenv(RELEVANT_PACKAGE_SYSTEM_ENVIRONMENT_VARIABLE);
        }
        if (TextUtils.isNotBlank(relevantPackage)) {
            TextUtils.setRelevantPackage(relevantPackage);
        }
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen = TextUtils.length(cs);
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !TextUtils.isBlank(cs);
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static String getStacktrace(Throwable e, boolean cutTBS, String relevantPackage) {
        ByteArrayOutputStream stacktraceContent = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(stacktraceContent));
        return TextUtils.extractStackTrace(cutTBS, relevantPackage, stacktraceContent);
    }

    public static String getStacktrace(Throwable e) {
        return TextUtils.getStacktrace(e, true, null);
    }

    private static String extractStackTrace(boolean cutTBS, String relevantPackage, ByteArrayOutputStream stacktraceContent) {
        String relPack;
        StringBuilder result = new StringBuilder("\n");
        String string = relPack = relevantPackage != null && !relevantPackage.isEmpty() ? relevantPackage : RELEVANT_PACKAGE;
        if ((relPack == null || relPack.isEmpty()) && cutTBS) {
            cutTBS = false;
            logger.warn("Relevant package was not set for the method. Stacktrace can not be shortened. Returning full stacktrace");
        }
        if (cutTBS) {
            if (stacktraceContent.size() > 0) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(stacktraceContent.toByteArray())));){
                    String line = reader.readLine();
                    while ((line = TextUtils.traverseSingularStacktrace(result, relPack, reader, line)) != null) {
                    }
                }
                catch (IOException ioe) {
                    TextUtils.error(ioe);
                    result.delete(0, result.length()).append(stacktraceContent);
                }
            }
        } else {
            result.append(stacktraceContent.toString());
        }
        return result.toString();
    }

    private static String traverseSingularStacktrace(StringBuilder result, String relPack, BufferedReader reader, String line) throws IOException {
        result.append(line).append("\n");
        boolean toBePrinted = true;
        boolean relevantPackageReached = false;
        boolean skipLineToBePrinted = false;
        while ((line = reader.readLine()) != null) {
            String trimmedLine = line.trim();
            if (trimmedLine.startsWith(STANDARD_STACKTRACE_PREFIX)) {
                boolean isCurLineRelevantPack = trimmedLine.substring(STANDARD_STACKTRACE_PREFIX.length()).startsWith(relPack);
                if (!relevantPackageReached && isCurLineRelevantPack) {
                    relevantPackageReached = true;
                    toBePrinted = true;
                    skipLineToBePrinted = false;
                }
                if (toBePrinted) {
                    result.append(line).append("\n");
                } else if (skipLineToBePrinted) {
                    result.append(SKIPPING_LINES_STRING).append("\n");
                    skipLineToBePrinted = false;
                }
                if (!relevantPackageReached || isCurLineRelevantPack) continue;
                relevantPackageReached = false;
                toBePrinted = false;
                skipLineToBePrinted = true;
                continue;
            }
            if (trimmedLine.startsWith(CAUSE_STACKTRACE_PREFIX) || trimmedLine.startsWith(SUPPRESSED_STACKTRACE_PREFIX)) break;
            if (!toBePrinted && !skipLineToBePrinted) continue;
            result.append(line).append("\n");
            skipLineToBePrinted = false;
        }
        return line;
    }

    public static void setRelevantPackage(String relevantPackage) {
        RELEVANT_PACKAGE = relevantPackage;
    }

    private static void error(Throwable t) {
        if (RELEVANT_PACKAGE != null && !RELEVANT_PACKAGE.isEmpty()) {
            logger.error("Error occurred while reading and shortening stacktrace of an exception. Printing the original stacktrace {}", (Object)TextUtils.getStacktrace(t));
        } else {
            logger.error("Error occurred while reading and shortening stacktrace of an exception. Printing the original stacktrace", t);
        }
    }

    static {
        TextUtils.initRelevantPackageFromSystemProperty();
    }
}

