/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Pluraliser {
    private static final HashMap<String, String> irregular = new HashMap<String, String>(){
        {
            this.put("child", "children");
            this.put("die", "dice");
            this.put("foot", "feet");
            this.put("goose", "geese");
            this.put("louse", "lice");
            this.put("man", "men");
            this.put("mouse", "mice");
            this.put("ox", "oxen");
            this.put("person", "people");
            this.put("that", "those");
            this.put("this", "these");
            this.put("tooth", "teeth");
            this.put("woman", "women");
        }
    };
    private static final HashMap<String, String> xExceptions = new HashMap<String, String>(){
        {
            this.put("axis", "axes");
            this.put("barrier", "barrier blocks");
            this.put("carrot on a stick", "carrots on a stick");
            this.put("heart of the sea", "hearts of the sea");
            this.put("jigsaw", "jigsaw blocks");
            this.put("light", "light blocks");
            this.put("lily of the valley", "lilies of the valley");
            this.put("ox", "oxen");
            this.put("potted lily of the valley", "potted lilies of the valley");
            this.put("totem of undying", "totems of undying");
            this.put("warped fungus on a stick", "warped fungi on a stick");
        }
    };
    private static final List<String> endsWithExceptions = List.of("air", "andesite", "armor", "bamboo", "bars", "basalt", "beans", "berries", "bedrock", "boots", "bricks", "cactus", "calcite", "carrots", "crystals", "coal", "concrete", "copper", "debris", "deepslate", "diorite", "dirt", "dust", "fire", "fish", "flesh", "foot", "fungus", "glass", "gold", "granite", "grass", "gravel", "hyphae", " ice", "iron", "leaves", "leggings", "lichen", "meal", "mutton", "nylium", "obsidian", "ore", "planks", "podzol", "potatoes", "powder", "prismarine", "quartz", "roots", "salmon", "sand", "seeds", "snow", "soil", "sprouts", "stairs", "stone", "terracotta", "tiles", "tuff", "vines", "water", "wood", "wool");
    private static final List<String> endsWithExceptionsAddS = List.of("allium", "azalea", "button", "cauldron", "grindstone", "piston", "potion");
    private static final HashMap<String, String> fExceptions = new HashMap<String, String>(){
        {
            this.put("belief", "beliefs");
            this.put("chef", "chefs");
            this.put("chief", "chiefs");
            this.put("dwarf", "dwarfs");
            this.put("grief", "griefs");
            this.put("gulf", "gulfs");
            this.put("handkerchief", "handkerchiefs");
            this.put("kerchief", "kerchiefs");
            this.put("mischief", "mischiefs");
            this.put("muff", "muffs");
            this.put("oaf", "oafs");
            this.put("proof", "proofs");
            this.put("roof", "roofs");
            this.put("safe", "safes");
            this.put("turf", "turfs");
        }
    };
    private static final HashMap<String, String> feExceptions = new HashMap<String, String>(){
        {
            this.put(" safe", "safes");
        }
    };
    private static final HashMap<String, String> oExceptions = new HashMap<String, String>(){
        {
            this.put("albino", "albinos");
            this.put("armadillo", "armadillos");
            this.put("auto", "autos");
            this.put("cameo", "cameos");
            this.put("cello", "cellos");
            this.put("combo", "combos");
            this.put("duo", "duos");
            this.put("ego", "egos");
            this.put("folio", "folios");
            this.put("halo", "halos");
            this.put("inferno", "infernos");
            this.put("lasso", "lassos");
            this.put("memento", "mementos");
            this.put("memo", "memos");
            this.put("piano", "pianos");
            this.put("photo", "photos");
            this.put("portfolio", "portfolios");
            this.put("pro", "pros");
            this.put("silo", "silos");
            this.put("solo", "solos");
            this.put("stereo", "stereos");
            this.put("studio", "studios");
            this.put("taco", "tacos");
            this.put("tattoo", "tattoos");
            this.put("tuxedo", "tuxedos");
            this.put("typo", "typos");
            this.put("veto", "vetoes");
            this.put("video", "videos");
            this.put("yo", "yos");
            this.put("zoo", "zoos");
        }
    };
    private static final HashMap<String, String> usExceptions = new HashMap<String, String>(){
        {
            this.put("abacus", "abacuses");
            this.put("cactus", "cacti");
            this.put("crocus", "crocuses");
            this.put("fungus", "fungi");
            this.put("genus", "genera");
            this.put("octopus", "octopuses");
            this.put("rhombus", "rhombuses");
            this.put("walrus", "walruses");
        }
    };
    private static final HashMap<String, String> umExceptions = new HashMap<String, String>(){
        {
            this.put("album", "albums");
            this.put("stadium", "stadiums");
            this.put("allium", "alliums");
            this.put("nylium", "nylium");
        }
    };
    private static final HashMap<String, String> aExceptions = new HashMap<String, String>(){
        {
            this.put("agenda", "agendas");
            this.put("alfalfa", "alfalfas");
            this.put("azalea", "azaleas");
            this.put("aurora", "auroras");
            this.put("banana", "bananas");
            this.put("barracuda", "barracudas");
            this.put("cornea", "corneas");
            this.put("nova", "novas");
            this.put("phobia", "phobias");
        }
    };
    private static final HashMap<String, String> onExceptions = new HashMap<String, String>(){
        {
            this.put("balloon", "balloons");
            this.put("beacon", "beacons");
            this.put("button", "buttons");
            this.put("carton", "cartons");
            this.put("cauldron", "cauldrons");
            this.put("dandelion", "dandelions");
            this.put("potion", "potions");
            this.put("piston", "pistons");
            this.put("potted dandelion", "potted dandelions");
        }
    };
    private static final HashMap<String, String> exExceptions = new HashMap<String, String>(){
        {
            this.put("annex", "annexes");
            this.put("complex", "complexes");
            this.put("duplex", "duplexes");
            this.put("hex", "hexes");
            this.put("index", "indices");
        }
    };
    private static final List<String> unchanging = List.of("advice", "aircraft", "bamboo", "bison", "bread", "carrots", "clay", "cobweb", "cocoa", "cod", "corn", "debris", "deer", "elytra", "equipment", "evidence", "farmland", "fish", "flint", "glowstone", "gold", "gunpowder", "ice", "information", "jewelry", "kin", "lava", "leather", "legislation", "luck", "luggage", "moose", "music", "mutton", "mycelium", "netherrack", "obsidian", "offspring", "paper", "potatoes", "quartz", "salmon", "scaffolding", "shears", "sheep", "silver", "snow", "string", "sugar", "swine", "trousers", "tnt", "trout", "wheat", "blaze powder", "magma cream");
    private static final List<String> onlyPlurals = List.of("barracks", "bellows", "cattle", "congratulations", "deer", "dregs", "eyeglasses", "gallows", "headquarters", "mathematics", "means", "measles", "mumps", "news", "oats", "pants", "pliers", "pajamas", "scissors", "series", "shears", "shorts", "species", "tongs", "tweezers", "vespers");

    public static String pluralise(String str) {
        for (String string : unchanging) {
            if (!((String)str).equals(string)) continue;
            return str;
        }
        for (Map.Entry entry : xExceptions.entrySet()) {
            if (!((String)str).equals(entry.getKey())) continue;
            return (String)entry.getValue();
        }
        if (((String)str).startsWith("music disc")) {
            String[] split = ((String)str).split(" ");
            return "music discs " + split[2];
        }
        for (String string : endsWithExceptionsAddS) {
            if (!((String)str).endsWith(string)) continue;
            return (String)str + "s";
        }
        for (String string : endsWithExceptions) {
            if (!((String)str).endsWith(string)) continue;
            if (((String)str).endsWith(" foot")) {
                return Pluraliser.removeEnd((String)str, 4) + "feet";
            }
            if (((String)str).endsWith("cactus") || ((String)str).endsWith("fungus")) {
                return Pluraliser.removeEnd((String)str, 2) + "i";
            }
            return str;
        }
        if (((String)str).endsWith("s") || ((String)str).endsWith("x") || ((String)str).endsWith("ch") || ((String)str).endsWith("sh") || ((String)str).endsWith("z")) {
            for (Map.Entry entry : usExceptions.entrySet()) {
                if (!((String)str).equals(entry.getKey())) continue;
                return (String)entry.getValue();
            }
            str = (String)str + "es";
            return str;
        }
        if (((String)str).endsWith("y")) {
            String s = Pluraliser.removeEnd((String)str, 1);
            str = s.endsWith("a") || s.endsWith("e") || s.endsWith("i") || s.endsWith("o") || s.endsWith("u") ? (String)str + "s" : s + "ies";
            return str;
        }
        if (((String)str).endsWith("ff") || ((String)str).endsWith("ffe")) {
            str = (String)str + "s";
            return str;
        }
        if (((String)str).endsWith("f")) {
            for (Map.Entry entry : fExceptions.entrySet()) {
                if (!((String)str).equals(entry.getKey())) continue;
                return (String)entry.getValue();
            }
            str = Pluraliser.removeEnd((String)str, 1) + "ves";
            return str;
        }
        if (((String)str).endsWith("fe")) {
            for (Map.Entry entry : feExceptions.entrySet()) {
                if (!((String)str).equals(entry.getKey())) continue;
                return (String)entry.getValue();
            }
            str = Pluraliser.removeEnd((String)str, 2) + "ves";
            return str;
        }
        if (((String)str).endsWith("o")) {
            for (Map.Entry entry : oExceptions.entrySet()) {
                if (!((String)str).equals(entry.getKey())) continue;
                return (String)entry.getValue();
            }
            str = (String)str + "es";
            return str;
        }
        if (((String)str).endsWith("is")) {
            str = Pluraliser.removeEnd((String)str, 2) + "es";
            return str;
        }
        if (((String)str).endsWith("us")) {
            for (Map.Entry entry : usExceptions.entrySet()) {
                if (!((String)str).equals(entry.getKey())) continue;
                return (String)entry.getValue();
            }
            str = Pluraliser.removeEnd((String)str, 2) + "i";
            return str;
        }
        if (((String)str).endsWith("um")) {
            for (Map.Entry entry : umExceptions.entrySet()) {
                if (!((String)str).equals(entry.getKey())) continue;
                return (String)entry.getValue();
            }
            str = Pluraliser.removeEnd((String)str, 2) + "a";
            return str;
        }
        if (((String)str).endsWith("a")) {
            if (((String)str).endsWith("ia")) {
                str = (String)str + "s";
                return str;
            }
            for (Map.Entry entry : aExceptions.entrySet()) {
                if (!((String)str).equals(entry.getKey())) continue;
                return (String)entry.getValue();
            }
            str = Pluraliser.removeEnd((String)str, 2) + "a";
            return str;
        }
        if (((String)str).endsWith("on")) {
            for (Map.Entry entry : onExceptions.entrySet()) {
                if (!((String)str).equals(entry.getKey())) continue;
                return (String)entry.getValue();
            }
            str = Pluraliser.removeEnd((String)str, 2) + "a";
            return str;
        }
        if (((String)str).endsWith("ex")) {
            for (Map.Entry entry : exExceptions.entrySet()) {
                if (!((String)str).equals(entry.getKey())) continue;
                return (String)entry.getValue();
            }
            str = Pluraliser.removeEnd((String)str, 2) + "ices";
            return str;
        }
        for (String string : onlyPlurals) {
            if (!((String)str).equals(string)) continue;
            return str;
        }
        for (Map.Entry entry : irregular.entrySet()) {
            if (!((String)str).equals(entry.getKey())) continue;
            return (String)entry.getValue();
        }
        str = (String)str + "s";
        return str;
    }

    private static String removeEnd(String str, int numChars) {
        return str.substring(0, str.length() - numChars);
    }
}

