/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.sonic;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.sonic.actions.TARDISSonicReplant;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISMaterials;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISFarmBlockListener
implements Listener {
    private final TARDIS plugin;
    private final Material air = Material.AIR;
    private final Material bs = Material.BEETROOT_SEEDS;
    private final Material ci = Material.CARROT;
    private final Material is = Material.COCOA_BEANS;
    private final Material ms = Material.MELON_SEEDS;
    private final Material nw = Material.NETHER_WART;
    private final Material pi = Material.POTATO;
    private final Material ps = Material.PUMPKIN_SEEDS;
    private final Material sc = Material.SUGAR_CANE;
    private final Material ss = Material.WHEAT_SEEDS;
    private final Material sb = Material.SWEET_BERRIES;
    private final Material ca = Material.CACTUS;
    private final Material pp = Material.PITCHER_POD;
    private final Material tf = Material.TORCHFLOWER;

    public TARDISFarmBlockListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlantHarvest(BlockBreakEvent event) {
        ItemMeta im;
        Player player = event.getPlayer();
        if (!TARDISPermission.hasPermission(player, "tardis.sonic.plant")) {
            return;
        }
        Block block = event.getBlock();
        Material material = block.getType();
        if (!TARDISMaterials.crops.contains(material)) {
            return;
        }
        PlayerInventory inv = player.getInventory();
        ItemStack stack = inv.getItemInMainHand();
        if (stack.getType().equals((Object)Material.BLAZE_ROD) && stack.hasItemMeta() && (im = stack.getItemMeta()).hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "Sonic Screwdriver") && im.hasLore() && im.lore().contains(Component.text((String)"Emerald Upgrade"))) {
            if (material.equals((Object)this.sc) && inv.contains(this.sc)) {
                this.processHarvest(player, this.sc, block);
            } else if (material.equals((Object)this.ca) && inv.contains(this.ca)) {
                this.processHarvest(player, this.ca, block);
            } else if (material.equals((Object)this.tf) && inv.contains(this.tf)) {
                this.processHarvest(player, this.tf, block);
            } else {
                Ageable ageable = (Ageable)block.getBlockData();
                if (ageable.getAge() == ageable.getMaximumAge()) {
                    switch (material) {
                        case BEETROOTS: {
                            if (!inv.contains(this.bs)) break;
                            this.processHarvest(player, this.bs, block);
                            break;
                        }
                        case CARROTS: {
                            if (!inv.contains(this.ci)) break;
                            this.processHarvest(player, this.ci, block);
                            break;
                        }
                        case COCOA: {
                            if (!inv.contains(this.is)) break;
                            this.processHarvest(player, this.is, block);
                            break;
                        }
                        case WHEAT: {
                            if (!inv.contains(this.ss)) break;
                            this.processHarvest(player, this.ss, block);
                            break;
                        }
                        case MELON_STEM: {
                            if (!inv.contains(this.ms)) break;
                            this.processHarvest(player, this.ms, block);
                            break;
                        }
                        case NETHER_WART: {
                            if (!inv.contains(this.nw)) break;
                            this.processHarvest(player, this.nw, block);
                            break;
                        }
                        case POTATOES: {
                            if (!inv.contains(this.pi)) break;
                            this.processHarvest(player, this.pi, block);
                            break;
                        }
                        case PUMPKIN_STEM: {
                            if (!inv.contains(this.ps)) break;
                            this.processHarvest(player, this.ps, block);
                            break;
                        }
                        case SWEET_BERRY_BUSH: {
                            if (!inv.contains(this.sb)) break;
                            this.processHarvest(player, this.sb, block);
                            break;
                        }
                        case PITCHER_CROP: {
                            if (!inv.contains(this.pp)) break;
                            this.processHarvest(player, this.pp, block);
                            break;
                        }
                    }
                }
            }
        }
    }

    private void processHarvest(Player p, Material m, Block b) {
        int slot = p.getInventory().first(m);
        if (slot >= 0) {
            ItemStack next = p.getInventory().getItem(slot);
            if (next.getAmount() > 1) {
                next.setAmount(next.getAmount() - 1);
                p.getInventory().setItem(slot, next);
            } else {
                p.getInventory().setItem(slot, ItemStack.of((Material)this.air));
            }
            TARDISSonicReplant tsr = new TARDISSonicReplant(this.plugin, b, m);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)tsr, 20L);
        }
    }
}

