/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.schematic.actions;

import com.destroystokyo.paper.profile.ProfileProperty;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rooms.TARDISPainting;
import me.eccentric_nz.TARDIS.schematic.getters.DataPackPainting;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISBannerSetter;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISHeadSetter;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISItemDisplaySetter;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISItemFrameSetter;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISPotSetter;
import me.eccentric_nz.TARDIS.schematic.setters.TARDISSignSetter;
import me.eccentric_nz.TARDIS.skins.MannequinSkins;
import me.eccentric_nz.TARDIS.skins.Skin;
import me.eccentric_nz.TARDIS.utility.TARDISBannerData;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SchematicPaster
implements Runnable {
    private final TARDIS plugin;
    private final Player player;
    private final boolean air;
    private final HashMap<Block, BlockData> postRedstoneTorches = new HashMap();
    private final HashMap<Block, BlockData> postRedstoneDust = new HashMap();
    private final HashMap<Block, BlockData> postPistons = new HashMap();
    private final HashMap<Block, TARDISBannerData> postBanners = new HashMap();
    private int task;
    private int l;
    private int r;
    private int h;
    private int w;
    private int d;
    private int x;
    private int y;
    private int z;
    private int counter = 0;
    private double div = 1.0;
    private World world;
    private JsonObject obj;
    private JsonArray arr;
    private boolean running = false;
    private BossBar bb;

    public SchematicPaster(TARDIS plugin, Player player, boolean air) {
        this.plugin = plugin;
        this.player = player;
        this.air = air;
        this.l = 0;
        this.r = 0;
    }

    @Override
    public void run() {
        if (!this.running) {
            Iterator<Map.Entry<Block, BlockData>> uuid = this.player.getUniqueId();
            if (!this.plugin.getTrackerKeeper().getPastes().containsKey(uuid)) {
                this.plugin.getMessenger().message((CommandSender)this.player, TardisModule.TARDIS, "No schematic loaded! /ts load [console|room|structure|user] [name]");
                this.plugin.getServer().getScheduler().cancelTask(this.task);
                this.task = -1;
                return;
            }
            this.obj = this.plugin.getTrackerKeeper().getPastes().get(uuid);
            JsonObject dimensions = this.obj.get("dimensions").getAsJsonObject();
            this.h = dimensions.get("height").getAsInt() - 1;
            this.w = dimensions.get("width").getAsInt();
            this.d = dimensions.get("length").getAsInt() - 1;
            this.div = ((double)this.h + 1.0) * (double)this.w * ((double)this.d + 1.0);
            JsonObject r = this.obj.get("relative").getAsJsonObject();
            int rx = r.get("x").getAsInt();
            int ry = r.get("y").getAsInt();
            int rz = r.get("z").getAsInt();
            this.x = this.player.getLocation().getBlockX() - rx;
            this.y = this.player.getLocation().getBlockY() - ry;
            this.z = this.player.getLocation().getBlockZ() - rz;
            this.world = this.player.getWorld();
            this.arr = this.obj.get("input").getAsJsonArray();
            this.bb = Bukkit.createBossBar((String)"TARDIS Schematic Paste Progress", (BarColor)BarColor.WHITE, (BarStyle)BarStyle.SOLID, (BarFlag[])TARDISConstants.EMPTY_ARRAY);
            this.bb.setProgress(0.0);
            this.bb.addPlayer(this.player);
            this.bb.setVisible(true);
            this.running = true;
        }
        if (this.l == this.h && this.r == this.w - 1) {
            COMPASS facing;
            String which;
            for (Map.Entry<Block, BlockData> map : this.postRedstoneTorches.entrySet()) {
                ((Block)map.getKey()).setBlockData((BlockData)map.getValue());
                if (!TARDIS.plugin.getBlockLogger().isLogging()) continue;
                TARDIS.plugin.getBlockLogger().logPlacement(map.getKey());
            }
            for (Map.Entry<Block, BlockData> map : this.postRedstoneDust.entrySet()) {
                map.getKey().setBlockData(map.getValue());
                if (!TARDIS.plugin.getBlockLogger().isLogging()) continue;
                TARDIS.plugin.getBlockLogger().logPlacement(map.getKey());
            }
            for (Map.Entry<Block, BlockData> map : this.postPistons.entrySet()) {
                map.getKey().setBlockData(map.getValue());
                if (!TARDIS.plugin.getBlockLogger().isLogging()) continue;
                TARDIS.plugin.getBlockLogger().logPlacement(map.getKey());
            }
            TARDISBannerSetter.setBanners(this.postBanners);
            if (this.obj.has("mannequins")) {
                JsonArray mannequins = this.obj.get("mannequins").getAsJsonArray();
                for (int i = 0; i < mannequins.size(); ++i) {
                    JsonObject mannequin = mannequins.get(i).getAsJsonObject();
                    JsonObject rel = mannequin.get("rel_location").getAsJsonObject();
                    int mx = rel.get("x").getAsInt();
                    int my = rel.get("y").getAsInt();
                    int mz = rel.get("z").getAsInt();
                    Location ml = new Location(this.world, (double)(this.x + mx) + 0.5, (double)(this.y + my), (double)(this.z + mz) + 0.5);
                    Mannequin m = (Mannequin)this.world.spawnEntity(ml, EntityType.MANNEQUIN);
                    m.setRotation(mannequin.get("rotation").getAsFloat(), 0.0f);
                    m.setBodyYaw(mannequin.get("yaw").getAsFloat());
                    which = mannequin.get("type").getAsString();
                    m.getPersistentDataContainer().set(TARDISWeepingAngels.MONSTER_HEAD, PersistentDataType.STRING, (Object)which);
                    Skin skin = MannequinSkins.getByName.getOrDefault(which, MannequinSkins.ROMAN);
                    m.setProfile((ResolvableProfile)ResolvableProfile.resolvableProfile().name("").uuid(UUID.randomUUID()).addProperty(new ProfileProperty("textures", skin.value(), skin.signature())).build());
                    m.setSilent(true);
                    m.setAI(false);
                    m.setImmovable(true);
                    if (!mannequin.has("hand")) continue;
                    m.setMainHand(mannequin.get("hand").getAsString().equals("left") ? MainHand.LEFT : MainHand.RIGHT);
                    m.getEquipment().setItemInMainHand(ItemStack.of((Material)(mannequin.get("item").getAsString().equals("IRON_SWORD") ? Material.IRON_SWORD : Material.IRON_SPEAR)));
                }
            }
            if (this.obj.has("armour_stands")) {
                JsonArray stands = this.obj.get("armour_stands").getAsJsonArray();
                for (int i = 0; i < stands.size(); ++i) {
                    JsonObject stand = stands.get(i).getAsJsonObject();
                    JsonObject rel = stand.get("rel_location").getAsJsonObject();
                    int asx = rel.get("x").getAsInt();
                    int asy = rel.get("y").getAsInt();
                    int asz = rel.get("z").getAsInt();
                    facing = COMPASS.valueOf(BlockFace.valueOf((String)stand.get("facing").getAsString()).getOppositeFace().toString());
                    Location asl = new Location(this.world, (double)(this.x + asx) + 0.5, (double)(this.y + asy), (double)(this.z + asz) + 0.5);
                    ArmorStand as = (ArmorStand)this.world.spawnEntity(asl, EntityType.ARMOR_STAND);
                    as.setRotation(facing.getYaw(), 0.0f);
                    as.setVisible(stand.get("invisible").getAsBoolean());
                    if (!stand.has("head")) continue;
                    JsonObject head = stand.get("head").getAsJsonObject();
                    Material material = Material.valueOf((String)head.get("material").getAsString());
                    NamespacedKey nsk = NamespacedKey.fromString((String)head.get("model").getAsString());
                    ItemStack is = ItemStack.of((Material)material);
                    ItemMeta im = is.getItemMeta();
                    im.setItemModel(nsk);
                    is.setItemMeta(im);
                    as.getEquipment().setHelmet(is);
                }
            }
            if (this.obj.has("paintings")) {
                JsonArray paintings = this.obj.get("paintings").getAsJsonArray();
                for (int i = 0; i < paintings.size(); ++i) {
                    JsonObject painting = paintings.get(i).getAsJsonObject();
                    JsonObject rel = painting.get("rel_location").getAsJsonObject();
                    int px = rel.get("x").getAsInt();
                    int py = rel.get("y").getAsInt();
                    int pz = rel.get("z").getAsInt();
                    facing = BlockFace.valueOf((String)painting.get("facing").getAsString());
                    Location pl = null;
                    which = painting.get("art").getAsString();
                    Art art = null;
                    if (which.contains(":")) {
                        pl = TARDISPainting.calculatePosition(which.split(":")[1], (BlockFace)facing, new Location(this.world, (double)(this.x + px), (double)(this.y + py), (double)(this.z + pz)));
                    } else {
                        art = (Art)RegistryAccess.registryAccess().getRegistry(RegistryKey.PAINTING_VARIANT).get(new NamespacedKey("minecraft", which.toLowerCase(Locale.ROOT)));
                        if (art != null) {
                            pl = TARDISPainting.calculatePosition(art, (BlockFace)facing, new Location(this.world, (double)(this.x + px), (double)(this.y + py), (double)(this.z + pz)));
                        }
                    }
                    if (pl == null) continue;
                    try {
                        Painting ent = (Painting)this.world.spawnEntity(pl, EntityType.PAINTING);
                        ent.teleport(pl);
                        ent.setFacingDirection((BlockFace)facing, true);
                        if (art != null) {
                            ent.setArt(art, true);
                            continue;
                        }
                        DataPackPainting.setCustomVariant(ent, which);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.debug("Invalid painting location!" + String.valueOf(pl));
                    }
                }
            }
            Location start = new Location(this.world, (double)this.x, (double)this.y, (double)this.z);
            if (this.obj.has("item_frames")) {
                JsonArray frames = this.obj.get("item_frames").getAsJsonArray();
                for (int i = 0; i < frames.size(); ++i) {
                    TARDISItemFrameSetter.curate(frames.get(i).getAsJsonObject(), start, -1);
                }
            }
            if (this.obj.has("item_displays")) {
                JsonArray displays = this.obj.get("item_displays").getAsJsonArray();
                for (int i = 0; i < displays.size(); ++i) {
                    TARDISItemDisplaySetter.fakeBlock(displays.get(i).getAsJsonObject(), start, -1);
                }
            }
            this.plugin.getServer().getScheduler().cancelTask(this.task);
            this.task = -1;
            this.bb.setProgress(1.0);
            this.bb.setVisible(false);
            this.bb.removeAll();
        }
        JsonArray level = (JsonArray)this.arr.get(this.l);
        JsonArray row = (JsonArray)level.get(this.r);
        for (int c = 0; c <= this.d; ++c) {
            ++this.counter;
            JsonObject col = row.get(c).getAsJsonObject();
            BlockData data = this.plugin.getServer().createBlockData(col.get("data").getAsString());
            Block block = this.world.getBlockAt(this.x + this.r, this.y + this.l, this.z + c);
            if (!block.getType().isAir() && this.plugin.getBlockLogger().isLogging()) {
                this.plugin.getBlockLogger().logRemoval(block);
            }
            switch (data.getMaterial()) {
                case AIR: 
                case CAVE_AIR: 
                case VOID_AIR: {
                    if (!this.air) break;
                    block.setBlockData(data, true);
                    break;
                }
                case REDSTONE_TORCH: {
                    this.postRedstoneTorches.put(block, data);
                    break;
                }
                case REDSTONE: {
                    this.postRedstoneDust.put(block, data);
                    break;
                }
                case STICKY_PISTON: {
                    this.postPistons.put(block, data);
                    break;
                }
                case PLAYER_HEAD: 
                case PLAYER_WALL_HEAD: {
                    UUID uuid;
                    JsonObject head;
                    block.setBlockData(data, true);
                    JsonObject jsonObject = head = col.has("head") ? col.get("head").getAsJsonObject() : null;
                    if (head == null || !head.has("uuid") || (uuid = UUID.fromString(head.get("uuid").getAsString())) == null) break;
                    TARDISHeadSetter.textureSkull(this.plugin, uuid, head, block);
                    break;
                }
                case DECORATED_POT: {
                    block.setBlockData(data, true);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        if (col.has("pot")) {
                            JsonObject pot = col.get("pot").getAsJsonObject();
                            TARDISPotSetter.decorate(this.plugin, pot, block);
                        }
                    }, 1L);
                    break;
                }
                default: {
                    if (Tag.BANNERS.isTagged((Keyed)data.getMaterial())) {
                        JsonObject state;
                        JsonObject jsonObject = state = col.has("banner") ? col.get("banner").getAsJsonObject() : null;
                        if (state == null) break;
                        TARDISBannerData tbd = new TARDISBannerData(data, state);
                        this.postBanners.put(block, tbd);
                        break;
                    }
                    if (Tag.ALL_SIGNS.isTagged((Keyed)data.getMaterial())) {
                        JsonObject state;
                        JsonObject jsonObject = state = col.has("sign") ? col.get("sign").getAsJsonObject() : null;
                        if (state == null) break;
                        block.setBlockData(data, true);
                        TARDISSignSetter.setSign(block, state, null, 0);
                        break;
                    }
                    block.setBlockData(data, true);
                    if (!this.plugin.getBlockLogger().isLogging()) break;
                    this.plugin.getBlockLogger().logPlacement(block);
                }
            }
            double progress = (double)this.counter / this.div;
            this.bb.setProgress(progress);
            if (c == this.d && this.r < this.w) {
                ++this.r;
            }
            if (c != this.d || this.r != this.w || this.l >= this.h) continue;
            this.r = 0;
            ++this.l;
        }
    }

    public void setTask(int task) {
        this.task = task;
    }
}

