/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.recipes.shaped;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.console.models.ColourType;
import me.eccentric_nz.TARDIS.enumeration.CraftingDifficulty;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ConsoleRecipe {
    private final TARDIS plugin;

    public ConsoleRecipe(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void addRecipes() {
        for (Map.Entry<Material, NamespacedKey> colour : ColourType.LOOKUP.entrySet()) {
            String name = colour.getKey().toString().replace("_CONCRETE_POWDER", "");
            Material material = Material.valueOf((String)(name + "_CONCRETE"));
            ItemStack is = ItemStack.of((Material)material, (int)1);
            ItemMeta im = is.getItemMeta();
            String dn = TARDISStringUtils.capitalise(name) + " Console";
            im.displayName((Component)ComponentUtils.toWhite(dn));
            im.lore(List.of(Component.text((String)"Integration with interaction")));
            im.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)colour.getValue().getKey());
            is.setItemMeta(im);
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, name.toLowerCase(Locale.ROOT) + "_console");
            ShapedRecipe r = new ShapedRecipe(key, is);
            if (this.plugin.getCraftingDifficulty() == CraftingDifficulty.HARD) {
                r.shape(new String[]{"CBC", "LRL", "CBC"});
                r.setIngredient('L', Material.LEVER);
                r.setIngredient('R', Material.COMPARATOR);
            } else {
                r.shape(new String[]{"CBC", "ORO", "CBC"});
                r.setIngredient('O', Material.COMPARATOR);
                r.setIngredient('R', Material.REDSTONE_BLOCK);
            }
            r.setIngredient('C', colour.getKey());
            r.setIngredient('B', Material.BAMBOO_BUTTON);
            this.plugin.getServer().addRecipe((Recipe)r);
            this.plugin.getFigura().getShapedRecipes().put(dn, r);
        }
    }
}

