/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.playerprefs;

import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.GUIKeyPreferences;
import me.eccentric_nz.TARDIS.custommodels.keys.KeyVariant;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class TARDISKeyMenuInventory
implements InventoryHolder {
    private final Inventory inventory;

    public TARDISKeyMenuInventory(TARDIS plugin) {
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 27, (Component)Component.text((String)"TARDIS Key Prefs Menu", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        Material material;
        ItemStack[] itemStacks = new ItemStack[27];
        try {
            material = Material.valueOf((String)TARDIS.plugin.getConfig().getString("preferences.key"));
        }
        catch (IllegalArgumentException e) {
            material = Material.GOLD_NUGGET;
        }
        for (GUIKeyPreferences key : GUIKeyPreferences.values()) {
            ItemMeta im;
            ItemStack is;
            if (key == GUIKeyPreferences.CLOSE || key == GUIKeyPreferences.INSTRUCTIONS || key == GUIKeyPreferences.NAME || key == GUIKeyPreferences.DISPLAY_NAME_COLOUR) {
                is = ItemStack.of((Material)key.getMaterial(), (int)1);
                im = is.getItemMeta();
                im.displayName((Component)Component.text((String)key.getName()));
            } else {
                is = ItemStack.of((Material)material);
                im = is.getItemMeta();
                im.displayName((Component)ComponentUtils.toWhite("TARDIS Key"));
            }
            if (!key.getLore().isEmpty()) {
                if (key.getLore().contains("~")) {
                    String[] split = key.getLore().split("~");
                    ArrayList<TextComponent> components = new ArrayList<TextComponent>();
                    for (String s : split) {
                        components.add(Component.text((String)s));
                    }
                    im.lore(components);
                } else {
                    im.lore(List.of(Component.text((String)key.getLore())));
                }
            }
            if (key.getSlot() < 17) {
                try {
                    KeyVariant variant = KeyVariant.valueOf(key.toString());
                    CustomModelDataComponent component = im.getCustomModelDataComponent();
                    component.setFloats(variant.getFloats());
                    im.setCustomModelDataComponent(component);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            is.setItemMeta(im);
            itemStacks[key.getSlot()] = is;
        }
        return itemStacks;
    }
}

