/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.keys.SonicVariant;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.Sonic;
import me.eccentric_nz.TARDIS.recipes.shaped.SonicScrewdriverRecipe;

public class ResultSetSonic {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final HashMap<String, Object> where;
    private final String prefix;
    private Sonic sonic;

    public ResultSetSonic(TARDIS plugin, HashMap<String, Object> where) {
        this.plugin = plugin;
        this.where = where;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block79: {
            Statement statement = null;
            ResultSet rs = null;
            Object wheres = "";
            if (this.where != null) {
                StringBuilder sbw = new StringBuilder();
                this.where.forEach((key, value) -> sbw.append((String)key).append(" = ? AND "));
                wheres = " WHERE " + String.valueOf(sbw) + "sonic_uuid = ''";
            }
            String query = "SELECT * FROM " + this.prefix + "sonic" + (String)wheres;
            try {
                int s;
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                if (this.where != null) {
                    s = 1;
                    for (Map.Entry<String, Object> entry : this.where.entrySet()) {
                        if (entry.getValue() instanceof String) {
                            statement.setString(s, entry.getValue().toString());
                        } else {
                            statement.setInt(s, (Integer)entry.getValue());
                        }
                        ++s;
                    }
                    this.where.clear();
                }
                if ((rs = statement.executeQuery()).isBeforeFirst()) {
                    rs.next();
                    UUID uUID = UUID.fromString(rs.getString("uuid"));
                    boolean bl = rs.getBoolean("activated");
                    this.sonic = new Sonic(uUID, bl, switch (rs.getString("model")) {
                        case "mark1", "10000001" -> SonicVariant.MARK1.getFloats();
                        case "mark2", "10000002" -> SonicVariant.MARK2.getFloats();
                        case "mark3", "10000003" -> SonicVariant.MARK3.getFloats();
                        case "mark4", "10000004" -> SonicVariant.MARK4.getFloats();
                        case "eighth", "10000008" -> SonicVariant.EIGHTH.getFloats();
                        case "ninth", "10000009" -> SonicVariant.NINTH.getFloats();
                        case "tenth", "10000010" -> SonicVariant.TENTH.getFloats();
                        case "eleventh", "10000011" -> SonicVariant.ELEVENTH.getFloats();
                        case "twelfth", "10000012" -> SonicVariant.TWELFTH.getFloats();
                        case "thirteenth", "10000013" -> SonicVariant.THIRTEENTH.getFloats();
                        case "fourteenth", "10000014" -> SonicVariant.FOURTEENTH.getFloats();
                        case "fifteenth", "10000015" -> SonicVariant.FIFTEENTH.getFloats();
                        case "river_song", "10000031" -> SonicVariant.RIVER_SONG.getFloats();
                        case "master", "10000032" -> SonicVariant.MASTER.getFloats();
                        case "sarah_jane", "10000033" -> SonicVariant.SARAH_JANE.getFloats();
                        case "sonic_probe", "10000034" -> SonicVariant.SONIC_PROBE.getFloats();
                        case "umbrella", "10000035" -> SonicVariant.UMBRELLA.getFloats();
                        case "war", "10000085" -> SonicVariant.WAR.getFloats();
                        default -> SonicScrewdriverRecipe.sonicModelLookup.getOrDefault(this.plugin.getConfig().getString("sonic.default_model").toLowerCase(Locale.ROOT), SonicVariant.ELEVENTH.getFloats());
                    }, rs.getBoolean("bio"), rs.getBoolean("diamond"), rs.getBoolean("emerald"), rs.getBoolean("redstone"), rs.getBoolean("painter"), rs.getBoolean("ignite"), rs.getBoolean("arrow"), rs.getBoolean("knockback"), rs.getBoolean("brush"), rs.getBoolean("conversion"));
                    break block79;
                }
                s = 0;
                return s != 0;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for sonic table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing sonic table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public Sonic getSonic() {
        return this.sonic;
    }
}

