/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISAbandonEvent;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.commands.admin.TARDISAbandonLister;
import me.eccentric_nz.TARDIS.control.TARDISPowerButton;
import me.eccentric_nz.TARDIS.database.converters.TARDISAbandonUpdate;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisAbandoned;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisPreset;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.doors.inner.Inner;
import me.eccentric_nz.TARDIS.doors.inner.InnerDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.inner.InnerDoor;
import me.eccentric_nz.TARDIS.doors.inner.InnerMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterDoor;
import me.eccentric_nz.TARDIS.doors.outer.OuterMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISAbandonCommand {
    private final TARDIS plugin;

    TARDISAbandonCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public static Sign getSign(Location l, COMPASS d, ChameleonPreset p) {
        int signx;
        Sign sign = null;
        World w = l.getWorld();
        int signy = switch (p) {
            case ChameleonPreset.GAZEBO, ChameleonPreset.JAIL, ChameleonPreset.SHROOM, ChameleonPreset.SWAMP -> 3;
            case ChameleonPreset.TORCH, ChameleonPreset.TOILET, ChameleonPreset.TOPSYTURVEY -> 1;
            case ChameleonPreset.APPERTURE, ChameleonPreset.ANGEL, ChameleonPreset.LAMP -> 0;
            default -> 2;
        };
        Block b = new Location(w, (double)(l.getBlockX() + signx), (double)(l.getBlockY() + signy), (double)(l.getBlockZ() + signz)).getBlock();
        if (Tag.WALL_SIGNS.isTagged((Keyed)b.getType())) {
            sign = (Sign)b.getState();
        }
        return sign;
    }

    boolean doAbandon(CommandSender sender, boolean list) {
        if (TARDISPermission.hasPermission(sender, "tardis.abandon") && this.plugin.getConfig().getBoolean("abandon.enabled")) {
            if (list) {
                if (sender.hasPermission("tardis.admin")) {
                    new TARDISAbandonLister(this.plugin).list(sender);
                    return true;
                }
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_PERMS");
            } else {
                ResultSetTardisPreset rsp;
                Player player = null;
                if (sender instanceof Player) {
                    player = (Player)sender;
                }
                if (player == null) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_NO_CONSOLE");
                    return true;
                }
                if (!this.plugin.getConfig().getBoolean("allow.power_down")) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ABANDON_POWER_DOWN");
                    return true;
                }
                ResultSetTardisAbandoned rs = new ResultSetTardisAbandoned(this.plugin);
                if (!rs.fromUUID(player.getUniqueId().toString())) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
                    return true;
                }
                ChameleonPreset preset = rs.getPreset();
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("uuid", player.getUniqueId().toString());
                ResultSetTravellers rst = new ResultSetTravellers(this.plugin, where, false);
                if (!rst.resultSet()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_IN_TARDIS");
                    return true;
                }
                if (preset.equals((Object)ChameleonPreset.JUNK_MODE)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ABANDONED_NOT_JUNK");
                    return true;
                }
                int id = rs.getTardis_id();
                if (rst.getTardis_id() != id) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ABANDONED_OWN");
                    return true;
                }
                if (!rs.isTardis_init()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_NO_INIT");
                    return true;
                }
                if (!rs.isHandbrake_on()) {
                    this.plugin.getMessenger().sendStatus(player, "HANDBRAKE_ENGAGE");
                    return true;
                }
                if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_IN_VORTEX");
                    return true;
                }
                if (this.plugin.getTrackerKeeper().getInVortex().contains(id) || this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getDematerialising().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_MAT");
                    return true;
                }
                new TARDISAbandonUpdate(this.plugin, id, player.getUniqueId().toString()).run();
                if (rs.isPowered_on()) {
                    new TARDISPowerButton(this.plugin, id, player, rs.getPreset(), rs.isPowered_on(), rs.isHidden(), rs.isLights_on(), player.getLocation(), rs.getArtron_level(), rs.getSchematic().getLights()).clickButton();
                }
                if ((rsp = new ResultSetTardisPreset(this.plugin)).fromID(id)) {
                    boolean outerDisplayDoor = rsp.getPreset().usesArmourStand();
                    Inner innerDisplayDoor = new InnerDoor(this.plugin, id).get();
                    UUID playerUUID = player.getUniqueId();
                    if (innerDisplayDoor.display()) {
                        new InnerDisplayDoorCloser(this.plugin).close(innerDisplayDoor.block(), id, playerUUID, true);
                    } else {
                        new InnerMinecraftDoorCloser(this.plugin).close(innerDisplayDoor.block(), id, playerUUID);
                    }
                    if (outerDisplayDoor) {
                        new OuterDisplayDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getDisplay(), id, playerUUID);
                    } else if (rsp.getPreset().hasDoor()) {
                        new OuterMinecraftDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getMinecraft(), id, playerUUID);
                    }
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ABANDONED_SUCCESS");
                ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                if (rsc.resultSet()) {
                    Current current = rsc.getCurrent();
                    this.plugin.getPM().callEvent((Event)new TARDISAbandonEvent(player, id, current.location()));
                    if (preset.usesArmourStand()) {
                        World world = current.location().getWorld();
                        for (Entity e : world.getNearbyEntities(current.location(), 1.1, 1.1, 1.1)) {
                            if (!(e instanceof ArmorStand)) continue;
                            ArmorStand stand = (ArmorStand)e;
                            ItemStack is = stand.getItem(EquipmentSlot.HEAD);
                            ItemMeta im = is.getItemMeta();
                            String pb = "";
                            block0 : switch (preset) {
                                case WEEPING_ANGEL: {
                                    pb = "Weeping Angel";
                                    break;
                                }
                                case PANDORICA: {
                                    pb = "Pandorica";
                                    break;
                                }
                                case SIDRAT: {
                                    pb = "SIDRAT";
                                    break;
                                }
                                case ITEM: {
                                    for (String k : this.plugin.getCustomModelConfig().getConfigurationSection("models").getKeys(false)) {
                                        if (!is.getType().toString().equals(this.plugin.getCustomModelConfig().getString("models." + k + ".item"))) continue;
                                        pb = k;
                                        break block0;
                                    }
                                    break;
                                }
                                default: {
                                    pb = "Police Box";
                                }
                            }
                            TextComponent custom = Component.text((String)("Abandoned " + pb));
                            im.displayName((Component)custom);
                            is.setItemMeta(im);
                            EntityEquipment ee = stand.getEquipment();
                            ee.setHelmet(is, true);
                            stand.customName((Component)custom);
                            stand.setCustomNameVisible(true);
                            break;
                        }
                    } else {
                        Sign sign = TARDISAbandonCommand.getSign(current.location(), current.direction(), preset);
                        if (sign != null) {
                            SignSide front = sign.getSide(Side.FRONT);
                            switch (preset) {
                                case GRAVESTONE: {
                                    front.line(3, (Component)Component.empty());
                                    break;
                                }
                                case JAIL: 
                                case ANGEL: {
                                    front.line(2, (Component)Component.empty());
                                    break;
                                }
                                default: {
                                    front.line(0, (Component)Component.empty());
                                }
                            }
                            sign.update();
                        }
                    }
                }
            }
        } else {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_PERMS_ABANDON");
        }
        return true;
    }
}

