/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.chameleon.gui;

import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.DamageUtility;
import me.eccentric_nz.TARDIS.chameleon.gui.TARDISColourPickerGUI;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetColour;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import net.kyori.adventure.text.Component;
import org.bukkit.Color;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class TARDISColourPickerListener
extends TARDISMenuListener {
    private final TARDIS plugin;

    public TARDISColourPickerListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInteract(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISColourPickerGUI)) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        int slot = event.getRawSlot();
        if (slot < 18 || slot > 53) {
            return;
        }
        InventoryView view = event.getView();
        switch (slot) {
            case 20: {
                this.less(view, 10, 0, 0);
                this.setRed(view);
                break;
            }
            case 24: {
                this.more(view, 10, 0, 0);
                this.setRed(view);
                break;
            }
            case 29: {
                this.less(view, 0, 10, 0);
                this.setGreen(view);
                break;
            }
            case 33: {
                this.more(view, 0, 10, 0);
                this.setGreen(view);
                break;
            }
            case 38: {
                this.less(view, 0, 0, 10);
                this.setBlue(view);
                break;
            }
            case 42: {
                this.more(view, 0, 0, 10);
                this.setBlue(view);
                break;
            }
            case 35: {
                ResultSetTardisID rst = new ResultSetTardisID(this.plugin);
                if (rst.fromUUID(player.getUniqueId().toString())) {
                    int id = rst.getTardisId();
                    Color color = this.getColour(view);
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    set.put("red", color.getRed());
                    set.put("green", color.getGreen());
                    set.put("blue", color.getBlue());
                    ResultSetColour rsc = new ResultSetColour(this.plugin, id);
                    if (rsc.resultSet()) {
                        HashMap<String, Object> where = new HashMap<String, Object>();
                        where.put("tardis_id", id);
                        this.plugin.getQueryFactory().doUpdate("colour", set, where);
                    } else {
                        set.put("tardis_id", id);
                        this.plugin.getQueryFactory().doInsert("colour", set);
                    }
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "COLOUR_SET");
                    DamageUtility.run(this.plugin, DiskCircuit.CHAMELEON, id, player);
                }
                this.close(player);
                break;
            }
            case 53: {
                this.close(player);
                break;
            }
            default: {
                event.setCancelled(true);
            }
        }
    }

    private void less(InventoryView view, int r, int g, int b) {
        int bb;
        int gg;
        ItemStack display = view.getItem(4);
        LeatherArmorMeta meta = (LeatherArmorMeta)display.getItemMeta();
        Color color = meta.getColor();
        int rr = color.getRed() - r;
        if (rr < 0) {
            rr = 0;
        }
        if ((gg = color.getGreen() - g) < 0) {
            gg = 0;
        }
        if ((bb = color.getBlue() - b) < 0) {
            bb = 0;
        }
        List lore = meta.lore();
        lore.set(0, Component.text((String)("Red: " + rr)));
        lore.set(1, Component.text((String)("Green: " + gg)));
        lore.set(2, Component.text((String)("Blue: " + bb)));
        meta.lore(lore);
        meta.setColor(Color.fromRGB((int)rr, (int)gg, (int)bb));
        display.setItemMeta((ItemMeta)meta);
    }

    private void more(InventoryView view, int r, int g, int b) {
        int bb;
        int gg;
        ItemStack display = view.getItem(4);
        LeatherArmorMeta meta = (LeatherArmorMeta)display.getItemMeta();
        Color color = meta.getColor();
        int rr = color.getRed() + r;
        if (rr > 255) {
            rr = 255;
        }
        if ((gg = color.getGreen() + g) > 255) {
            gg = 255;
        }
        if ((bb = color.getBlue() + b) > 255) {
            bb = 255;
        }
        List lore = meta.lore();
        lore.set(0, Component.text((String)("Red: " + rr)));
        lore.set(1, Component.text((String)("Green: " + gg)));
        lore.set(2, Component.text((String)("Blue: " + bb)));
        meta.lore(lore);
        meta.setColor(Color.fromRGB((int)rr, (int)gg, (int)bb));
        display.setItemMeta((ItemMeta)meta);
    }

    private void setRed(InventoryView view) {
        Color color = this.getColour(view);
        ItemStack red = view.getItem(22);
        LeatherArmorMeta meta = (LeatherArmorMeta)red.getItemMeta();
        meta.setColor(Color.fromRGB((int)color.getRed(), (int)0, (int)0));
        red.setItemMeta((ItemMeta)meta);
    }

    private void setGreen(InventoryView view) {
        Color color = this.getColour(view);
        ItemStack green = view.getItem(31);
        LeatherArmorMeta meta = (LeatherArmorMeta)green.getItemMeta();
        meta.setColor(Color.fromRGB((int)0, (int)color.getGreen(), (int)0));
        green.setItemMeta((ItemMeta)meta);
    }

    private void setBlue(InventoryView view) {
        Color color = this.getColour(view);
        ItemStack blue = view.getItem(40);
        LeatherArmorMeta meta = (LeatherArmorMeta)blue.getItemMeta();
        meta.setColor(Color.fromRGB((int)0, (int)0, (int)color.getBlue()));
        blue.setItemMeta((ItemMeta)meta);
    }

    private Color getColour(InventoryView view) {
        ItemStack display = view.getItem(4);
        LeatherArmorMeta meta = (LeatherArmorMeta)display.getItemMeta();
        return meta.getColor();
    }
}

