/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.chameleon.construct;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.chameleon.utils.TARDISStainedGlassLookup;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.converters.lookup.LegacyColourTable;
import me.eccentric_nz.TARDIS.database.converters.lookup.LegacyIdTable;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Door;
import org.bukkit.command.CommandSender;

public class ConstructsConverter {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String prefix;

    public ConstructsConverter(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertConstructs() {
        Statement query = null;
        Statement update = null;
        ResultSet rs = null;
        int i = 0;
        try {
            this.service.testConnection(this.connection);
            this.connection.setAutoCommit(false);
            query = this.connection.prepareStatement("SELECT chameleon_id, blueprintID, blueprintData, glassID FROM " + this.prefix + "chameleon");
            update = this.connection.prepareStatement("UPDATE " + this.prefix + "chameleon set blueprintID = '', blueprintData = ?, stainID = '', stainData = ?, glassID = '', glassData = ? WHERE chameleon_id = ?");
            rs = query.executeQuery();
            Pattern p = Pattern.compile("^\\[\\[[0-9]+");
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    Matcher m;
                    int id = rs.getInt("chameleon_id");
                    String bpID = rs.getString("blueprintID");
                    String bpData = rs.getString("blueprintData");
                    String glID = rs.getString("glassID");
                    if (bpID == null || !(m = p.matcher(bpID)).find()) continue;
                    String[][] bpGrid = new String[10][4];
                    String[][] stGrid = new String[10][4];
                    String[][] glGrid = new String[10][4];
                    JsonArray bpIDJson = JsonParser.parseString((String)bpID).getAsJsonArray();
                    JsonArray bpDataJson = JsonParser.parseString((String)bpData).getAsJsonArray();
                    JsonArray glIDJson = JsonParser.parseString((String)glID).getAsJsonArray();
                    for (int y = 0; y < 10; ++y) {
                        JsonArray bpIDX = bpIDJson.get(y).getAsJsonArray();
                        JsonArray bpDATAX = bpDataJson.get(y).getAsJsonArray();
                        JsonArray glIDX = glIDJson.get(y).getAsJsonArray();
                        for (int x = 0; x < 4; ++x) {
                            Material material = LegacyIdTable.LOOKUP.get(bpIDX.get(x).getAsInt());
                            bpGrid[y][x] = material.createBlockData().getAsString();
                            switch (material) {
                                case WHITE_CARPET: 
                                case WHITE_STAINED_GLASS: 
                                case WHITE_STAINED_GLASS_PANE: 
                                case WHITE_WOOL: 
                                case GREEN_TERRACOTTA: {
                                    String[] split = material.toString().split("_");
                                    split[0] = LegacyColourTable.LOOKUP.get(bpDATAX.get(x).getAsInt());
                                    StringBuilder sb = new StringBuilder();
                                    for (int s = 0; s < split.length; ++s) {
                                        sb.append(split[s]);
                                        if (s == split.length - 1) continue;
                                        sb.append("_");
                                    }
                                    String implode = sb.toString();
                                    material = Material.valueOf((String)implode);
                                    bpGrid[y][x] = material.createBlockData().getAsString();
                                    stGrid[y][x] = TARDISStainedGlassLookup.stainedGlassFromMaterial(null, material).createBlockData().getAsString();
                                    break;
                                }
                                case ACACIA_DOOR: 
                                case BAMBOO_DOOR: 
                                case BIRCH_DOOR: 
                                case CHERRY_DOOR: 
                                case CRIMSON_DOOR: 
                                case DARK_OAK_DOOR: 
                                case IRON_DOOR: 
                                case JUNGLE_DOOR: 
                                case MANGROVE_DOOR: 
                                case OAK_DOOR: 
                                case SPRUCE_DOOR: 
                                case WARPED_DOOR: {
                                    String doorData;
                                    BlockData dbd = material.createBlockData();
                                    Door door = (Door)dbd;
                                    door.setFacing(BlockFace.EAST);
                                    door.setHinge(Door.Hinge.RIGHT);
                                    if (x == 0) {
                                        door.setHalf(Bisected.Half.BOTTOM);
                                    }
                                    if (x == 1) {
                                        door.setHalf(Bisected.Half.TOP);
                                    }
                                    bpGrid[y][x] = doorData = door.getAsString();
                                    stGrid[y][x] = doorData;
                                    break;
                                }
                                case ACACIA_SIGN: 
                                case ACACIA_WALL_SIGN: 
                                case AIR: 
                                case BIRCH_SIGN: 
                                case BIRCH_WALL_SIGN: 
                                case DARK_OAK_SIGN: 
                                case DARK_OAK_WALL_SIGN: 
                                case JUNGLE_SIGN: 
                                case JUNGLE_WALL_SIGN: 
                                case MANGROVE_SIGN: 
                                case MANGROVE_WALL_SIGN: 
                                case OAK_SIGN: 
                                case OAK_WALL_SIGN: 
                                case REDSTONE_TORCH: 
                                case REDSTONE_WALL_TORCH: 
                                case SPRUCE_SIGN: 
                                case SPRUCE_WALL_SIGN: 
                                case TORCH: 
                                case WALL_TORCH: {
                                    stGrid[y][x] = LegacyIdTable.LOOKUP.get(bpIDX.get(x).getAsInt()).createBlockData().getAsString();
                                    break;
                                }
                                default: {
                                    try {
                                        stGrid[y][x] = TARDISStainedGlassLookup.stainedGlassFromMaterial(null, material).createBlockData().getAsString();
                                        break;
                                    }
                                    catch (NullPointerException ex) {
                                        this.plugin.debug(material.toString());
                                    }
                                }
                            }
                            glGrid[y][x] = LegacyIdTable.LOOKUP.get(glIDX.get(x).getAsInt()).createBlockData().getAsString();
                        }
                    }
                    Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                    JsonArray bpArr = JsonParser.parseString((String)gson.toJson((Object)bpGrid)).getAsJsonArray();
                    JsonArray stArr = JsonParser.parseString((String)gson.toJson((Object)stGrid)).getAsJsonArray();
                    JsonArray glArr = JsonParser.parseString((String)gson.toJson((Object)glGrid)).getAsJsonArray();
                    update.setString(1, bpArr.toString());
                    update.setString(2, stArr.toString());
                    update.setString(3, glArr.toString());
                    update.setInt(4, id);
                    update.addBatch();
                    ++i;
                }
            }
            if (i > 0) {
                update.executeBatch();
                this.connection.commit();
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Converted " + i + " Chameleon Construct records");
            }
            this.plugin.getConfig().set("conversions.constructs", (Object)true);
            this.plugin.saveConfig();
        }
        catch (SQLException ex) {
            this.plugin.debug("ResultSet error for chameleon table! " + ex.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (query != null) {
                    query.close();
                }
                if (update != null) {
                    update.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing chameleon table! " + e.getMessage());
            }
        }
    }
}

