/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.builders.exterior;

import java.util.Collections;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.builders.exterior.TARDISBuilderUtility;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.custommodels.keys.ChameleonVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.ColouredVariant;
import me.eccentric_nz.TARDIS.database.data.ParticleData;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetColour;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetParticlePrefs;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.flight.FlightEnd;
import me.eccentric_nz.TARDIS.flight.vehicle.TARDISArmourStand;
import me.eccentric_nz.TARDIS.flight.vehicle.VehicleUtility;
import me.eccentric_nz.TARDIS.particles.Emitter;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.craftbukkit.entity.CraftArmorStand;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.plugin.Plugin;

public class TARDISMaterialisePoliceBox
implements Runnable {
    private final TARDIS plugin;
    private final BuildData bd;
    private final int loops;
    private final ChameleonPreset preset;
    private int task;
    private int i;
    private ItemFrame frame;
    private ArmorStand stand;
    private ItemStack is;
    private Color colour = null;
    private String pb;

    public TARDISMaterialisePoliceBox(TARDIS plugin, BuildData bd, ChameleonPreset preset) {
        this.plugin = plugin;
        this.bd = bd;
        this.loops = this.bd.getThrottle().getLoops();
        this.preset = preset;
        this.i = 0;
    }

    @Override
    public void run() {
        if (this.plugin.getTrackerKeeper().getDematerialising().contains(this.bd.getTardisID())) {
            return;
        }
        World world = this.bd.getLocation().getWorld();
        Block block = this.bd.getLocation().getBlock();
        Block light = block.getRelative(BlockFace.UP, 2);
        Material dye = TARDISBuilderUtility.getMaterialForArmourStand(this.preset, this.bd.getTardisID(), true);
        if (this.i < this.loops) {
            NamespacedKey model;
            if (this.i % 2 == 0) {
                model = switch (dye) {
                    case Material.BLACK_DYE -> ChameleonVariant.BLACK_STAINED.getKey();
                    case Material.BLUE_DYE -> ChameleonVariant.BLUE_STAINED.getKey();
                    case Material.BROWN_DYE -> ChameleonVariant.BROWN_STAINED.getKey();
                    case Material.CYAN_DYE -> ChameleonVariant.CYAN_STAINED.getKey();
                    case Material.GRAY_DYE -> ChameleonVariant.GRAY_STAINED.getKey();
                    case Material.GREEN_DYE -> ChameleonVariant.GREEN_STAINED.getKey();
                    case Material.LIGHT_BLUE_DYE -> ChameleonVariant.LIGHT_BLUE_STAINED.getKey();
                    case Material.LIGHT_GRAY_DYE -> ChameleonVariant.LIGHT_GRAY_STAINED.getKey();
                    case Material.LIME_DYE -> ChameleonVariant.LIME_STAINED.getKey();
                    case Material.MAGENTA_DYE -> ChameleonVariant.MAGENTA_STAINED.getKey();
                    case Material.ORANGE_DYE -> ChameleonVariant.ORANGE_STAINED.getKey();
                    case Material.PINK_DYE -> ChameleonVariant.PINK_STAINED.getKey();
                    case Material.PURPLE_DYE -> ChameleonVariant.PURPLE_STAINED.getKey();
                    case Material.RED_DYE -> ChameleonVariant.RED_STAINED.getKey();
                    case Material.WHITE_DYE -> ChameleonVariant.WHITE_STAINED.getKey();
                    case Material.YELLOW_DYE -> ChameleonVariant.YELLOW_STAINED.getKey();
                    case Material.CYAN_STAINED_GLASS_PANE -> ChameleonVariant.TENNANT_STAINED.getKey();
                    case Material.GRAY_STAINED_GLASS_PANE -> ChameleonVariant.WEEPING_ANGEL_STAINED.getKey();
                    case Material.GREEN_STAINED_GLASS_PANE -> ChameleonVariant.SIDRAT_STAINED.getKey();
                    case Material.ENDER_PEARL -> ChameleonVariant.PANDORICA_STAINED.getKey();
                    case Material.LEATHER_HORSE_ARMOR -> ColouredVariant.TINTED_STAINED.getKey();
                    default -> new NamespacedKey((Plugin)this.plugin, TARDISBuilderUtility.getCustomModelPath(dye.toString()) + "_stained");
                };
                light.setBlockData(TARDISConstants.AIR);
            } else if (this.i % 4 == 1) {
                model = switch (dye) {
                    case Material.BLACK_DYE, Material.BLUE_DYE, Material.BROWN_DYE, Material.CYAN_DYE, Material.GRAY_DYE, Material.GREEN_DYE, Material.LIGHT_BLUE_DYE, Material.LIGHT_GRAY_DYE, Material.LIME_DYE, Material.MAGENTA_DYE, Material.ORANGE_DYE, Material.PINK_DYE, Material.PURPLE_DYE, Material.RED_DYE, Material.WHITE_DYE, Material.YELLOW_DYE, Material.CYAN_STAINED_GLASS_PANE, Material.LEATHER_HORSE_ARMOR -> ChameleonVariant.GLASS.getKey();
                    case Material.GRAY_STAINED_GLASS_PANE -> ChameleonVariant.WEEPING_ANGEL_STAINED.getKey();
                    case Material.GREEN_STAINED_GLASS_PANE -> ChameleonVariant.SIDRAT_STAINED.getKey();
                    case Material.ENDER_PEARL -> ChameleonVariant.PANDORICA_STAINED.getKey();
                    default -> new NamespacedKey((Plugin)this.plugin, TARDISBuilderUtility.getCustomModelPath(dye.toString()) + "_glass");
                };
                light.setBlockData(TARDISConstants.AIR);
            } else {
                model = switch (dye) {
                    case Material.BLACK_DYE -> ChameleonVariant.BLACK_CLOSED.getKey();
                    case Material.BLUE_DYE -> ChameleonVariant.BLUE_CLOSED.getKey();
                    case Material.BROWN_DYE -> ChameleonVariant.BROWN_CLOSED.getKey();
                    case Material.CYAN_DYE -> ChameleonVariant.CYAN_CLOSED.getKey();
                    case Material.GRAY_DYE -> ChameleonVariant.GRAY_CLOSED.getKey();
                    case Material.GREEN_DYE -> ChameleonVariant.GREEN_CLOSED.getKey();
                    case Material.LIGHT_BLUE_DYE -> ChameleonVariant.LIGHT_BLUE_CLOSED.getKey();
                    case Material.LIGHT_GRAY_DYE -> ChameleonVariant.LIGHT_GRAY_CLOSED.getKey();
                    case Material.LIME_DYE -> ChameleonVariant.LIME_CLOSED.getKey();
                    case Material.MAGENTA_DYE -> ChameleonVariant.MAGENTA_CLOSED.getKey();
                    case Material.ORANGE_DYE -> ChameleonVariant.ORANGE_CLOSED.getKey();
                    case Material.PINK_DYE -> ChameleonVariant.PINK_CLOSED.getKey();
                    case Material.PURPLE_DYE -> ChameleonVariant.PURPLE_CLOSED.getKey();
                    case Material.RED_DYE -> ChameleonVariant.RED_CLOSED.getKey();
                    case Material.WHITE_DYE -> ChameleonVariant.WHITE_CLOSED.getKey();
                    case Material.YELLOW_DYE -> ChameleonVariant.YELLOW_CLOSED.getKey();
                    case Material.CYAN_STAINED_GLASS_PANE -> ChameleonVariant.TENNANT_CLOSED.getKey();
                    case Material.GRAY_STAINED_GLASS_PANE -> ChameleonVariant.WEEPING_ANGEL_CLOSED.getKey();
                    case Material.GREEN_STAINED_GLASS_PANE -> ChameleonVariant.SIDRAT_CLOSED.getKey();
                    case Material.ENDER_PEARL -> ChameleonVariant.PANDORICA_CLOSED.getKey();
                    case Material.LEATHER_HORSE_ARMOR -> ColouredVariant.TINTED_CLOSED.getKey();
                    default -> new NamespacedKey((Plugin)this.plugin, TARDISBuilderUtility.getCustomModelPath(dye.toString()) + "_closed");
                };
                Levelled levelled = TARDISConstants.LIGHT;
                levelled.setLevel(this.bd.getExteriorLampLevel());
                light.setBlockData((BlockData)levelled);
            }
            ++this.i;
            if (this.i == 1) {
                UUID uuid;
                ResultSetParticlePrefs rspp;
                ResultSetColour rsc;
                Block under = block.getRelative(BlockFace.DOWN);
                boolean slab = Tag.SLABS.isTagged((Keyed)under.getType());
                TARDISBuilderUtility.saveDoorLocation(this.bd, slab);
                Location spawn = slab ? this.bd.getLocation().subtract(0.0, 0.5, 0.0) : this.bd.getLocation();
                TARDISBlockSetters.rememberBlock(under, this.bd.getTardisID());
                boolean found = false;
                for (Entity e : world.getNearbyEntities(this.bd.getLocation(), 1.0, 1.0, 1.0)) {
                    ItemFrame f;
                    if (e instanceof ArmorStand) {
                        ArmorStand a = (ArmorStand)e;
                        if (((CraftArmorStand)a).getHandle() instanceof TARDISArmourStand) {
                            this.stand = a;
                        } else {
                            this.stand = (ArmorStand)VehicleUtility.spawnStand(spawn).getBukkitEntity();
                            a.remove();
                        }
                        found = true;
                        break;
                    }
                    if (!(e instanceof ItemFrame)) continue;
                    this.frame = f = (ItemFrame)e;
                    found = true;
                    break;
                }
                if (!found || this.stand == null && this.frame != null) {
                    if (this.frame != null) {
                        this.frame.remove();
                    }
                    if (!slab) {
                        TARDISBlockSetters.setUnderDoorBlock(world, under.getX(), under.getY(), under.getZ(), this.bd.getTardisID(), false);
                    }
                    this.stand = (ArmorStand)VehicleUtility.spawnStand(spawn).getBukkitEntity();
                }
                this.stand.setRotation(this.bd.getDirection().getYaw(), 0.0f);
                this.is = ItemStack.of((Material)dye, (int)1);
                if (this.bd.isOutside()) {
                    if (!this.bd.useMinecartSounds()) {
                        Object sound;
                        if (this.preset.equals((Object)ChameleonPreset.JUNK_MODE)) {
                            sound = "junk_land";
                        } else {
                            sound = switch (this.bd.getThrottle()) {
                                case SpaceTimeThrottle.WARP, SpaceTimeThrottle.RAPID, SpaceTimeThrottle.FASTER -> "tardis_land_" + this.bd.getThrottle().toString().toLowerCase(Locale.ROOT);
                                default -> "tardis_land";
                            };
                        }
                        TARDISSounds.playTARDISSound(this.bd.getLocation(), (String)sound);
                    } else {
                        world.playSound(this.bd.getLocation(), Sound.ENTITY_MINECART_INSIDE, 1.0f, 0.0f);
                    }
                }
                block55 : switch (this.preset) {
                    case WEEPING_ANGEL: {
                        this.pb = "Weeping Angel";
                        break;
                    }
                    case PANDORICA: {
                        this.pb = "Pandorica";
                        break;
                    }
                    case SIDRAT: {
                        this.pb = "SIDRAT";
                        break;
                    }
                    case ITEM: {
                        for (String k : this.plugin.getCustomModelConfig().getConfigurationSection("models").getKeys(false)) {
                            if (!dye.toString().equals(this.plugin.getCustomModelConfig().getString("models." + k + ".item"))) continue;
                            this.pb = k;
                            break block55;
                        }
                        break;
                    }
                    default: {
                        this.pb = "Police Box";
                    }
                }
                if (this.preset == ChameleonPreset.COLOURED && (rsc = new ResultSetColour(this.plugin, this.bd.getTardisID())).resultSet()) {
                    this.colour = Color.fromRGB((int)rsc.getRed(), (int)rsc.getGreen(), (int)rsc.getBlue());
                }
                if (this.bd.hasParticles() && (rspp = new ResultSetParticlePrefs(this.plugin)).fromUUID((uuid = this.bd.getPlayer().getUniqueId()).toString())) {
                    ParticleData data = rspp.getData();
                    Emitter emitter = new Emitter(this.plugin, uuid, spawn, data, this.bd.getThrottle().getFlightTime());
                    int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)emitter, 0L, data.getShape().getPeriod());
                    emitter.setTaskID(task);
                }
            }
            ItemMeta im = this.is.getItemMeta();
            im.setItemModel(model);
            if (this.bd.shouldAddSign()) {
                String name = this.bd.getPlayer().getName() + "'s " + this.pb;
                TextComponent custom = Component.text((String)name);
                im.displayName((Component)custom);
                this.stand.customName((Component)custom);
                this.stand.setCustomNameVisible(true);
            }
            if (model == ColouredVariant.TINTED_CLOSED.getKey() && this.preset == ChameleonPreset.COLOURED && this.colour != null) {
                LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)im;
                leatherArmorMeta.setColor(this.colour);
                this.is.setItemMeta((ItemMeta)leatherArmorMeta);
            } else {
                this.is.setItemMeta(im);
            }
            EntityEquipment ee = this.stand.getEquipment();
            ee.setHelmet(this.is, true);
        } else {
            this.plugin.getTrackerKeeper().getMaterialising().removeAll(Collections.singleton(this.bd.getTardisID()));
            this.plugin.getTrackerKeeper().getInVortex().removeAll(Collections.singleton(this.bd.getTardisID()));
            this.plugin.getServer().getScheduler().cancelTask(this.task);
            this.task = 0;
            this.plugin.getTrackerKeeper().getMalfunction().remove(this.bd.getTardisID());
            if (this.plugin.getTrackerKeeper().getDidDematToVortex().contains(this.bd.getTardisID())) {
                this.plugin.getTrackerKeeper().getDidDematToVortex().removeAll(Collections.singleton(this.bd.getTardisID()));
            }
            if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(this.bd.getTardisID())) {
                int taskID = this.plugin.getTrackerKeeper().getDestinationVortex().get(this.bd.getTardisID());
                this.plugin.getServer().getScheduler().cancelTask(taskID);
                this.plugin.getTrackerKeeper().getDestinationVortex().remove(this.bd.getTardisID());
            }
            if (!this.bd.isRebuild()) {
                this.plugin.getTrackerKeeper().getActiveForceFields().remove(this.bd.getPlayer().getPlayer().getUniqueId());
            }
            TARDISDisplayItemUtils.setInteraction(this.stand, this.bd.getTardisID());
            if (this.loops > 3) {
                new FlightEnd(this.plugin).process(this.bd.getTardisID(), this.bd.getPlayer().getPlayer(), this.bd.isMalfunction(), this.bd.isRebuild());
                Object update = this.preset.toString();
                if (this.preset == ChameleonPreset.ITEM) {
                    update = "ITEM:" + this.pb;
                }
                TARDISBuilderUtility.updateChameleonDemat((String)update, this.bd.getTardisID());
            }
        }
    }

    public void setTask(int task) {
        this.task = task;
    }
}

