/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility;

import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.playerprefs.DefaultFontInfo;

public class TARDISStringUtils {
    private static final List<String> numbers = List.of("ZERO", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE");

    public static String capitalise(String s) {
        String[] split = s.split("_");
        StringBuilder builder = new StringBuilder();
        for (String str : split) {
            builder.append(TARDISStringUtils.uppercaseFirst(str)).append(" ");
        }
        return builder.toString().trim();
    }

    public static String switchCapitalise(String s) {
        String[] split = s.split("_");
        StringBuilder builder = new StringBuilder();
        builder.append(split[split.length - 1]);
        for (int i = 0; i < split.length - 1; ++i) {
            builder.append(" ").append(TARDISStringUtils.uppercaseFirst(split[i]));
        }
        return builder.toString();
    }

    public static String sentenceCase(String s) {
        String replaced = s.replace("_", " ");
        return TARDISStringUtils.uppercaseFirst(replaced);
    }

    public static String uppercaseFirst(String s) {
        if (s.equalsIgnoreCase("ii") || s.equalsIgnoreCase("iii") || s.equalsIgnoreCase("iv")) {
            return s.toUpperCase(Locale.ROOT);
        }
        return s.substring(0, 1).toUpperCase(Locale.ROOT) + s.substring(1).toLowerCase(Locale.ROOT).replace("ardis", "ARDIS").replace("idrat", "IDRAT");
    }

    public static String titleCase(String s) {
        String[] split = s.split(" ");
        StringBuilder builder = new StringBuilder();
        for (String str : split) {
            builder.append(TARDISStringUtils.uppercaseFirst(str)).append(" ");
        }
        return builder.toString().trim();
    }

    public static String chemistryCase(String s) {
        String[] split = s.split("-");
        StringBuilder builder = new StringBuilder();
        String prefix = "";
        for (String str : split) {
            builder.append(prefix);
            prefix = "_";
            builder.append(TARDISStringUtils.uppercaseFirst(str));
        }
        return builder.toString().trim();
    }

    public static String fromInt(int i) {
        if (i > 9) {
            return "A big number";
        }
        return numbers.get(i);
    }

    public static String toNumber(String s) {
        return String.format("%s", numbers.indexOf(s));
    }

    public static String toDashedLowercase(String s) {
        return s.toLowerCase(Locale.ROOT).replace("_", "-");
    }

    public static String toLowercaseDashed(String s) {
        return s.toLowerCase(Locale.ROOT).replace(" ", "-");
    }

    public static String toUnderscoredLowercase(String s) {
        return s.toLowerCase(Locale.ROOT).replace(" ", "_");
    }

    public static String toScoredUppercase(String s) {
        return s.toUpperCase(Locale.ROOT).replace("-", "_");
    }

    public static String toUnderscoredUppercase(String s) {
        return s.toUpperCase(Locale.ROOT).replace(" ", "_");
    }

    public static String toEnumUppercase(String s) {
        return s.replace(" ", "_").replace("-", "_").replace("3", "THREE").toUpperCase(Locale.ROOT);
    }

    public static String getValuesFromWallString(String str) {
        String[] split = str.split(": ");
        return split[1];
    }

    public static String rightPad(String message, int length) {
        int size = 0;
        for (char c : message.toCharArray()) {
            DefaultFontInfo info = DefaultFontInfo.getDefaultFontInfo(c);
            size += info.getLength();
            ++size;
        }
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder(message);
        for (int compensated = 0; compensated < length - size; compensated += spaceLength) {
            sb.append(" ");
        }
        return sb.toString();
    }
}

