/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.skins.tv;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.GUITelevision;
import me.eccentric_nz.TARDIS.custommodels.keys.SwitchVariant;
import me.eccentric_nz.TARDIS.handles.wiki.WikiLink;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.skins.ArchSkins;
import me.eccentric_nz.TARDIS.skins.CharacterSkins;
import me.eccentric_nz.TARDIS.skins.CompanionSkins;
import me.eccentric_nz.TARDIS.skins.CyberSkins;
import me.eccentric_nz.TARDIS.skins.DoctorSkins;
import me.eccentric_nz.TARDIS.skins.MonsterSkins;
import me.eccentric_nz.TARDIS.skins.Skin;
import me.eccentric_nz.TARDIS.skins.SkinUtils;
import me.eccentric_nz.TARDIS.skins.tv.TVCharactersInventory;
import me.eccentric_nz.TARDIS.skins.tv.TVCompanionsInventory;
import me.eccentric_nz.TARDIS.skins.tv.TVCyberInventory;
import me.eccentric_nz.TARDIS.skins.tv.TVDoctorsInventory;
import me.eccentric_nz.TARDIS.skins.tv.TVInventory;
import me.eccentric_nz.TARDIS.skins.tv.TVMonstersInventory;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.plugin.Plugin;

public class TVSkinListener
extends TARDISMenuListener {
    private final TARDIS plugin;

    public TVSkinListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onSkinMenuClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder() instanceof TVCharactersInventory || event.getInventory().getHolder() instanceof TVCompanionsInventory || event.getInventory().getHolder() instanceof TVCyberInventory || event.getInventory().getHolder() instanceof TVDoctorsInventory || event.getInventory().getHolder() instanceof TVMonstersInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 35) {
            return;
        }
        InventoryView view = event.getView();
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        ItemStack is = view.getItem(slot);
        if (is == null) {
            return;
        }
        switch (slot) {
            case 29: {
                this.toggleDownloads(view);
                break;
            }
            case 31: {
                this.plugin.getSkinChanger().remove(player);
                Skin skin = SkinUtils.SKINNED.get(uuid);
                SkinUtils.removeExtras(player, skin);
                SkinUtils.SKINNED.remove(uuid);
                break;
            }
            case 33: {
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(new TVInventory(this.plugin).getInventory()), 2L);
                break;
            }
            case 35: {
                this.close(player);
                break;
            }
            default: {
                String which;
                if (SkinUtils.SKINNED.containsKey(uuid)) {
                    SkinUtils.removeExtras(player, SkinUtils.SKINNED.get(uuid));
                }
                Skin skin = ArchSkins.ARI;
                switch (which = ComponentUtils.stripColour(event.getView().title()).split(" ")[0]) {
                    case "Doctor": {
                        skin = DoctorSkins.DOCTORS.get(slot);
                        break;
                    }
                    case "Companion": {
                        skin = CompanionSkins.COMPANIONS.get(slot);
                        break;
                    }
                    case "Character": {
                        skin = CharacterSkins.CHARACTERS.get(slot);
                        break;
                    }
                    case "Monster": {
                        skin = MonsterSkins.MONSTERS.get(slot);
                        break;
                    }
                    case "Cyberman": {
                        skin = CyberSkins.VARIANTS.get(slot);
                    }
                }
                if (this.isDownload(view)) {
                    this.plugin.getMessenger().sendWikiLink(player, new WikiLink("Download " + skin.name() + " skin file", skin.url(), true));
                } else {
                    this.plugin.getSkinChanger().set(player, skin);
                    SkinUtils.setExtras(player, skin);
                    SkinUtils.SKINNED.put(uuid, skin);
                }
                this.close(player);
            }
        }
    }

    private void toggleDownloads(InventoryView view) {
        ItemStack is = view.getItem(GUITelevision.DOWNLOAD.slot());
        if (is != null && is.hasItemMeta()) {
            ItemMeta im = is.getItemMeta();
            CustomModelDataComponent component = im.getCustomModelDataComponent();
            boolean on = ((Float)component.getFloats().getFirst()).floatValue() > 200.0f;
            component.setFloats(on ? SwitchVariant.DOWNLOAD_OFF.getFloats() : SwitchVariant.DOWNLOAD_ON.getFloats());
            im.setCustomModelDataComponent(component);
            is.setItemMeta(im);
            view.setItem(GUITelevision.DOWNLOAD.slot(), is);
        }
    }

    private boolean isDownload(InventoryView view) {
        ItemStack is = view.getItem(GUITelevision.DOWNLOAD.slot());
        if (is != null && is.hasItemMeta()) {
            ItemMeta im = is.getItemMeta();
            return im.hasItemModel() && SwitchVariant.DOWNLOAD_ON.getKey().equals((Object)im.getItemModel());
        }
        return false;
    }
}

