/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.move;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.eccentric_nz.TARDIS.ARS.TARDISARSMethods;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TARDISTIPSData;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetARS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCompanions;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetForceFieldCheck;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.lazarus.LazarusVariants;
import me.eccentric_nz.TARDIS.move.TARDISMonster;
import me.eccentric_nz.TARDIS.move.TARDISTeleportLocation;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISDalekDisguiser;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import net.kyori.adventure.text.Component;
import org.bukkit.Difficulty;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AbstractSkeleton;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Pillager;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.persistence.PersistentDataType;

public class TARDISMonsterRunnable
implements Runnable {
    private final TARDIS plugin;
    private final List<EntityType> monsters = new ArrayList<EntityType>();

    public TARDISMonsterRunnable(TARDIS plugin) {
        this.plugin = plugin;
        this.monsters.add(EntityType.BOGGED);
        this.monsters.add(EntityType.CAVE_SPIDER);
        this.monsters.add(EntityType.CREEPER);
        this.monsters.add(EntityType.ENDERMAN);
        this.monsters.add(EntityType.ENDERMITE);
        this.monsters.add(EntityType.HOGLIN);
        this.monsters.add(EntityType.HUSK);
        this.monsters.add(EntityType.PIGLIN);
        this.monsters.add(EntityType.PILLAGER);
        this.monsters.add(EntityType.SILVERFISH);
        this.monsters.add(EntityType.SLIME);
        this.monsters.add(EntityType.SKELETON);
        this.monsters.add(EntityType.SPIDER);
        this.monsters.add(EntityType.STRAY);
        this.monsters.add(EntityType.VEX);
        this.monsters.add(EntityType.VINDICATOR);
        this.monsters.add(EntityType.WITCH);
        this.monsters.add(EntityType.WITHER_SKELETON);
        this.monsters.add(EntityType.ZOGLIN);
        this.monsters.add(EntityType.ZOMBIE);
        this.monsters.add(EntityType.ZOMBIE_VILLAGER);
        this.monsters.add(EntityType.ZOMBIFIED_PIGLIN);
        if (this.plugin.getConfig().getBoolean("allow.guardians")) {
            this.monsters.add(EntityType.GUARDIAN);
        }
    }

    @Override
    public void run() {
        for (Map.Entry<Location, TARDISTeleportLocation> map : this.plugin.getTrackerKeeper().getPortals().entrySet()) {
            Object dn;
            Object e2;
            ResultSetForceFieldCheck hidden;
            if (map.getKey().getWorld().getName().contains("TARDIS") || map.getValue().isAbandoned() || (hidden = new ResultSetForceFieldCheck(this.plugin, map.getValue().getTardisId())).isHidden() || this.plugin.getConfig().getInt("allow.force_field") > 0 && this.plugin.getTrackerKeeper().getActiveForceFields().containsKey(hidden.getUuid())) continue;
            Entity ent = map.getKey().getWorld().spawnEntity(map.getKey(), EntityType.EXPERIENCE_ORB);
            List entities = ent.getNearbyEntities(16.0, 16.0, 16.0);
            ent.remove();
            boolean found = false;
            if (entities.isEmpty()) continue;
            boolean take_action = true;
            for (Object e2 : entities) {
                if (!(e2 instanceof Player)) continue;
                Player player = (Player)e2;
                if (!this.isTimelord(map.getValue().getTardisId(), player)) continue;
                take_action = false;
                break;
            }
            if (!take_action) continue;
            boolean twa = this.plugin.getConfig().getBoolean("modules.weeping_angels");
            e2 = entities.iterator();
            while (e2.hasNext()) {
                Entity e3 = (Entity)e2.next();
                EntityType type = e3.getType();
                TARDISMonster tm = new TARDISMonster();
                dn = TARDISStringUtils.uppercaseFirst(type.toString().toLowerCase(Locale.ROOT));
                if (!this.monsters.contains(type)) continue;
                found = true;
                switch (type) {
                    case CREEPER: {
                        Creeper creeper = (Creeper)e3;
                        tm.setCharged(creeper.isPowered());
                        dn = creeper.isPowered() ? "Charged Creeper" : "Creeper";
                        break;
                    }
                    case ENDERMAN: {
                        Enderman enderman = (Enderman)e3;
                        tm.setCarried(enderman.getCarriedBlock());
                        if (!twa || e3.getPassengers().isEmpty() || !((Entity)e3.getPassengers().getFirst()).getType().equals((Object)EntityType.GUARDIAN)) break;
                        dn = "Silent";
                        break;
                    }
                    case ZOMBIFIED_PIGLIN: {
                        String name;
                        PigZombie pigzombie = (PigZombie)e3;
                        tm.setAggressive(pigzombie.isAngry());
                        tm.setAnger(pigzombie.getAnger());
                        tm.setEquipment(pigzombie.getEquipment());
                        if (twa && pigzombie.getEquipment().getHelmet() != null && pigzombie.getEquipment().getHelmet().hasItemMeta() && pigzombie.getEquipment().getHelmet().getItemMeta().hasDisplayName()) {
                            name = ComponentUtils.stripColour(pigzombie.getEquipment().getHelmet().getItemMeta().displayName());
                            if (!name.equals("Ice Warrior Head") && !name.equals("Strax Head")) break;
                            dn = name.substring(0, name.length() - 5);
                            break;
                        }
                        dn = "Zombified Piglin";
                        break;
                    }
                    case SKELETON: 
                    case STRAY: 
                    case WITHER_SKELETON: {
                        String name;
                        AbstractSkeleton skeleton = (AbstractSkeleton)e3;
                        tm.setEquipment(skeleton.getEquipment());
                        if (twa && skeleton.getEquipment().getHelmet() != null && skeleton.getEquipment().getHelmet().hasItemMeta() && skeleton.getEquipment().getHelmet().getItemMeta().hasDisplayName() && ((name = ComponentUtils.stripColour(skeleton.getEquipment().getHelmet().getItemMeta().displayName())).equals("Dalek Head") || name.equals("Silurian Head") || name.equals("Weeping Angel Head"))) {
                            dn = name.substring(0, name.length() - 5);
                        }
                        if (!type.equals((Object)EntityType.WITHER_SKELETON)) break;
                        dn = "Wither Skeleton";
                        break;
                    }
                    case SLIME: {
                        Slime slime = (Slime)e3;
                        tm.setSize(slime.getSize());
                        break;
                    }
                    case HUSK: 
                    case ZOMBIE: 
                    case ZOMBIE_VILLAGER: {
                        String name;
                        Zombie zombie = (Zombie)e3;
                        tm.setBaby(!zombie.isAdult());
                        tm.setEquipment(zombie.getEquipment());
                        if (twa && zombie.getEquipment().getHelmet() != null && zombie.getEquipment().getHelmet().hasItemMeta() && zombie.getEquipment().getHelmet().getItemMeta().hasDisplayName() && ((name = ComponentUtils.stripColour(zombie.getEquipment().getHelmet().getItemMeta().displayName())).equals("Cyberman Head") || name.equals("Empty Child Head") || name.equals("Sontaran Head") || name.equals("Vashta Nerada Head") || name.equals("Zygon Head"))) {
                            dn = name.substring(0, name.length() - 5);
                        }
                        if (!type.equals((Object)EntityType.ZOMBIE_VILLAGER)) break;
                        ZombieVillager zombie_villager = (ZombieVillager)e3;
                        Villager.Profession prof = zombie_villager.getVillagerProfession();
                        tm.setProfession(prof);
                        dn = "Zombie Villager";
                        break;
                    }
                    case PILLAGER: 
                    case PIGLIN: 
                    case VINDICATOR: {
                        Monster monster = (Monster)e3;
                        tm.setEquipment(monster.getEquipment());
                        dn = TARDISStringUtils.uppercaseFirst(type.toString());
                        break;
                    }
                }
                tm.setDisplayName((String)dn);
                tm.setType(type);
                tm.setAge(e3.getTicksLived());
                tm.setHealth(((LivingEntity)e3).getHealth());
                tm.setName(ComponentUtils.stripColour(e3.customName()));
                if (!e3.getPassengers().isEmpty()) {
                    tm.setPassenger(((Entity)e3.getPassengers().getFirst()).getType());
                }
                this.moveMonster(map.getValue(), tm, e3, type.equals((Object)EntityType.GUARDIAN));
            }
            if (found || !this.plugin.getConfig().getBoolean("preferences.spawn_random_monsters") || TARDISConstants.RANDOM.nextInt(4) != 0 || !this.canSpawn(map.getKey(), TARDISConstants.RANDOM.nextInt(4))) continue;
            HashMap<String, Object> wheret = new HashMap<String, Object>();
            wheret.put("tardis_id", map.getValue().getTardisId());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, wheret, "", false);
            if (!rs.resultSet() || rs.getTardis().getMonsters() >= this.plugin.getConfig().getInt("preferences.spawn_limit")) continue;
            TARDISMonster rtm = new TARDISMonster();
            EntityType type = this.monsters.get(TARDISConstants.RANDOM.nextInt(this.monsters.size()));
            rtm.setType(type);
            dn = TARDISStringUtils.uppercaseFirst(type.toString().toLowerCase(Locale.ROOT));
            if (type.equals((Object)EntityType.ZOMBIE_VILLAGER)) {
                Villager.Profession prof = LazarusVariants.VILLAGER_PROFESSIONS.get(TARDISConstants.RANDOM.nextInt(LazarusVariants.VILLAGER_PROFESSIONS.size()));
                rtm.setProfession(prof);
                dn = "Zombie " + TARDISStringUtils.uppercaseFirst(prof.toString().toLowerCase(Locale.ROOT));
            }
            rtm.setDisplayName((String)dn);
            this.moveMonster(map.getValue(), rtm, null, type.equals((Object)EntityType.GUARDIAN));
        }
    }

    private boolean canSpawn(Location l, int r) {
        Biome biome = l.getBlock().getRelative(this.plugin.getGeneralKeeper().getFaces().get(r), 6).getBiome();
        if (biome.equals((Object)Biome.MUSHROOM_FIELDS)) {
            return false;
        }
        if (this.plugin.isWorldGuardOnServer() && !this.plugin.getWorldGuardUtils().mobsCanSpawnAtLocation(l)) {
            return false;
        }
        return !l.getWorld().getDifficulty().equals((Object)Difficulty.PEACEFUL);
    }

    private void moveMonster(TARDISTeleportLocation tpl, TARDISMonster m, Entity e, boolean guardian) {
        Location loc = null;
        if (guardian) {
            HashMap<String, Object> wherea = new HashMap<String, Object>();
            wherea.put("tardis_id", tpl.getTardisId());
            ResultSetARS rsa = new ResultSetARS(this.plugin, wherea);
            if (rsa.resultSet()) {
                String[][][] json;
                int l = 0;
                int r = 0;
                int c = 0;
                String[][][] stringArray = json = TARDISARSMethods.getGridFromJSON(rsa.getJson());
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String[][] level;
                    String[][] stringArray2 = level = stringArray[i];
                    int n2 = stringArray2.length;
                    for (int j = 0; j < n2; ++j) {
                        String[] row;
                        for (String col : row = stringArray2[j]) {
                            if (col.equals("SNOW_BLOCK")) {
                                HashMap<String, Object> wheret = new HashMap<String, Object>();
                                wheret.put("tardis_id", tpl.getTardisId());
                                ResultSetTardis rs = new ResultSetTardis(this.plugin, wheret, "", false);
                                if (rs.resultSet()) {
                                    int pos = rs.getTardis().getTIPS();
                                    int tx = 0;
                                    int tz = 0;
                                    if (pos != -1) {
                                        TARDISInteriorPostioning tips = new TARDISInteriorPostioning(this.plugin);
                                        TARDISTIPSData coords = tips.getTIPSData(pos);
                                        tx = coords.getCentreX();
                                        tz = coords.getCentreZ();
                                    }
                                    int x = tx + (r - 4) * 16 + 8;
                                    int y = 51 + l * 16;
                                    int z = tz + (c - 4) * 16 + 8;
                                    loc = new Location(tpl.getLocation().getWorld(), (double)x, (double)y, (double)z);
                                    break;
                                }
                            }
                            ++c;
                        }
                        c = 0;
                        ++r;
                    }
                    r = 0;
                    ++l;
                }
            }
        } else {
            loc = tpl.getLocation();
        }
        if (loc != null) {
            if (e != null) {
                e.remove();
            }
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", tpl.getTardisId());
            ResultSetTravellers rs = new ResultSetTravellers(this.plugin, where, false);
            if (rs.resultSet()) {
                TARDISSounds.playTARDISSound(loc, "tardis_cloister_bell", 10.0f);
            } else {
                Player p;
                HashMap<String, Object> wheret = new HashMap<String, Object>();
                wheret.put("tardis_id", tpl.getTardisId());
                ResultSetTardis rst = new ResultSetTardis(this.plugin, wheret, "", false);
                if (rst.resultSet() && (p = this.plugin.getServer().getPlayer(rst.getTardis().getUuid())) != null) {
                    this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "MONSTER", m.getDisplayName());
                }
                HashMap<String, Object> wherer = new HashMap<String, Object>();
                wherer.put("tardis_id", rst.getTardis().getTardisId());
                wherer.put("type", 5);
                wherer.put("secondary", 0);
                ResultSetControls rsc = new ResultSetControls(this.plugin, wherer, false);
                if (rsc.resultSet()) {
                    loc = TARDISStaticLocationGetters.getLocationFromDB(rsc.getLocation());
                    loc.add(0.5, 0.125, 0.5);
                }
            }
            while (!loc.getChunk().isLoaded()) {
                loc.getChunk().load();
            }
            this.plugin.getQueryFactory().doMonsterIncrement(tpl.getTardisId());
            this.plugin.setTardisSpawn(true);
            Entity ent = loc.getWorld().spawnEntity(loc, m.getType());
            switch (m.getType()) {
                case CREEPER: {
                    Creeper creeper = (Creeper)ent;
                    creeper.setPowered(m.isCharged());
                    break;
                }
                case ENDERMAN: {
                    Enderman enderman = (Enderman)ent;
                    if (m.getCarried() == null) break;
                    enderman.setCarriedBlock(m.getCarried());
                    break;
                }
                case ZOMBIFIED_PIGLIN: {
                    PigZombie pigzombie = (PigZombie)ent;
                    pigzombie.setAngry(m.isAggressive());
                    pigzombie.setAnger(m.getAnger());
                    EntityEquipment ep = pigzombie.getEquipment();
                    if (m.getEquipment() == null) break;
                    ep.setArmorContents(m.getEquipment().getArmorContents());
                    ep.setItemInMainHand(m.getEquipment().getItemInMainHand());
                    break;
                }
                case SKELETON: 
                case STRAY: 
                case WITHER_SKELETON: {
                    Skeleton skelly;
                    AbstractSkeleton skeleton = (AbstractSkeleton)ent;
                    EntityEquipment es = skeleton.getEquipment();
                    if (m.getEquipment() == null) break;
                    es.setArmorContents(m.getEquipment().getArmorContents());
                    es.setItemInMainHand(m.getEquipment().getItemInMainHand());
                    if (!this.plugin.getConfig().getBoolean("modules.weeping_angels") || !(skeleton instanceof Skeleton) || !this.isDalek(skelly = (Skeleton)skeleton)) break;
                    TARDISDalekDisguiser.dalekanium(skelly);
                    break;
                }
                case SLIME: {
                    Slime slime = (Slime)ent;
                    if (m.getSize() <= 0) break;
                    slime.setSize(m.getSize());
                    break;
                }
                case VINDICATOR: {
                    Vindicator vindicator = (Vindicator)ent;
                    EntityEquipment ev = vindicator.getEquipment();
                    if (m.getEquipment() == null) break;
                    ev.setArmorContents(m.getEquipment().getArmorContents());
                    ev.setItemInMainHand(m.getEquipment().getItemInMainHand());
                    break;
                }
                case HUSK: 
                case ZOMBIE: {
                    Zombie zombie = (Zombie)ent;
                    if (!m.isBaby()) {
                        zombie.setAdult();
                    }
                    EntityEquipment ez = zombie.getEquipment();
                    if (m.getEquipment() == null) break;
                    ez.setArmorContents(m.getEquipment().getArmorContents());
                    ez.setItemInMainHand(m.getEquipment().getItemInMainHand());
                    break;
                }
                case ZOMBIE_VILLAGER: {
                    ZombieVillager zombie_villager = (ZombieVillager)ent;
                    if (!m.isBaby()) {
                        zombie_villager.setAdult();
                    }
                    if (m.getProfession() != null) {
                        zombie_villager.setVillagerProfession(m.getProfession());
                    }
                    EntityEquipment zv = zombie_villager.getEquipment();
                    if (m.getEquipment() == null) break;
                    zv.setArmorContents(m.getEquipment().getArmorContents());
                    zv.setItemInMainHand(m.getEquipment().getItemInMainHand());
                    break;
                }
                case PILLAGER: {
                    Pillager pillager = (Pillager)ent;
                    EntityEquipment p = pillager.getEquipment();
                    if (m.getEquipment() == null) break;
                    p.setArmorContents(m.getEquipment().getArmorContents());
                    p.setItemInMainHand(m.getEquipment().getItemInMainHand());
                    break;
                }
            }
            if (m.getAge() > 0) {
                ent.setTicksLived(m.getAge());
            }
            if (m.getHealth() > 0.0 && m.getHealth() <= 20.0) {
                ((LivingEntity)ent).setHealth(m.getHealth());
            }
            if (m.getName() != null && !m.getName().isEmpty()) {
                ent.customName((Component)Component.text((String)m.getName()));
            }
            if (m.getPassenger() != null) {
                if (this.plugin.getConfig().getBoolean("modules.weeping_angels") && m.getPassenger().equals((Object)EntityType.GUARDIAN)) {
                    this.plugin.getTardisAPI().setSilentEquipment((LivingEntity)ent, false);
                } else {
                    Entity passenger = loc.getWorld().spawnEntity(loc, m.getPassenger());
                    ent.addPassenger(passenger);
                }
            }
        }
    }

    private boolean isTimelord(int id, Player player) {
        ResultSetCompanions rsc = new ResultSetCompanions(this.plugin, id);
        return rsc.getCompanions().contains(player.getUniqueId());
    }

    private boolean isDalek(Skeleton skeleton) {
        return skeleton.getPersistentDataContainer().has(TARDISWeepingAngels.DALEK, PersistentDataType.INTEGER);
    }
}

