/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.messaging;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.RecipeCategory;
import me.eccentric_nz.TARDIS.enumeration.RecipeItem;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;

public class TARDISRecipeLister {
    private final TARDIS plugin;
    private final CommandSender sender;

    public TARDISRecipeLister(TARDIS plugin, CommandSender sender) {
        this.plugin = plugin;
        this.sender = sender;
    }

    public void list() {
        this.plugin.getMessenger().send(this.sender, TardisModule.TARDIS, "RECIPE_VIEW");
        this.plugin.getMessenger().messageWithColour(this.sender, "Hover over command argument to see a description", "#AAAAAA");
        this.plugin.getMessenger().messageWithColour(this.sender, "Click to view the recipe", "#AAAAAA");
        this.plugin.getMessenger().message(this.sender, "");
        for (RecipeCategory category : RecipeCategory.values()) {
            if (category == RecipeCategory.UNUSED || category == RecipeCategory.UNCRAFTABLE || category == RecipeCategory.CUSTOM_BLOCKS || category == RecipeCategory.ROTORS || category == RecipeCategory.MISC) continue;
            this.plugin.getMessenger().message(this.sender, category.getName());
            for (RecipeItem item : RecipeItem.values()) {
                if (item.getCategory() != category) continue;
                this.plugin.getMessenger().sendRunCommand(this.sender, item.toTabCompletionString(), item.toRecipeString(), category.getColour());
            }
            this.plugin.getMessenger().message(this.sender, "");
        }
        this.plugin.getMessenger().sendShowMore(this.sender, "tardisrecipe");
    }

    public void listMore() {
        this.plugin.getMessenger().message(this.sender, "");
        for (RecipeCategory category : RecipeCategory.values()) {
            if (category != RecipeCategory.CUSTOM_BLOCKS && category != RecipeCategory.ROTORS && category != RecipeCategory.MISC) continue;
            this.plugin.getMessenger().message(this.sender, category.getName());
            for (RecipeItem item : RecipeItem.values()) {
                if (item.getCategory() != category) continue;
                this.plugin.getMessenger().sendRunCommand(this.sender, item.toTabCompletionString(), item.toRecipeString(), category.getColour());
            }
            this.plugin.getMessenger().message(this.sender, "");
        }
    }
}

