/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.flight;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.builders.exterior.TARDISInstantPoliceBox;
import me.eccentric_nz.TARDIS.builders.exterior.TARDISInstantPreset;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetBackLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.destroyers.TARDISDeinstantPreset;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.flight.TARDISLoopingFlightSound;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class TARDISVortexPersister {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String prefix;
    private PreparedStatement ps = null;
    private ResultSet rs = null;
    private int count = 0;

    public TARDISVortexPersister(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    public void save() {
        try {
            this.ps = this.connection.prepareStatement("INSERT INTO " + this.prefix + "vortex (tardis_id, task) VALUES (?, ?)");
            for (Map.Entry<Integer, Integer> map : this.plugin.getTrackerKeeper().getDestinationVortex().entrySet()) {
                this.ps.setInt(1, map.getKey());
                this.ps.setInt(2, map.getValue());
                this.count += this.ps.executeUpdate();
            }
            if (this.count > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Saved " + this.count + " TARDISes floating around in the time vortex.");
            }
        }
        catch (SQLException ex) {
            this.plugin.debug("Insert error for vortex table: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing vortex statement: " + ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        try {
            this.ps = this.connection.prepareStatement("SELECT * FROM " + this.prefix + "vortex");
            this.rs = this.ps.executeQuery();
            int land = 0;
            while (this.rs.next()) {
                int id = this.rs.getInt("tardis_id");
                int task = this.rs.getInt("task");
                if (task < 0) {
                    ResultSetCurrentFromId rsc;
                    HashMap<String, Object> where = new HashMap<String, Object>();
                    where.put("tardis_id", id);
                    ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
                    if (!rs.resultSet()) continue;
                    Tardis tardis = rs.getTardis();
                    UUID uuid = tardis.getUuid();
                    if (task == -1) {
                        HashMap<String, Object> whereb = new HashMap<String, Object>();
                        whereb.put("tardis_id", id);
                        ResultSetBackLocation rsb = new ResultSetBackLocation(this.plugin, whereb);
                        if (rsb.resultSet()) {
                            DestroyData dd = new DestroyData();
                            Location location = new Location(rsb.getWorld(), (double)rsb.getX(), (double)rsb.getY(), (double)rsb.getZ());
                            dd.setLocation(location);
                            dd.setDirection(rsb.getDirection());
                            dd.setSubmarine(rsb.isSubmarine());
                            dd.setTardisID(id);
                            dd.setSiege(false);
                            dd.setThrottle(SpaceTimeThrottle.REBUILD);
                            dd.setPlayer(Bukkit.getOfflinePlayer((UUID)uuid));
                            while (!location.getChunk().isLoaded()) {
                                location.getChunk().load();
                            }
                            new TARDISDeinstantPreset(this.plugin).instaDestroyPreset(dd, false, tardis.getDemat());
                        }
                    }
                    if ((rsc = new ResultSetCurrentFromId(this.plugin, id)).resultSet()) {
                        Current current = rsc.getCurrent();
                        BuildData bd = new BuildData(uuid.toString());
                        bd.setTardisID(id);
                        bd.setLocation(current.location());
                        OfflinePlayer olp = this.plugin.getServer().getOfflinePlayer(uuid);
                        bd.setPlayer(olp);
                        bd.setRebuild(false);
                        bd.setDirection(current.direction());
                        bd.setSubmarine(current.submarine());
                        bd.setMalfunction(false);
                        bd.setThrottle(SpaceTimeThrottle.REBUILD);
                        while (!current.location().getChunk().isLoaded()) {
                            current.location().getChunk().load();
                        }
                        this.plugin.getTrackerKeeper().getMaterialising().add(id);
                        if (tardis.getPreset().usesArmourStand()) {
                            new TARDISInstantPoliceBox(this.plugin, bd, tardis.getPreset()).buildPreset();
                        } else {
                            new TARDISInstantPreset(this.plugin, bd, tardis.getPreset(), Material.LIGHT_GRAY_TERRACOTTA.createBlockData(), false).buildPreset();
                        }
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                            this.plugin.getTrackerKeeper().getInVortex().remove(id);
                            this.plugin.getTrackerKeeper().getDidDematToVortex().remove(id);
                            this.plugin.getTrackerKeeper().getDestinationVortex().remove(id);
                            this.plugin.getTrackerKeeper().getDematerialising().remove(id);
                        }, 20L);
                    }
                    ++land;
                    continue;
                }
                HashMap<String, Object> whereh = new HashMap<String, Object>();
                whereh.put("tardis_id", id);
                whereh.put("type", 0);
                whereh.put("secondary", 0);
                ResultSetControls rsh = new ResultSetControls(this.plugin, whereh, false);
                if (!rsh.resultSet()) continue;
                Location handbrake = TARDISStaticLocationGetters.getLocationFromBukkitString(rsh.getLocation());
                new TARDISLoopingFlightSound(this.plugin, handbrake, id).run();
                ++this.count;
            }
            if (this.count > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Loaded " + this.count + " TARDISes floating in the time vortex.");
            }
            if (land > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Landed " + land + " TARDISes that never got to materialise.");
            }
            this.ps = this.connection.prepareStatement("DELETE FROM " + this.prefix + "vortex");
            this.ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.debug("ResultSet error for vortex table: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing vortex statement or resultset: " + ex.getMessage());
            }
        }
    }
}

