/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.tool;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.MissingFormatArgumentException;
import me.eccentric_nz.TARDIS.database.tool.SQL;
import me.eccentric_nz.TARDIS.database.tool.Table;
import me.eccentric_nz.TARDIS.database.tool.UserInterface;

public class Main {
    public static void main(String[] args) {
        UserInterface.main(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(PrintWriter console, File sqlite, File mysql, String prefix) throws IOException {
        if (!sqlite.canRead()) {
            console.println("Specified original file " + String.valueOf(sqlite) + " does not exist or cannot be read!");
            return;
        }
        if (mysql.exists()) {
            console.println("Specified output file " + String.valueOf(mysql) + " exists, please remove it before running this program!");
            return;
        }
        if (!mysql.createNewFile()) {
            console.println("Could not create specified output file " + String.valueOf(mysql) + " please ensure that it is in a valid directory which can be written to.");
            return;
        }
        if (!prefix.isEmpty()) {
            console.println("***** Using prefix: " + prefix);
        }
        console.println("***** Starting conversion process, please wait.");
        Connection connection = null;
        try {
            try {
                Class.forName("org.sqlite.JDBC");
                connection = DriverManager.getConnection("jdbc:sqlite:" + sqlite.getCanonicalPath());
            }
            catch (ClassNotFoundException e) {
                console.println("***** ERROR: SQLite JDBC driver not found!");
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException ex) {
                        console.println("***** SQL ERROR: " + ex.getMessage());
                    }
                }
                return;
            }
            if (connection == null) {
                console.println("***** ERROR: Could not connect to SQLite database!");
                return;
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(mysql, false));
            bw.write("-- TARDIS SQL Dump");
            bw.newLine();
            bw.newLine();
            bw.write("SET SQL_MODE = \"NO_AUTO_VALUE_ON_ZERO\";");
            bw.newLine();
            bw.newLine();
            Statement statement = connection.createStatement();
            int i = 0;
            for (Table table : Table.values()) {
                console.println("Reading and writing " + table.toString() + " table");
                bw.write("-- --------------------------------------------------------");
                bw.newLine();
                bw.newLine();
                bw.write("--");
                bw.newLine();
                bw.write("-- Table structure for table " + String.valueOf((Object)table));
                bw.newLine();
                bw.write("--");
                bw.newLine();
                bw.newLine();
                try {
                    bw.write(String.format(SQL.CREATES.get(i), prefix));
                }
                catch (MissingFormatArgumentException e) {
                    console.println("CREATES " + String.valueOf((Object)table));
                }
                bw.newLine();
                bw.newLine();
                String count = "SELECT COUNT(*) AS count FROM " + String.valueOf((Object)table);
                ResultSet rsc = statement.executeQuery(count);
                if (rsc.isBeforeFirst()) {
                    rsc.next();
                    int c = rsc.getInt("count");
                    console.println("Found " + c + " " + String.valueOf((Object)table) + " records");
                    String query = "SELECT * FROM " + String.valueOf((Object)table);
                    ResultSet rs = statement.executeQuery(query);
                    if (rs.isBeforeFirst()) {
                        int b = 1;
                        bw.write("--");
                        bw.newLine();
                        bw.write("-- Dumping data for table " + String.valueOf((Object)table));
                        bw.newLine();
                        bw.write("--");
                        bw.newLine();
                        bw.newLine();
                        try {
                            bw.write(String.format(SQL.INSERTS.get(i), prefix));
                        }
                        catch (MissingFormatArgumentException e) {
                            console.println("INSERT " + String.valueOf((Object)table));
                        }
                        bw.newLine();
                        while (rs.next()) {
                            boolean section = b % 100 == 0;
                            String end = b == c || section ? ";" : ",";
                            ++b;
                            try {
                                switch (table) {
                                    case achievements: {
                                        String player = rs.getString("player");
                                        if (rs.wasNull()) {
                                            player = "";
                                        }
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("a_id"), rs.getString("uuid"), player, rs.getString("name"), rs.getString("amount"), rs.getInt("completed")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case arched: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getString("uuid"), rs.getString("arch_name"), rs.getLong("arch_time")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case archive: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("archive_id"), rs.getString("uuid"), rs.getString("name"), rs.getString("console_size"), rs.getInt("beacon"), rs.getInt("lanterns"), rs.getInt("use"), rs.getInt("y"), rs.getString("data"), rs.getString("description")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case areas: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("area_id"), rs.getString("area_name"), rs.getString("world"), rs.getInt("minx"), rs.getInt("minz"), rs.getInt("maxx"), rs.getInt("maxz"), rs.getInt("y"), rs.getInt("parking_distance"), rs.getString("invisibility"), rs.getString("direction"), rs.getInt("grid")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case area_locations: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("area_location_id"), rs.getInt("area_id"), rs.getString("world"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case ars: {
                                        String ars_player = rs.getString("player");
                                        if (rs.wasNull()) {
                                            ars_player = "";
                                        }
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("ars_id"), rs.getInt("tardis_id"), rs.getString("uuid"), ars_player, rs.getInt("ars_x_east"), rs.getInt("ars_z_south"), rs.getInt("ars_y_layer"), rs.getString("json")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case artron_powered: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("a_id"), rs.getInt("tardis_id"), rs.getString("location")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case back: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("back_id"), rs.getInt("tardis_id"), rs.getString("world"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("direction"), rs.getInt("submarine")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case bind: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("bind_id"), rs.getInt("tardis_id"), rs.getInt("type"), rs.getString("location"), rs.getString("name")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case blocks: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("b_id"), rs.getInt("tardis_id"), rs.getString("location"), rs.getString("data"), rs.getInt("police_box")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case blueprint: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("bp_id"), rs.getString("uuid"), rs.getString("permission")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case camera: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("c_id"), rs.getString("uuid"), rs.getString("location")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case chameleon: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("chameleon_id"), rs.getInt("tardis_id"), rs.getString("blueprintData"), rs.getString("stainData"), rs.getString("glassData"), rs.getString("line1"), rs.getString("line2"), rs.getString("line3"), rs.getString("line4"), rs.getInt("active")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case colour: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("colour_id"), rs.getInt("tardis_id"), rs.getInt("red"), rs.getInt("green"), rs.getInt("blue")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case chunks: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("chunk_id"), rs.getInt("tardis_id"), rs.getString("world"), rs.getInt("x"), rs.getInt("z")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case condenser: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("c_id"), rs.getInt("tardis_id"), rs.getString("block_data"), rs.getInt("block_count")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case controls: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("c_id"), rs.getInt("tardis_id"), rs.getInt("type"), rs.getString("location"), rs.getInt("secondary")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case current: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("current_id"), rs.getInt("tardis_id"), rs.getString("world"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("direction"), rs.getInt("submarine"), rs.getString("biome")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case custom_preset: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("custom_id"), rs.getInt("tardis_id"), rs.getString("preset")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case deaths: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getString("uuid"), rs.getString("world"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("direction"), rs.getInt("submarine")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case destinations: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("dest_id"), rs.getInt("tardis_id"), rs.getString("dest_name"), rs.getString("world"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("direction"), rs.getString("preset"), rs.getString("bind"), rs.getInt("type"), rs.getInt("submarine"), rs.getInt("slot"), rs.getInt("icon")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case doors: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("door_id"), rs.getInt("tardis_id"), rs.getInt("door_type"), rs.getString("door_location"), rs.getString("door_direction"), rs.getInt("locked")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case eyes: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("eye_id"), rs.getInt("tardis_id"), rs.getInt("capacitors"), rs.getInt("damaged"), rs.getInt("task")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case farming: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("farm_id"), rs.getInt("tardis_id"), rs.getString("allay"), rs.getString("apiary"), rs.getString("aquarium"), rs.getString("bamboo"), rs.getString("birdcage"), rs.getString("farm"), rs.getString("geode"), rs.getString("happy"), rs.getString("hutch"), rs.getString("igloo"), rs.getString("iistubil"), rs.getString("lava"), rs.getString("mangrove"), rs.getString("pen"), rs.getString("stable"), rs.getString("stall"), rs.getString("village")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case farming_prefs: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("farm_id"), rs.getString("uuid"), rs.getInt("allay"), rs.getInt("apiary"), rs.getInt("aquarium"), rs.getInt("bamboo"), rs.getInt("birdcage"), rs.getInt("farm"), rs.getInt("geode"), rs.getInt("happy"), rs.getInt("hutch"), rs.getInt("igloo"), rs.getInt("iistubil"), rs.getInt("lava"), rs.getInt("mangrove"), rs.getInt("pen"), rs.getInt("stable"), rs.getInt("stall"), rs.getInt("village")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case flight: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("f_id"), rs.getString("uuid"), rs.getInt("tardis_id"), rs.getString("location"), rs.getString("stand"), rs.getString("display")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case forcefield: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getString("uuid"), rs.getString("location")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case gardens: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("garden_id"), rs.getInt("tardis_id"), rs.getString("world"), rs.getInt("minx"), rs.getInt("maxx"), rs.getInt("y"), rs.getInt("minz"), rs.getInt("maxz")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case gravity_well: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("g_id"), rs.getInt("tardis_id"), rs.getString("location"), rs.getString("direction"), rs.getInt("distance"), Float.valueOf(rs.getFloat("velocity"))) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case happy: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("happy_id"), rs.getInt("tardis_id"), rs.getString("slots")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case homes: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("home_id"), rs.getInt("tardis_id"), rs.getString("world"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("direction"), rs.getInt("submarine"), rs.getString("preset")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case interactions: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("i_id"), rs.getInt("tardis_id"), rs.getString("uuid"), rs.getString("control"), rs.getInt("state")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case inventories: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("id"), rs.getString("uuid"), rs.getString("player"), rs.getInt("arch"), rs.getString("inventory"), rs.getString("armour"), rs.getString("attributes"), rs.getString("armour_attributes")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case junk: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("id"), rs.getString("uuid"), rs.getInt("tardis_id"), rs.getString("save_sign"), rs.getString("handbrake"), rs.getString("wall"), rs.getString("floor"), rs.getString("preset")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case lamps: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("l_id"), rs.getInt("tardis_id"), rs.getString("location"), rs.getString("material_on"), rs.getString("material_off"), Float.valueOf(rs.getFloat("percentage"))) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case light_prefs: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("lp_id"), rs.getInt("tardis_id"), rs.getString("light"), rs.getString("material"), rs.getString("pattern"), rs.getString("delays"), rs.getString("levels")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case movers: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getString("uuid")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case next: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("next_id"), rs.getInt("tardis_id"), rs.getString("world"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("direction"), rs.getInt("submarine")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case paper_bag: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("paper_bag_id"), rs.getString("uuid"), rs.getString("flavour_1"), rs.getInt("amount_1"), rs.getString("flavour_2"), rs.getInt("amount_2"), rs.getString("flavour_3"), rs.getInt("amount_3"), rs.getString("flavour_4"), rs.getInt("amount_4")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case particle_prefs: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("pp_id"), rs.getString("uuid"), rs.getString("effect"), rs.getString("shape"), rs.getInt("density"), rs.getInt("speed"), rs.getString("colour"), rs.getString("block"), rs.getInt("particles_on")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case player_prefs: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("pp_id"), rs.getString("uuid"), rs.getString("player"), rs.getString("key"), rs.getInt("sfx_on"), rs.getInt("quotes_on"), rs.getInt("artron_level"), rs.getString("wall"), rs.getString("floor"), rs.getString("siege_wall"), rs.getString("siege_floor"), rs.getInt("announce_repeaters_on"), rs.getInt("auto_on"), rs.getString("auto_type"), rs.getString("auto_default"), rs.getInt("beacon_on"), rs.getInt("hads_on"), rs.getString("hads_type"), rs.getInt("build_on"), rs.getInt("close_gui_on"), rs.getInt("eps_on"), rs.getString("eps_message").replace("'", "\\'"), rs.getString("language"), rs.getInt("submarine_on"), rs.getInt("dnd_on"), rs.getInt("dynamic_lamps_on"), rs.getInt("minecart_on"), rs.getInt("renderer_on"), rs.getInt("sign_on"), rs.getInt("telepathy_on"), rs.getInt("travelbar_on"), rs.getInt("info_on"), rs.getInt("farm_on"), rs.getString("lights"), rs.getInt("auto_siege_on"), rs.getInt("flying_mode"), rs.getInt("throttle"), rs.getInt("auto_powerup_on"), rs.getInt("auto_rescue_on"), rs.getString("hum"), rs.getInt("regenerations"), rs.getInt("regen_block_on"), rs.getInt("dialogs_on"), rs.getInt("open_display_door_on")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case plots: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("plot_id"), rs.getString("uuid"), rs.getString("world"), rs.getInt("chunk_x"), rs.getInt("chunk_z"), rs.getInt("size"), rs.getString("name")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case portals: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("portal_id"), rs.getString("portal"), rs.getString("teleport"), rs.getString("direction"), rs.getInt("tardis_id"), rs.getInt("abandoned")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case previewers: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getString("uuid"), rs.getString("world"), Float.valueOf(rs.getFloat("x")), Float.valueOf(rs.getFloat("y")), Float.valueOf(rs.getFloat("z")), Float.valueOf(rs.getFloat("yaw")), Float.valueOf(rs.getFloat("pitch")), rs.getString("gamemode"), rs.getInt("tardis_id")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case programs: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("program_id"), rs.getString("uuid"), rs.getString("name"), rs.getString("inventory"), rs.getString("parsed"), rs.getInt("checked")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case reminders: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("reminder_id"), rs.getString("uuid"), rs.getString("reminder"), rs.getLong("time")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case room_progress: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("progress_id"), rs.getString("direction"), rs.getString("room"), rs.getInt("tardis_id"), rs.getInt("progress_row"), rs.getInt("progress_column"), rs.getInt("progress_level"), rs.getString("middle_type"), rs.getString("floor_type"), rs.getString("post_blocks")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case seeds: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("seed_id"), rs.getString("schematic"), rs.getString("wall"), rs.getString("floor"), rs.getString("location")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case sensors: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("sensor_id"), rs.getInt("tardis_id"), rs.getString("charging"), rs.getString("flight"), rs.getString("handbrake"), rs.getString("malfunction"), rs.getString("power")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case siege: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("siege_id"), rs.getString("uuid"), rs.getInt("tardis_id")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case skins: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("skin_id"), rs.getString("uuid"), rs.getString("skin")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case sonic: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("sonic_id"), rs.getString("uuid"), rs.getInt("activated"), rs.getInt("model"), rs.getInt("bio"), rs.getInt("diamond"), rs.getInt("emerald"), rs.getInt("redstone"), rs.getInt("painter"), rs.getInt("ignite"), rs.getInt("arrow"), rs.getInt("knockback"), rs.getInt("brush"), rs.getInt("conversion"), rs.getString("sonic_uuid"), rs.getString("last_scanned"), rs.getInt("scan_type")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case storage: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("storage_id"), rs.getInt("tardis_id"), rs.getString("uuid"), rs.getString("owner"), rs.getString("saves_one"), rs.getString("saves_two"), rs.getString("areas"), rs.getString("presets_one"), rs.getString("presets_two"), rs.getString("biomes_one"), rs.getString("biomes_two"), rs.getString("players"), rs.getString("circuits"), rs.getString("console"), rs.getString("versions")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case system_upgrades: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("sys_id"), rs.getInt("tardis_id"), rs.getString("uuid"), rs.getInt("architecture"), rs.getInt("chameleon"), rs.getInt("rooms"), rs.getInt("desktop"), rs.getInt("feature"), rs.getInt("saves"), rs.getInt("monitor"), rs.getInt("force_field"), rs.getInt("tools"), rs.getInt("locator"), rs.getInt("telepathic"), rs.getInt("stattenheim_remote"), rs.getInt("navigation"), rs.getInt("distance_1"), rs.getInt("distance_2"), rs.getInt("distance_3"), rs.getInt("inter_dimension"), rs.getInt("throttle"), rs.getInt("faster"), rs.getInt("rapid"), rs.getInt("warp"), rs.getInt("flight")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case t_count: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("t_id"), rs.getString("uuid"), rs.getString("player"), rs.getInt("count"), rs.getInt("grace"), rs.getInt("repair")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case tag: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("tag_id"), rs.getString("player"), rs.getLong("time")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case tardis: {
                                        String replaced = rs.getString("replaced");
                                        if (rs.wasNull()) {
                                            replaced = "";
                                        }
                                        String companions = rs.getString("companions");
                                        if (rs.wasNull()) {
                                            companions = "";
                                        }
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("tardis_id"), rs.getString("uuid"), rs.getString("owner"), rs.getString("last_known_name"), rs.getString("chunk"), rs.getInt("tips"), rs.getString("size"), rs.getInt("abandoned"), rs.getInt("artron_level"), replaced, companions, rs.getInt("handbrake_on"), rs.getInt("iso_on"), rs.getInt("hidden"), rs.getInt("recharging"), rs.getInt("tardis_init"), rs.getInt("adapti_on"), rs.getString("chameleon_preset"), rs.getString("chameleon_demat"), rs.getString("creeper"), rs.getString("beacon"), rs.getString("eps"), rs.getString("rail"), rs.getString("renderer"), rs.getString("zero"), rs.getString("rotor"), rs.getInt("powered_on"), rs.getInt("lights_on"), rs.getInt("siege_on"), rs.getLong("lastuse"), rs.getInt("monsters"), rs.getInt("furnaces"), rs.getInt("bedrock")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case transmats: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("transmat_id"), rs.getInt("tardis_id"), rs.getString("name"), rs.getString("world"), Float.valueOf(rs.getFloat("x")), Float.valueOf(rs.getFloat("y")), Float.valueOf(rs.getFloat("z")), Float.valueOf(rs.getFloat("yaw"))) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case travel_stats: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("travel_stats_id"), rs.getString("travel_type"), rs.getInt("tardis_id"), rs.getString("uuid")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case traveled_to: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getString("uuid"), rs.getString("environment")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case travellers: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("traveller_id"), rs.getInt("tardis_id"), rs.getString("uuid"), rs.getString("player")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case vaults: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("v_id"), rs.getInt("tardis_id"), rs.getString("location"), rs.getString("chest_type"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case thevoid: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("tardis_id")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case vortex: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("tardis_id"), rs.getInt("task")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case items: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("item_id"), rs.getString("item"), rs.getString("location"), Float.valueOf(rs.getFloat("cost"))) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case beacons: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("beacon_id"), rs.getString("uuid"), rs.getString("location"), rs.getString("block_data")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case manipulator: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getString("uuid"), rs.getInt("tachyon_level")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case messages: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("message_id"), rs.getString("uuid_to"), rs.getString("uuid_from"), rs.getString("message"), rs.getString("date"), rs.getInt("read")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case saves: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("save_id"), rs.getString("uuid"), rs.getString("save_name"), rs.getString("world"), Float.valueOf(rs.getFloat("x")), Float.valueOf(rs.getFloat("y")), Float.valueOf(rs.getFloat("z")), Float.valueOf(rs.getFloat("yaw")), Float.valueOf(rs.getFloat("pitch"))) + end;
                                        bw.write(str);
                                        break;
                                    }
                                    case followers: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getString("uuid"), rs.getString("owner"), rs.getString("species"), rs.getInt("following"), rs.getInt("option"), rs.getString("colour"), rs.getInt("ammo")) + end;
                                        bw.write(str);
                                        break;
                                    }
                                }
                            }
                            catch (MissingFormatArgumentException e) {
                                console.println("VALUES " + String.valueOf((Object)table));
                            }
                            bw.newLine();
                            if (!section) continue;
                            try {
                                bw.write(String.format(SQL.INSERTS.get(i), prefix));
                            }
                            catch (MissingFormatArgumentException e) {
                                console.println("INSERTS " + String.valueOf((Object)table));
                            }
                            bw.newLine();
                        }
                    }
                }
                ++i;
            }
            bw.write("-- --------------------------------------------------------");
            bw.close();
        }
        catch (IOException ex) {
            console.println("***** Input/Output ERROR: " + ex.getMessage());
            return;
        }
        catch (SQLException ex) {
            console.println("***** SQL ERROR: " + ex.getMessage());
            return;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    console.println("***** SQL ERROR: " + ex.getMessage());
                }
            }
        }
        console.println("***** Your SQLite database has been converted!");
    }
}

