/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.tool;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.MissingFormatArgumentException;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.tool.SQL;
import me.eccentric_nz.TARDIS.database.tool.Table;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;

public class Converter
implements Runnable {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final Connection sqliteConnection;
    private final String prefix;
    private final CommandSender sender;

    public Converter(TARDIS plugin, CommandSender sender) throws Exception {
        this.plugin = plugin;
        this.sender = sender;
        this.prefix = this.plugin.getPrefix();
        this.sqliteConnection = this.getSQLiteConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.plugin.getConfig().getString("storage.database", "sqlite").equals("sqlite")) {
            this.plugin.getMessenger().message(this.sender, TardisModule.TARDIS, "You need to set the database provider to 'mysql' in the config!");
            return;
        }
        this.plugin.getMessenger().message(this.sender, TardisModule.TARDIS, "Starting conversion process, please wait. This may cause the server to become unresponsive!");
        try {
            Statement readStatement = this.sqliteConnection.createStatement();
            Statement writeStatement = this.connection.createStatement();
            this.connection.setAutoCommit(false);
            int i = 0;
            for (Table table : Table.values()) {
                this.plugin.getMessenger().message(this.sender, TardisModule.TARDIS, "Reading and writing " + table.toString() + " table");
                String count = "SELECT COUNT(*) AS count FROM " + String.valueOf((Object)table);
                ResultSet rsc = readStatement.executeQuery(count);
                if (rsc.isBeforeFirst()) {
                    rsc.next();
                    int c = rsc.getInt("count");
                    this.plugin.getMessenger().message(this.sender, TardisModule.TARDIS, "Found " + c + " " + String.valueOf((Object)table) + " records");
                    String query = "SELECT * FROM " + String.valueOf((Object)table);
                    ResultSet rs = readStatement.executeQuery(query);
                    if (rs.isBeforeFirst()) {
                        int b = 1;
                        StringBuilder sb = new StringBuilder();
                        try {
                            sb.append(String.format(SQL.INSERTS.get(i), this.prefix));
                        }
                        catch (MissingFormatArgumentException e) {
                            this.plugin.getMessenger().message(this.sender, TardisModule.TARDIS, "INSERT " + String.valueOf((Object)table));
                        }
                        while (rs.next()) {
                            boolean section = b % 100 == 0;
                            String end = b == c || section ? ";" : ", ";
                            ++b;
                            try {
                                switch (table) {
                                    case achievements: {
                                        String player = rs.getString("player");
                                        if (rs.wasNull()) {
                                            player = "";
                                        }
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("a_id"), rs.getString("uuid"), player, rs.getString("name"), rs.getString("amount"), rs.getInt("completed")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case arched: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getString("uuid"), rs.getString("arch_name"), rs.getLong("arch_time")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case archive: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("archive_id"), rs.getString("uuid"), rs.getString("name"), rs.getString("console_size"), rs.getInt("beacon"), rs.getInt("lanterns"), rs.getInt("use"), rs.getInt("y"), rs.getString("data"), rs.getString("description")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case areas: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("area_id"), rs.getString("area_name"), rs.getString("world"), rs.getInt("minx"), rs.getInt("minz"), rs.getInt("maxx"), rs.getInt("maxz"), rs.getInt("y"), rs.getInt("parking_distance"), rs.getString("invisibility"), rs.getString("direction"), rs.getInt("grid")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case area_locations: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("area_location_id"), rs.getInt("area_id"), rs.getString("world"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case ars: {
                                        String ars_player = rs.getString("player");
                                        if (rs.wasNull()) {
                                            ars_player = "";
                                        }
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("ars_id"), rs.getInt("tardis_id"), rs.getString("uuid"), ars_player, rs.getInt("ars_x_east"), rs.getInt("ars_z_south"), rs.getInt("ars_y_layer"), rs.getString("json")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case artron_powered: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("a_id"), rs.getInt("tardis_id"), rs.getString("location")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case back: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("back_id"), rs.getInt("tardis_id"), rs.getString("world"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("direction"), rs.getInt("submarine")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case bind: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("bind_id"), rs.getInt("tardis_id"), rs.getInt("type"), rs.getString("location"), rs.getString("name")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case blocks: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("b_id"), rs.getInt("tardis_id"), rs.getString("location"), rs.getString("data"), rs.getInt("police_box")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case blueprint: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("bp_id"), rs.getString("uuid"), rs.getString("permission")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case camera: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("c_id"), rs.getString("uuid"), rs.getString("location")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case chameleon: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("chameleon_id"), rs.getInt("tardis_id"), rs.getString("blueprintData"), rs.getString("stainData"), rs.getString("glassData"), rs.getString("line1"), rs.getString("line2"), rs.getString("line3"), rs.getString("line4"), rs.getInt("active")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case colour: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("colour_id"), rs.getInt("tardis_id"), rs.getInt("red"), rs.getInt("green"), rs.getInt("blue")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case chunks: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("chunk_id"), rs.getInt("tardis_id"), rs.getString("world"), rs.getInt("x"), rs.getInt("z")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case condenser: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("c_id"), rs.getInt("tardis_id"), rs.getString("block_data"), rs.getInt("block_count")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case controls: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("c_id"), rs.getInt("tardis_id"), rs.getInt("type"), rs.getString("location"), rs.getInt("secondary")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case current: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("current_id"), rs.getInt("tardis_id"), rs.getString("world"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("direction"), rs.getInt("submarine"), rs.getString("biome")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case custom_preset: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("custom_id"), rs.getInt("tardis_id"), rs.getString("preset")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case deaths: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getString("uuid"), rs.getString("world"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("direction"), rs.getInt("submarine")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case destinations: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("dest_id"), rs.getInt("tardis_id"), rs.getString("dest_name"), rs.getString("world"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("direction"), rs.getString("preset"), rs.getString("bind"), rs.getInt("type"), rs.getInt("submarine"), rs.getInt("slot"), rs.getInt("icon")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case doors: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("door_id"), rs.getInt("tardis_id"), rs.getInt("door_type"), rs.getString("door_location"), rs.getString("door_direction"), rs.getInt("locked")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case eyes: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("eye_id"), rs.getInt("tardis_id"), rs.getInt("capacitors"), rs.getInt("damaged"), rs.getInt("task")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case farming: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("farm_id"), rs.getInt("tardis_id"), rs.getString("allay"), rs.getString("apiary"), rs.getString("aquarium"), rs.getString("bamboo"), rs.getString("birdcage"), rs.getString("farm"), rs.getString("geode"), rs.getString("happy"), rs.getString("hutch"), rs.getString("igloo"), rs.getString("iistubil"), rs.getString("lava"), rs.getString("mangrove"), rs.getString("pen"), rs.getString("stable"), rs.getString("stall"), rs.getString("village")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case farming_prefs: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("farm_id"), rs.getString("uuid"), rs.getInt("allay"), rs.getInt("apiary"), rs.getInt("aquarium"), rs.getInt("bamboo"), rs.getInt("birdcage"), rs.getInt("farm"), rs.getInt("geode"), rs.getInt("happy"), rs.getInt("hutch"), rs.getInt("igloo"), rs.getInt("iistubil"), rs.getInt("lava"), rs.getInt("mangrove"), rs.getInt("pen"), rs.getInt("stable"), rs.getInt("stall"), rs.getInt("village")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case flight: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("f_id"), rs.getString("uuid"), rs.getInt("tardis_id"), rs.getString("location"), rs.getString("stand"), rs.getString("display")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case forcefield: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getString("uuid"), rs.getString("location")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case gardens: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("garden_id"), rs.getInt("tardis_id"), rs.getString("world"), rs.getInt("minx"), rs.getInt("maxx"), rs.getInt("y"), rs.getInt("minz"), rs.getInt("maxz")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case gravity_well: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("g_id"), rs.getInt("tardis_id"), rs.getString("location"), rs.getString("direction"), rs.getInt("distance"), Float.valueOf(rs.getFloat("velocity"))) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case happy: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("happy_id"), rs.getInt("tardis_id"), rs.getString("slots")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case homes: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("home_id"), rs.getInt("tardis_id"), rs.getString("world"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("direction"), rs.getInt("submarine"), rs.getString("preset")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case interactions: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("i_id"), rs.getInt("tardis_id"), rs.getString("uuid"), rs.getString("control"), rs.getInt("state")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case inventories: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("id"), rs.getString("uuid"), rs.getString("player"), rs.getInt("arch"), rs.getString("inventory"), rs.getString("armour"), rs.getString("attributes"), rs.getString("armour_attributes")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case junk: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("id"), rs.getString("uuid"), rs.getInt("tardis_id"), rs.getString("save_sign"), rs.getString("handbrake"), rs.getString("wall"), rs.getString("floor"), rs.getString("preset")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case lamps: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("l_id"), rs.getInt("tardis_id"), rs.getString("location"), rs.getString("material_on"), rs.getString("material_off"), Float.valueOf(rs.getFloat("percentage"))) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case light_prefs: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("lp_id"), rs.getInt("tardis_id"), rs.getString("light"), rs.getString("material"), rs.getString("pattern"), rs.getString("delays"), rs.getString("levels")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case movers: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getString("uuid")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case next: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("next_id"), rs.getInt("tardis_id"), rs.getString("world"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z"), rs.getString("direction"), rs.getInt("submarine")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case paper_bag: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("paper_bag_id"), rs.getString("uuid"), rs.getString("flavour_1"), rs.getInt("amount_1"), rs.getString("flavour_2"), rs.getInt("amount_2"), rs.getString("flavour_3"), rs.getInt("amount_3"), rs.getString("flavour_4"), rs.getInt("amount_4")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case particle_prefs: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("pp_id"), rs.getString("uuid"), rs.getString("effect"), rs.getString("shape"), rs.getInt("density"), rs.getInt("speed"), rs.getString("colour"), rs.getString("block"), rs.getInt("particles_on")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case player_prefs: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("pp_id"), rs.getString("uuid"), rs.getString("player"), rs.getString("key"), rs.getInt("sfx_on"), rs.getInt("quotes_on"), rs.getInt("artron_level"), rs.getString("wall"), rs.getString("floor"), rs.getString("siege_wall"), rs.getString("siege_floor"), rs.getInt("announce_repeaters_on"), rs.getInt("auto_on"), rs.getString("auto_type"), rs.getString("auto_default"), rs.getInt("beacon_on"), rs.getInt("hads_on"), rs.getString("hads_type"), rs.getInt("build_on"), rs.getInt("close_gui_on"), rs.getInt("eps_on"), rs.getString("eps_message").replace("'", "\\'"), rs.getString("language"), rs.getInt("submarine_on"), rs.getInt("dnd_on"), rs.getInt("dynamic_lamps_on"), rs.getInt("minecart_on"), rs.getInt("renderer_on"), rs.getInt("sign_on"), rs.getInt("telepathy_on"), rs.getInt("travelbar_on"), rs.getInt("info_on"), rs.getInt("farm_on"), rs.getString("lights"), rs.getInt("auto_siege_on"), rs.getInt("flying_mode"), rs.getInt("throttle"), rs.getInt("auto_powerup_on"), rs.getInt("auto_rescue_on"), rs.getString("hum"), rs.getInt("regenerations"), rs.getInt("regen_block_on"), rs.getInt("dialogs_on"), rs.getInt("open_display_door_on")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case plots: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("plot_id"), rs.getString("uuid"), rs.getString("world"), rs.getInt("chunk_x"), rs.getInt("chunk_z"), rs.getInt("size"), rs.getString("name")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case portals: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("portal_id"), rs.getString("portal"), rs.getString("teleport"), rs.getString("direction"), rs.getInt("tardis_id"), rs.getInt("abandoned")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case previewers: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getString("uuid"), rs.getString("world"), Float.valueOf(rs.getFloat("x")), Float.valueOf(rs.getFloat("y")), Float.valueOf(rs.getFloat("z")), Float.valueOf(rs.getFloat("yaw")), Float.valueOf(rs.getFloat("pitch")), rs.getString("gamemode"), rs.getInt("tardis_id")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case programs: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("program_id"), rs.getString("uuid"), rs.getString("name"), rs.getString("inventory"), rs.getString("parsed"), rs.getInt("checked")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case reminders: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("reminder_id"), rs.getString("uuid"), rs.getString("reminder"), rs.getLong("time")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case room_progress: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("progress_id"), rs.getString("direction"), rs.getString("room"), rs.getInt("tardis_id"), rs.getInt("progress_row"), rs.getInt("progress_column"), rs.getInt("progress_level"), rs.getString("middle_type"), rs.getString("floor_type")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case seeds: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("seed_id"), rs.getString("schematic"), rs.getString("wall"), rs.getString("floor"), rs.getString("location")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case sensors: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("sensor_id"), rs.getInt("tardis_id"), rs.getString("charging"), rs.getString("flight"), rs.getString("handbrake"), rs.getString("malfunction"), rs.getString("power")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case siege: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("siege_id"), rs.getString("uuid"), rs.getInt("tardis_id")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case skins: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("skin_id"), rs.getString("uuid"), rs.getString("skin")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case sonic: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("sonic_id"), rs.getString("uuid"), rs.getInt("activated"), rs.getInt("model"), rs.getInt("bio"), rs.getInt("diamond"), rs.getInt("emerald"), rs.getInt("redstone"), rs.getInt("painter"), rs.getInt("ignite"), rs.getInt("arrow"), rs.getInt("knockback"), rs.getInt("brush"), rs.getInt("conversion"), rs.getString("sonic_uuid"), rs.getString("last_scanned"), rs.getInt("scan_type")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case storage: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("storage_id"), rs.getInt("tardis_id"), rs.getString("uuid"), rs.getString("owner"), rs.getString("saves_one"), rs.getString("saves_two"), rs.getString("areas"), rs.getString("presets_one"), rs.getString("presets_two"), rs.getString("biomes_one"), rs.getString("biomes_two"), rs.getString("players"), rs.getString("circuits"), rs.getString("console"), rs.getString("versions")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case system_upgrades: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("sys_id"), rs.getInt("tardis_id"), rs.getString("uuid"), rs.getInt("architecture"), rs.getInt("chameleon"), rs.getInt("rooms"), rs.getInt("desktop"), rs.getInt("feature"), rs.getInt("saves"), rs.getInt("monitor"), rs.getInt("force_field"), rs.getInt("tools"), rs.getInt("locator"), rs.getInt("telepathic"), rs.getInt("stattenheim_remote"), rs.getInt("navigation"), rs.getInt("distance_1"), rs.getInt("distance_2"), rs.getInt("distance_3"), rs.getInt("inter_dimension"), rs.getInt("throttle"), rs.getInt("faster"), rs.getInt("rapid"), rs.getInt("warp"), rs.getInt("flight")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case t_count: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("t_id"), rs.getString("uuid"), rs.getString("player"), rs.getInt("count"), rs.getInt("grace"), rs.getInt("repair")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case tag: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("tag_id"), rs.getString("player"), rs.getLong("time")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case tardis: {
                                        String replaced = rs.getString("replaced");
                                        if (rs.wasNull()) {
                                            replaced = "";
                                        }
                                        String companions = rs.getString("companions");
                                        if (rs.wasNull()) {
                                            companions = "";
                                        }
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("tardis_id"), rs.getString("uuid"), rs.getString("owner"), rs.getString("last_known_name"), rs.getString("chunk"), rs.getInt("tips"), rs.getString("size"), rs.getInt("abandoned"), rs.getInt("artron_level"), replaced, companions, rs.getInt("handbrake_on"), rs.getInt("iso_on"), rs.getInt("hidden"), rs.getInt("recharging"), rs.getInt("tardis_init"), rs.getInt("adapti_on"), rs.getString("chameleon_preset"), rs.getString("chameleon_demat"), rs.getString("creeper"), rs.getString("beacon"), rs.getString("eps"), rs.getString("rail"), rs.getString("renderer"), rs.getString("zero"), rs.getString("rotor"), rs.getInt("powered_on"), rs.getInt("lights_on"), rs.getInt("siege_on"), rs.getLong("lastuse"), rs.getInt("monsters"), rs.getInt("furnaces"), rs.getInt("bedrock")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case transmats: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("transmat_id"), rs.getInt("tardis_id"), rs.getString("name"), rs.getString("world"), Float.valueOf(rs.getFloat("x")), Float.valueOf(rs.getFloat("y")), Float.valueOf(rs.getFloat("z")), Float.valueOf(rs.getFloat("yaw"))) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case travel_stats: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("travel_stats_id"), rs.getString("travel_type"), rs.getInt("tardis_id"), rs.getString("uuid")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case traveled_to: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getString("uuid"), rs.getString("environment")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case travellers: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("traveller_id"), rs.getInt("tardis_id"), rs.getString("uuid"), rs.getString("player")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case vaults: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("v_id"), rs.getInt("tardis_id"), rs.getString("location"), rs.getString("chest_type"), rs.getInt("x"), rs.getInt("y"), rs.getInt("z")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case thevoid: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("tardis_id")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case vortex: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("tardis_id"), rs.getInt("task")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case items: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("item_id"), rs.getString("item"), rs.getString("location"), Float.valueOf(rs.getFloat("cost"))) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case beacons: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("beacon_id"), rs.getString("uuid"), rs.getString("location"), rs.getString("block_data")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case manipulator: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getString("uuid"), rs.getInt("tachyon_level")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case messages: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("message_id"), rs.getString("uuid_to"), rs.getString("uuid_from"), rs.getString("message"), rs.getString("date"), rs.getInt("read")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case saves: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getInt("save_id"), rs.getString("uuid"), rs.getString("save_name"), rs.getString("world"), Float.valueOf(rs.getFloat("x")), Float.valueOf(rs.getFloat("y")), Float.valueOf(rs.getFloat("z")), Float.valueOf(rs.getFloat("yaw")), Float.valueOf(rs.getFloat("pitch"))) + end;
                                        sb.append(str);
                                        break;
                                    }
                                    case followers: {
                                        String str = String.format(SQL.VALUES.get(i), rs.getString("uuid"), rs.getString("owner"), rs.getString("species"), rs.getInt("following"), rs.getInt("option"), rs.getString("colour"), rs.getInt("ammo")) + end;
                                        sb.append(str);
                                        break;
                                    }
                                }
                            }
                            catch (MissingFormatArgumentException e) {
                                this.plugin.getMessenger().message(this.sender, TardisModule.TARDIS, "VALUES " + String.valueOf((Object)table));
                            }
                            if (!section) continue;
                            writeStatement.addBatch(sb.toString());
                            sb.setLength(0);
                            try {
                                sb.append(String.format(SQL.INSERTS.get(i), this.prefix));
                            }
                            catch (MissingFormatArgumentException e) {
                                this.plugin.getMessenger().message(this.sender, TardisModule.TARDIS, "INSERTS " + String.valueOf((Object)table));
                            }
                        }
                        String insert = sb.toString();
                        writeStatement.addBatch(insert);
                    }
                }
                ++i;
            }
            writeStatement.executeBatch();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException ex) {
            this.plugin.getMessenger().message(this.sender, TardisModule.TARDIS, "***** SQL ERROR: " + ex.getMessage());
            return;
        }
        finally {
            if (this.sqliteConnection != null) {
                try {
                    this.sqliteConnection.close();
                }
                catch (SQLException ex) {
                    this.plugin.getMessenger().message(this.sender, TardisModule.TARDIS, "***** SQL ERROR: " + ex.getMessage());
                }
            }
        }
        this.plugin.getMessenger().message(this.sender, TardisModule.TARDIS, "***** Your SQLite database has been converted to MySQL!");
    }

    private Connection getSQLiteConnection() throws Exception {
        try {
            Class.forName("org.sqlite.JDBC");
            String path = String.valueOf(this.plugin.getDataFolder()) + File.separator + "TARDIS.db";
            return DriverManager.getConnection("jdbc:sqlite:" + path);
        }
        catch (ClassNotFoundException ignore) {
            return null;
        }
    }
}

