/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetRandomInteractions {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final int id;
    private final int[] diodes = new int[5];
    private final String prefix;
    private final HashMap<String, Integer> map = new HashMap();

    public ResultSetRandomInteractions(TARDIS plugin, int id) {
        this.plugin = plugin;
        this.id = id;
        this.prefix = this.plugin.getPrefix();
        this.map.put("WORLD", 0);
        this.map.put("X", 1);
        this.map.put("Z", 2);
        this.map.put("MULTIPLIER", 3);
        this.map.put("HELMIC_REGULATOR", 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block17: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT control, state FROM " + this.prefix + "interactions WHERE tardis_id = ? AND control IN ('HELMIC_REGULATOR', 'MULTIPLIER', 'WORLD', 'X', 'Z') ORDER BY control";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setInt(1, this.id);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        this.diodes[this.map.get((Object)rs.getString((String)"control")).intValue()] = rs.getInt("state");
                    }
                    break block17;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for random interactions table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing random interactions table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public int[] getStates() {
        return this.diodes;
    }
}

