/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.converters;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.command.CommandSender;

public class TARDISControlsConverter {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;

    public TARDISControlsConverter(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Statement statement = null;
        Statement ps = null;
        int i = 0;
        try {
            this.service.testConnection(this.connection);
            this.connection.setAutoCommit(false);
            statement = this.connection.createStatement();
            String tardisQuery = "SELECT tardis_id, chameleon, condenser, save_sign, scanner FROM " + this.prefix + "tardis";
            String controlsInsert = "INSERT INTO " + this.prefix + "controls (tardis_id, type, location) VALUES (?, ?, ?)";
            ps = this.connection.prepareStatement(controlsInsert);
            this.connection.setAutoCommit(false);
            ResultSet rst = statement.executeQuery(tardisQuery);
            if (rst.isBeforeFirst()) {
                while (rst.next()) {
                    String location;
                    if (!rst.getString("chameleon").isEmpty()) {
                        ps.setInt(1, rst.getInt("tardis_id"));
                        ps.setInt(2, 31);
                        location = this.getLocationFromString(rst.getString("chameleon"));
                        ps.setString(3, location);
                        ps.addBatch();
                        ++i;
                    }
                    if (!rst.getString("save_sign").isEmpty()) {
                        ps.setInt(1, rst.getInt("tardis_id"));
                        ps.setInt(2, 32);
                        location = this.getLocationFromString(rst.getString("save_sign"));
                        ps.setString(3, location);
                        ps.addBatch();
                        ++i;
                    }
                    if (!rst.getString("scanner").isEmpty()) {
                        ps.setInt(1, rst.getInt("tardis_id"));
                        ps.setInt(2, 33);
                        location = this.getLocationFromString(rst.getString("scanner"));
                        ps.setString(3, location);
                        ps.addBatch();
                        ++i;
                    }
                    if (rst.getString("condenser").isEmpty()) continue;
                    ps.setInt(1, rst.getInt("tardis_id"));
                    ps.setInt(2, 34);
                    location = this.getLocationFromString(rst.getString("condenser"));
                    ps.setString(3, location);
                    ps.addBatch();
                    ++i;
                }
                if (i > 0) {
                    ps.executeBatch();
                    this.connection.commit();
                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Converted " + i + " old TARDIS control records");
                }
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            this.plugin.debug("Conversion error for tardis/controls tables (converting old TARDIS controls)! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (statement != null) {
                    statement.close();
                }
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing tardis/controls tables (converting old TARDIS controls)! " + e.getMessage());
            }
        }
    }

    private String getLocationFromString(String s) {
        String[] split = s.split(":");
        return TARDISStaticLocationGetters.makeLocationStr(split[0], split[1], split[2], split[3]);
    }
}

