/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.bind;

import com.google.common.collect.ImmutableList;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import org.bukkit.block.Biome;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class TARDISBindTabComplete
extends TARDISCompleter
implements TabCompleter {
    private final List<String> ROOT_SUBS = ImmutableList.of((Object)"add", (Object)"remove");
    private final ImmutableList<String> FIRST_SUBS = ImmutableList.of((Object)"save", (Object)"player", (Object)"area", (Object)"biome", (Object)"hide", (Object)"rebuild", (Object)"home", (Object)"cave", (Object)"make_her_blue", (Object)"occupy", (Object)"chameleon", (Object)"transmat", (Object[])new String[0]);
    private final List<String> CHAM_SUBS = new ArrayList<String>();
    private final List<String> BIOME_SUBS = new ArrayList<String>();

    public TARDISBindTabComplete() {
        this.CHAM_SUBS.add("OFF");
        this.CHAM_SUBS.add("ADAPT");
        for (ChameleonPreset p : ChameleonPreset.values()) {
            this.CHAM_SUBS.add(p.toString());
        }
        for (Biome biome : RegistryAccess.registryAccess().getRegistry(RegistryKey.BIOME)) {
            this.BIOME_SUBS.add(biome.getKey().getKey().toUpperCase(Locale.ROOT));
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        String lastArg = args[args.length - 1];
        if (args.length == 1) {
            return this.partial(args[0], this.ROOT_SUBS);
        }
        if (args.length == 2) {
            return this.partial(args[1], (Collection<String>)this.FIRST_SUBS);
        }
        if (args.length == 3) {
            String sub;
            switch (sub = args[1]) {
                case "player": {
                    return null;
                }
                case "chameleon": {
                    return this.partial(lastArg, this.CHAM_SUBS);
                }
                case "biome": {
                    return this.partial(lastArg, this.BIOME_SUBS);
                }
            }
        }
        return ImmutableList.of();
    }
}

