/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.nms;

import java.util.UUID;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.nms.FollowPathFinder;
import me.eccentric_nz.tardisweepingangels.nms.RandomPathGoal;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.zombie.Husk;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.entity.CraftPlayer;

public class TWAFollower
extends Husk
implements OwnableEntity {
    protected UUID uuid;
    protected boolean following = false;

    public TWAFollower(EntityType<? extends Husk> entityType, Level world) {
        super(entityType, world);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new FollowPathFinder(this, 1.0, 10.0f, 2.0f, false));
        this.goalSelector.addGoal(8, (Goal)new RandomPathGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void addAdditionalSaveData(ValueOutput tag) {
        super.addAdditionalSaveData(tag);
        if (this.getOwnerUUID() != null) {
            EntityReference entityreference = EntityReference.of((UUID)this.getOwnerUUID());
            entityreference.store(tag, "Owner");
        }
    }

    public void readAdditionalSaveData(ValueInput tag) {
        super.readAdditionalSaveData(tag);
        EntityReference entityreference = EntityReference.readWithOldOwnerConversion((ValueInput)tag, (String)"Owner", (Level)this.level());
        if (entityreference != null) {
            this.setOwnerUUID(entityreference.getUUID());
        } else {
            tag.getString("Owner").ifPresent(s -> {
                this.uuid = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.level().getServer(), (String)s);
                if (this.uuid != null) {
                    this.setOwnerUUID(this.uuid);
                }
            });
        }
    }

    public UUID getOwnerUUID() {
        return (UUID)this.getBukkitEntity().getPersistentDataContainer().get(TARDISWeepingAngels.OWNER_UUID, TARDISWeepingAngels.PersistentDataTypeUUID);
    }

    public void setOwnerUUID(UUID uuid) {
        this.uuid = uuid;
        this.getBukkitEntity().getPersistentDataContainer().set(TARDISWeepingAngels.OWNER_UUID, TARDISWeepingAngels.PersistentDataTypeUUID, (Object)uuid);
    }

    public EntityReference<LivingEntity> getOwnerReference() {
        return null;
    }

    public LivingEntity getOwner() {
        if (this.uuid == null) {
            return null;
        }
        org.bukkit.entity.Player player = Bukkit.getPlayer((UUID)this.uuid);
        return player != null ? ((CraftPlayer)player).getHandle() : null;
    }

    public boolean isFollowing() {
        return this.following;
    }

    public void setFollowing(boolean following) {
        this.following = following;
    }
}

