/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.toclafane;

import java.util.Collection;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngelSpawnEvent;
import me.eccentric_nz.tardisweepingangels.monsters.toclafane.ToclafaneEquipment;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import me.eccentric_nz.tardisweepingangels.utils.WaterChecker;
import me.eccentric_nz.tardisweepingangels.utils.WorldGuardChecker;
import me.eccentric_nz.tardisweepingangels.utils.WorldProcessor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class ToclafaneRunnable
implements Runnable {
    private final TARDIS plugin;
    private final int spawn_rate;

    public ToclafaneRunnable(TARDIS plugin) {
        this.plugin = plugin;
        this.spawn_rate = this.plugin.getMonstersConfig().getInt("spawn_rate.how_many");
    }

    @Override
    public void run() {
        this.plugin.getServer().getWorlds().forEach(w -> {
            String name = WorldProcessor.sanitiseName(w.getName());
            if (this.plugin.getMonstersConfig().getInt("toclafane.worlds." + name) > 0) {
                int n = 0;
                Collection hive = w.getEntitiesByClass(Bee.class);
                for (Bee b : hive) {
                    if (b.getPassengers().isEmpty() || !(b.getPassengers().getFirst() instanceof ArmorStand)) continue;
                    ++n;
                }
                if (n < this.plugin.getMonstersConfig().getInt("toclafane.worlds." + name)) {
                    for (int i = 0; i < this.spawn_rate; ++i) {
                        this.spawnToclafane((World)w);
                    }
                }
            }
        });
    }

    private void spawnToclafane(World world) {
        int z;
        int y;
        Chunk c;
        int x;
        Location l;
        int players = world.getPlayers().size();
        if (players == 0) {
            return;
        }
        Chunk[] chunks = world.getLoadedChunks();
        if (chunks.length > 0 && WaterChecker.isNotWater(l = new Location(world, (double)(x = (c = chunks[TARDISConstants.RANDOM.nextInt(chunks.length)]).getX() * 16 + TARDISConstants.RANDOM.nextInt(16)), (double)((y = world.getHighestBlockYAt(x, z = c.getZ() * 16 + TARDISConstants.RANDOM.nextInt(16))) + 1), (double)z))) {
            if (this.plugin.isWorldGuardOnServer() && !WorldGuardChecker.canSpawn(l)) {
                return;
            }
            Entity e = world.spawnEntity(l, EntityType.ARMOR_STAND);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                ToclafaneEquipment.set(e, false);
                this.plugin.getServer().getPluginManager().callEvent((Event)new TARDISWeepingAngelSpawnEvent(e, EntityType.ARMOR_STAND, Monster.TOCLAFANE, l));
            }, 5L);
        }
    }
}

