/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.headless_monks;

import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.LivingEntity;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Vector;

public class HeadlessFlameRunnable
implements Runnable {
    private final LivingEntity monk;

    public HeadlessFlameRunnable(LivingEntity monk) {
        this.monk = monk;
    }

    @Override
    public void run() {
        if (this.monk.isDead()) {
            Bukkit.getScheduler().cancelTask(((Integer)this.monk.getPersistentDataContainer().get(TARDISWeepingAngels.FLAME_TASK, PersistentDataType.INTEGER)).intValue());
            this.monk.getPersistentDataContainer().set(TARDISWeepingAngels.FLAME_TASK, PersistentDataType.INTEGER, (Object)-1);
            return;
        }
        double angle = Math.abs(this.monk.getLocation().getYaw() % 360.0f - 180.0f) - 180.0f;
        if (angle < 0.0) {
            angle += 360.0;
        }
        double addX = 0.4 * Math.sin(Math.PI * 2 * angle / 360.0);
        double addZ = 0.4 * Math.cos(Math.PI * 2 * angle / 360.0);
        Location start = this.monk.getLocation().clone().add(addX, 1.4, addZ);
        Location end = start.clone().add(0.0, 0.9, 0.0);
        this.spawnFlameAlongLine(start, end);
    }

    public void spawnFlameAlongLine(Location start, Location end) {
        double d = start.distance(end) / 8.0;
        for (int i = 0; i < 8; ++i) {
            Location l = start.clone();
            Vector direction = end.toVector().subtract(start.toVector()).normalize();
            Vector v = direction.multiply((double)i * d);
            l.add(v.getX(), v.getY(), v.getZ());
            start.getWorld().spawnParticle(Particle.FLAME, l, 1, 0.0, 0.0, 0.0, 0.005, null, false);
        }
    }
}

