/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.equip;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.keys.ArmourVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.CybermanVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.DalekVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.DroidVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.Features;
import me.eccentric_nz.TARDIS.custommodels.keys.HathVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.IceWarriorVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.JudoonVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.MireVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.MonkVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.SilentVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.SilurianVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.SlitheenVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.SontaranVariant;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.equip.ArmourEquipper;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Equipper {
    private final Monster monster;
    private final LivingEntity le;
    private final boolean disguise;

    public Equipper(Monster monster, LivingEntity le, boolean disguise) {
        this.monster = monster;
        this.le = le;
        this.disguise = disguise;
    }

    public void setHelmetAndInvisibility() {
        this.le.setRemoveWhenFarAway(false);
        this.le.setPersistent(true);
        EntityEquipment ee = this.setArmour(this.le, this.monster);
        LivingEntity livingEntity = this.le;
        if (livingEntity instanceof Ageable) {
            Ageable ageable = (Ageable)livingEntity;
            if (this.monster == Monster.EMPTY_CHILD) {
                ageable.setBaby();
            } else {
                ageable.setAdult();
            }
        }
        if (!(this.le instanceof Player)) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)TARDIS.plugin, () -> {
                PotionEffect invisibility = new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1, false, false);
                this.le.addPotionEffect(invisibility);
                PotionEffect resistance = new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 360000, 3, false, false);
                this.le.addPotionEffect(resistance);
            });
        }
        ee.setBoots(null);
        if (this.disguise) {
            PotionEffect potionEffect = new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1, true, false);
            this.le.addPotionEffect(potionEffect);
        } else {
            ee.setItemInMainHandDropChance(0.0f);
            ee.setItemInOffHandDropChance(0.0f);
            ee.setHelmetDropChance(0.0f);
            ee.setChestplateDropChance(0.0f);
            ee.setLeggingsDropChance(0.0f);
            this.le.setCanPickupItems(false);
            this.le.setSilent(true);
            this.le.setCollidable(true);
            this.le.setPersistent(true);
            this.le.getPersistentDataContainer().set(TARDISWeepingAngels.PDC_KEYS.get((Object)this.monster), PersistentDataType.INTEGER, (Object)this.monster.ordinal());
        }
    }

    private EntityEquipment setArmour(LivingEntity entity, Monster monster) {
        EntityEquipment ee = entity.getEquipment();
        NamespacedKey armourKey = new ArmourEquipper().dress(entity, monster);
        ItemStack hand = null;
        ItemStack offhand = null;
        block0 : switch (monster) {
            case ANGEL_OF_LIBERTY: {
                hand = ItemStack.of((Material)Material.TORCH);
                ItemMeta tim = hand.getItemMeta();
                tim.setItemModel(Features.ANGEL_OF_LIBERTY_TORCH.getKey());
                hand.setItemMeta(tim);
                if (this.disguise) break;
                entity.getAttribute(Attribute.SCALE).setBaseValue(2.5);
                break;
            }
            case THE_BEAST: {
                if (this.disguise) break;
                entity.getAttribute(Attribute.SCALE).setBaseValue(2.5);
                break;
            }
            case CLOCKWORK_DROID: {
                ArmourVariant variant = this.getVariant(armourKey);
                hand = ItemStack.of((Material)Material.GOLD_NUGGET);
                ItemMeta tim = hand.getItemMeta();
                tim.setItemModel(variant.equals((Object)ArmourVariant.CLOCKWORK_DROID) ? DroidVariant.CLOCKWORK_DROID_KEY.getKey() : DroidVariant.CLOCKWORK_DROID_FEMALE_KEY.getKey());
                hand.setItemMeta(tim);
                break;
            }
            case CYBERMAN: {
                ArmourVariant variant = this.getVariant(armourKey);
                switch (variant) {
                    case CYBERMAN: {
                        hand = ItemStack.of((Material)Material.IRON_NUGGET);
                        ItemMeta tim = hand.getItemMeta();
                        tim.setItemModel(CybermanVariant.CYBER_WEAPON.getKey());
                        hand.setItemMeta(tim);
                        break block0;
                    }
                    case WOOD_CYBERMAN: {
                        hand = ItemStack.of((Material)Material.SPRUCE_BUTTON);
                        ItemMeta tim = hand.getItemMeta();
                        tim.setItemModel(CybermanVariant.WOOD_CYBER_WEAPON.getKey());
                        hand.setItemMeta(tim);
                        break block0;
                    }
                    case CYBERMAN_INVASION: {
                        hand = ItemStack.of((Material)Material.IRON_NUGGET);
                        ItemMeta tim = hand.getItemMeta();
                        tim.setItemModel(CybermanVariant.CYBERMAN_INVASION_ARM.getKey());
                        hand.setItemMeta(tim);
                        offhand = ItemStack.of((Material)Material.IRON_NUGGET);
                        ItemMeta oim = offhand.getItemMeta();
                        oim.setItemModel(CybermanVariant.CYBERMAN_INVASION_ARM.getKey());
                        offhand.setItemMeta(oim);
                        break block0;
                    }
                    case CYBER_LORD: 
                    case CYBERMAN_RISE: 
                    case CYBERMAN_MOONBASE: {
                        hand = ItemStack.of((Material)Material.IRON_NUGGET);
                        ItemMeta tim = hand.getItemMeta();
                        tim.setItemModel(CybermanVariant.CYBERMAN_RISE_ARM.getKey());
                        hand.setItemMeta(tim);
                        offhand = ItemStack.of((Material)Material.IRON_NUGGET);
                        ItemMeta oim = offhand.getItemMeta();
                        oim.setItemModel(CybermanVariant.CYBERMAN_RISE_ARM.getKey());
                        offhand.setItemMeta(oim);
                        break block0;
                    }
                }
                break;
            }
            case HATH: {
                hand = ItemStack.of((Material)monster.getMaterial());
                ItemMeta tim = hand.getItemMeta();
                tim.setItemModel(HathVariant.HATH_WEAPON.getKey());
                hand.setItemMeta(tim);
                break;
            }
            case HEADLESS_MONK: {
                hand = ItemStack.of((Material)Material.GOLDEN_SWORD);
                ItemMeta tim = hand.getItemMeta();
                tim.setItemModel(MonkVariant.HEADLESS_MONK_SWORD.getKey());
                hand.setItemMeta(tim);
                break;
            }
            case ICE_WARRIOR: {
                hand = ItemStack.of((Material)Material.IRON_SWORD);
                ItemMeta tim = hand.getItemMeta();
                tim.setItemModel(IceWarriorVariant.ICE_WARRIOR_DAGGER.getKey());
                hand.setItemMeta(tim);
                break;
            }
            case JUDOON: {
                hand = ItemStack.of((Material)Material.END_ROD);
                ItemMeta tim = hand.getItemMeta();
                tim.setItemModel(JudoonVariant.JUDOON_WEAPON_RESTING.getKey());
                hand.setItemMeta(tim);
                break;
            }
            case MIRE: {
                hand = ItemStack.of((Material)Material.NETHERITE_SCRAP);
                ItemMeta tim = hand.getItemMeta();
                tim.setItemModel(MireVariant.MIRE_RIGHT_ARM.getKey());
                hand.setItemMeta(tim);
                offhand = ItemStack.of((Material)Material.NETHERITE_SCRAP);
                ItemMeta oim = offhand.getItemMeta();
                oim.setItemModel(MireVariant.MIRE_LEFT_ARM.getKey());
                offhand.setItemMeta(oim);
                break;
            }
            case SEA_DEVIL: {
                hand = ItemStack.of((Material)Material.TRIDENT, (int)1);
                ItemMeta tim = hand.getItemMeta();
                tim.setItemModel(DalekVariant.DALEK_BOW.getKey());
                hand.setItemMeta(tim);
                break;
            }
            case SILENT: {
                hand = ItemStack.of((Material)Material.END_STONE_BRICK_SLAB);
                ItemMeta tim = hand.getItemMeta();
                tim.setItemModel(SilentVariant.SILENCE_HAND.getKey());
                hand.setItemMeta(tim);
                offhand = ItemStack.of((Material)Material.END_STONE_BRICK_SLAB);
                ItemMeta oim = offhand.getItemMeta();
                oim.setItemModel(SilentVariant.SILENCE_OFFHAND.getKey());
                offhand.setItemMeta(oim);
                break;
            }
            case SILURIAN: {
                hand = ItemStack.of((Material)Material.BOW, (int)1);
                ItemMeta bim = hand.getItemMeta();
                bim.setItemModel(SilurianVariant.SILURIAN_GUN.getKey());
                hand.setItemMeta(bim);
                break;
            }
            case SLITHEEN: {
                hand = ItemStack.of((Material)Material.TURTLE_EGG);
                ItemMeta tim = hand.getItemMeta();
                tim.setItemModel(SlitheenVariant.SLITHEEN_CLAW_RIGHT.getKey());
                hand.setItemMeta(tim);
                offhand = ItemStack.of((Material)Material.TURTLE_EGG);
                ItemMeta oim = offhand.getItemMeta();
                oim.setItemModel(SlitheenVariant.SLITHEEN_CLAW_LEFT.getKey());
                offhand.setItemMeta(oim);
                break;
            }
            case SONTARAN: {
                hand = ItemStack.of((Material)Material.END_ROD);
                ItemMeta tim = hand.getItemMeta();
                tim.setItemModel(SontaranVariant.SONTARAN_WEAPON.getKey());
                hand.setItemMeta(tim);
                break;
            }
        }
        ee.setItemInMainHand(hand);
        ee.setItemInOffHand(offhand);
        return ee;
    }

    private ArmourVariant getVariant(NamespacedKey key) {
        for (ArmourVariant v : ArmourVariant.values()) {
            if (!v.getKey().equals((Object)key)) continue;
            return v;
        }
        return null;
    }
}

