/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisshop.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class DeleteShopItem {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;

    public DeleteShopItem(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecord(String table, HashMap<String, Object> where) {
        Statement statement = null;
        StringBuilder sbw = new StringBuilder();
        where.forEach((key, value) -> {
            sbw.append((String)key).append(" = ");
            if (value instanceof String || value instanceof UUID) {
                sbw.append("'").append(value).append("' AND ");
            } else {
                sbw.append(value).append(" AND ");
            }
        });
        where.clear();
        String values = sbw.substring(0, sbw.length() - 5);
        String query = "DELETE FROM " + this.prefix + "items WHERE " + values;
        try {
            statement = this.connection.createStatement();
            statement.executeUpdate(query);
        }
        catch (SQLException e) {
            this.plugin.debug("Delete error for " + table + "! " + e.getMessage());
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing " + table + "! " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeByLocation(String location) {
        PreparedStatement ps = null;
        String query = "DELETE FROM " + this.prefix + "items WHERE location = ?";
        try {
            ps = this.connection.prepareStatement(query);
            ps.setString(1, location);
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            this.plugin.debug("Delete error for items table! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing items table! " + e.getMessage());
            }
        }
        return 0;
    }
}

