/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry.lab;

import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.tardischemistry.lab.Lab;
import me.eccentric_nz.tardischemistry.lab.LabBuilder;
import me.eccentric_nz.tardischemistry.lab.LabInventory;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class LabGUIListener
extends TARDISMenuListener {
    private final List<Integer> slots = List.of(Integer.valueOf(18), Integer.valueOf(19), Integer.valueOf(20), Integer.valueOf(21), Integer.valueOf(22), Integer.valueOf(23));

    public LabGUIListener(TARDIS plugin) {
        super(plugin);
    }

    @EventHandler(ignoreCancelled=true)
    public void onLabMenuClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof LabInventory)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 26) {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                TARDIS.plugin.debug("LabGUIListener");
                event.setCancelled(true);
            }
            return;
        }
        switch (slot) {
            case 0: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 17: {
                event.setCancelled(true);
                this.check(event.getClickedInventory(), player);
                break;
            }
            case 26: {
                event.setCancelled(true);
                this.close(player);
                break;
            }
            default: {
                event.setCancelled(true);
            }
        }
    }

    private void check(Inventory inventory, Player player) {
        StringBuilder builder = new StringBuilder();
        for (int slot : this.slots) {
            ItemStack is = inventory.getItem(slot);
            if (is == null) continue;
            Material material = is.getType();
            if ((material.equals((Object)Material.GLASS_BOTTLE) || material.equals((Object)Material.FEATHER)) && is.hasItemMeta()) {
                ItemMeta im = is.getItemMeta();
                if (!im.hasDisplayName()) continue;
                builder.append(im.displayName()).append(",");
                continue;
            }
            builder.append(is.getType()).append(",");
        }
        String recipe = builder.substring(0, builder.length() - 1);
        for (Lab lab : Lab.values()) {
            if (!lab.getRecipe().equals(recipe)) continue;
            this.craft(lab, inventory, player);
            return;
        }
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 1.0f);
    }

    private void craft(Lab lab, Inventory inventory, Player player) {
        ItemStack crafted = LabBuilder.getLabProduct(lab);
        inventory.setItem(0, crafted);
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        for (int i : this.slots) {
            inventory.setItem(i, null);
        }
    }
}

