/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms;

import com.google.gson.JsonObject;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.DamageUtility;
import me.eccentric_nz.TARDIS.api.event.TARDISRoomGrowEvent;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rooms.TARDISRoomData;
import me.eccentric_nz.TARDIS.rooms.TARDISRoomRunnable;
import me.eccentric_nz.TARDIS.schematic.TARDISSchematicGZip;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class TARDISRoomBuilder {
    private final TARDIS plugin;
    private final String room;
    private final Location location;
    private final COMPASS direction;
    private final Player player;

    public TARDISRoomBuilder(TARDIS plugin, String room, Location location, COMPASS direction, Player player) {
        this.plugin = plugin;
        this.room = room;
        this.location = location;
        this.direction = direction;
        this.player = player;
    }

    public boolean build() {
        ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
        if (rs.fromUUID(this.player.getUniqueId().toString())) {
            Material floor_type;
            Material wall_type;
            ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, this.player.getUniqueId().toString());
            TARDISRoomData roomData = new TARDISRoomData();
            roomData.setTardis_id(rs.getTardisId());
            if (rsp.resultSet()) {
                wall_type = Material.getMaterial((String)rsp.getWall());
                floor_type = Material.getMaterial((String)rsp.getFloor());
            } else {
                wall_type = Material.ORANGE_WOOL;
                floor_type = Material.LIGHT_GRAY_WOOL;
            }
            roomData.setMiddleType(wall_type);
            roomData.setFloorType(floor_type);
            Block b = this.location.getBlock();
            roomData.setBlock(b);
            roomData.setDirection(this.direction);
            JsonObject obj = TARDISSchematicGZip.getObject(this.plugin, "rooms", this.room.toLowerCase(Locale.ROOT), this.plugin.getRoomsConfig().getBoolean("rooms." + this.room + ".user"));
            if (obj == null) {
                return false;
            }
            JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
            int xzoffset = dimensions.get("width").getAsInt() / 2;
            switch (this.direction) {
                case NORTH: {
                    this.location.setX(this.location.getX() - (double)xzoffset);
                    this.location.setZ(this.location.getZ() - (double)dimensions.get("width").getAsInt());
                    break;
                }
                case WEST: {
                    this.location.setX(this.location.getX() - (double)dimensions.get("width").getAsInt());
                    this.location.setZ(this.location.getZ() - (double)xzoffset);
                    break;
                }
                case SOUTH: {
                    this.location.setX(this.location.getX() - (double)xzoffset);
                    break;
                }
                default: {
                    this.location.setZ(this.location.getZ() - (double)xzoffset);
                }
            }
            int offset = Math.abs(this.plugin.getRoomsConfig().getInt("rooms." + this.room + ".offset"));
            this.location.setY(this.location.getY() - (double)offset);
            roomData.setLocation(this.location);
            roomData.setRoom(this.room);
            roomData.setSchematic(obj);
            long delay = Math.round(20.0 / this.plugin.getConfig().getDouble("growth.room_speed"));
            this.plugin.getPM().callEvent((Event)new TARDISRoomGrowEvent(this.player, null, null, roomData));
            TARDISRoomRunnable runnable = new TARDISRoomRunnable(this.plugin, roomData, this.player.getUniqueId());
            int taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, delay, delay);
            runnable.setTask(taskID);
            this.plugin.getTrackerKeeper().getRoomTasks().put(taskID, roomData);
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "ROOM_CANCEL", String.format("%d", taskID));
            DamageUtility.run(this.plugin, DiskCircuit.ARS, rs.getTardisId(), this.player);
        }
        return true;
    }
}

