/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.recipes.shaped;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.CraftingDifficulty;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class DoorCustomRecipe {
    private final TARDIS plugin;

    public DoorCustomRecipe(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void addRecipes() {
        for (String r : this.plugin.getCustomDoorsConfig().getKeys(false)) {
            try {
                Material material = Material.valueOf((String)this.plugin.getCustomDoorsConfig().getString(r + ".material"));
                ItemStack is = ItemStack.of((Material)material);
                ItemMeta im = is.getItemMeta();
                String dn = TARDISStringUtils.capitalise(r);
                im.displayName((Component)ComponentUtils.toWhite("Door " + dn));
                im.setItemModel(new NamespacedKey((Plugin)this.plugin, r + "_closed"));
                is.setItemMeta(im);
                NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "door_" + r);
                ShapedRecipe recipe = new ShapedRecipe(key, is);
                recipe.shape(new String[]{"#A#", "#D#", "###"});
                recipe.setIngredient('#', this.plugin.getCraftingDifficulty() == CraftingDifficulty.HARD ? Material.GLASS : Material.GLASS_PANE);
                recipe.setIngredient('A', material);
                recipe.setIngredient('D', Material.IRON_DOOR);
                this.plugin.getServer().addRecipe((Recipe)recipe);
                this.plugin.getFigura().getShapedRecipes().put("Door " + dn, recipe);
            }
            catch (IllegalArgumentException e) {
                this.plugin.debug("Invalid custom door item material for " + r + "!");
            }
        }
    }
}

