/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.doors.outer;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.chameleon.utils.PandoricaOpens;
import me.eccentric_nz.TARDIS.chameleon.utils.SidratOpens;
import me.eccentric_nz.TARDIS.custommodels.keys.ChameleonVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.ColouredVariant;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.doors.DoorUtility;
import me.eccentric_nz.TARDIS.move.TARDISTeleportLocation;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class OuterDisplayDoorCloser {
    private final TARDIS plugin;

    public OuterDisplayDoorCloser(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void close(ArmorStand stand, int id, UUID uuid) {
        if (stand == null) {
            return;
        }
        EntityEquipment ee = stand.getEquipment();
        ItemStack dye = ee.getHelmet();
        if (dye == null) {
            return;
        }
        if ((TARDISConstants.DYES.contains(dye.getType()) || this.plugin.getUtils().isCustomModel(dye)) && dye.hasItemMeta()) {
            ItemMeta dim = dye.getItemMeta();
            if (!dim.hasItemModel()) {
                return;
            }
            Location portal = new Location(stand.getWorld(), (double)stand.getLocation().getBlockX(), (double)stand.getLocation().getBlockY(), (double)stand.getLocation().getBlockZ());
            if (dye.getType() == Material.ENDER_PEARL) {
                new PandoricaOpens(this.plugin).animate(stand, false);
            } else if (dye.getType() == Material.GREEN_STAINED_GLASS_PANE) {
                new SidratOpens(this.plugin).animate(stand, false);
            } else {
                switch (dye.getType()) {
                    case CYAN_STAINED_GLASS_PANE: {
                        dim.setItemModel(ChameleonVariant.TENNANT_CLOSED.getKey());
                        break;
                    }
                    case GRAY_STAINED_GLASS_PANE: {
                        dim.setItemModel(ChameleonVariant.WEEPING_ANGEL_CLOSED.getKey());
                        break;
                    }
                    case WHITE_DYE: {
                        dim.setItemModel(ChameleonVariant.WHITE_CLOSED.getKey());
                        break;
                    }
                    case ORANGE_DYE: {
                        dim.setItemModel(ChameleonVariant.ORANGE_CLOSED.getKey());
                        break;
                    }
                    case MAGENTA_DYE: {
                        dim.setItemModel(ChameleonVariant.MAGENTA_CLOSED.getKey());
                        break;
                    }
                    case LIGHT_BLUE_DYE: {
                        dim.setItemModel(ChameleonVariant.LIGHT_BLUE_CLOSED.getKey());
                        break;
                    }
                    case YELLOW_DYE: {
                        dim.setItemModel(ChameleonVariant.YELLOW_CLOSED.getKey());
                        break;
                    }
                    case LIME_DYE: {
                        dim.setItemModel(ChameleonVariant.LIME_CLOSED.getKey());
                        break;
                    }
                    case PINK_DYE: {
                        dim.setItemModel(ChameleonVariant.PINK_CLOSED.getKey());
                        break;
                    }
                    case GRAY_DYE: {
                        dim.setItemModel(ChameleonVariant.GRAY_CLOSED.getKey());
                        break;
                    }
                    case LIGHT_GRAY_DYE: {
                        dim.setItemModel(ChameleonVariant.LIGHT_GRAY_CLOSED.getKey());
                        break;
                    }
                    case CYAN_DYE: {
                        dim.setItemModel(ChameleonVariant.CYAN_CLOSED.getKey());
                        break;
                    }
                    case PURPLE_DYE: {
                        dim.setItemModel(ChameleonVariant.PURPLE_CLOSED.getKey());
                        break;
                    }
                    case BLUE_DYE: {
                        dim.setItemModel(ChameleonVariant.BLUE_CLOSED.getKey());
                        break;
                    }
                    case BROWN_DYE: {
                        dim.setItemModel(ChameleonVariant.BROWN_CLOSED.getKey());
                        break;
                    }
                    case GREEN_DYE: {
                        dim.setItemModel(ChameleonVariant.GREEN_CLOSED.getKey());
                        break;
                    }
                    case RED_DYE: {
                        dim.setItemModel(ChameleonVariant.RED_CLOSED.getKey());
                        break;
                    }
                    case BLACK_DYE: {
                        dim.setItemModel(ChameleonVariant.BLACK_CLOSED.getKey());
                        break;
                    }
                    case LEATHER_HORSE_ARMOR: {
                        dim.setItemModel(ColouredVariant.TINTED_CLOSED.getKey());
                        break;
                    }
                    default: {
                        NamespacedKey c = this.plugin.getUtils().getCustomModel(dye.getType(), "_closed");
                        if (c == null) break;
                        dim.setItemModel(c);
                    }
                }
                dye.setItemMeta(dim);
                ee.setHelmet(dye, true);
                TARDISSounds.playDoorSound(true, portal);
            }
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (rs.resultSet()) {
                Tardis tardis = rs.getTardis();
                TARDISTeleportLocation removed = this.plugin.getTrackerKeeper().getPortals().remove(portal);
                if (removed == null) {
                    DoorUtility.debugPortal(portal.toString());
                }
                if (!this.plugin.getConfig().getBoolean("preferences.open_door_policy")) {
                    if (tardis.getCompanions().equalsIgnoreCase("everyone")) {
                        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                            this.plugin.getTrackerKeeper().getMovers().remove(p.getUniqueId());
                        }
                    } else {
                        String[] companions;
                        for (String c : companions = tardis.getCompanions().split(":")) {
                            if (c.isEmpty()) continue;
                            this.plugin.getTrackerKeeper().getMovers().remove(UUID.fromString(c));
                        }
                        this.plugin.getTrackerKeeper().getMovers().remove(uuid);
                    }
                }
            }
        }
    }
}

