/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console;

import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.console.models.ColourType;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.custommodels.keys.ConsolePart;
import me.eccentric_nz.TARDIS.database.ClearInteractions;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetConsoleLabel;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetInteractionsFromId;
import me.eccentric_nz.TARDIS.sonic.SonicLore;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class ConsoleDestroyer {
    private final TARDIS plugin;

    public ConsoleDestroyer(TARDIS plugin) {
        this.plugin = plugin;
    }

    public ItemStack returnStack(String uuids, int id) {
        String colour = "";
        NamespacedKey model = null;
        ResultSetInteractionsFromId rs = new ResultSetInteractionsFromId(this.plugin, id);
        if (rs.resultSet()) {
            String[] split;
            for (UUID u : rs.getUuids()) {
                String[] e = this.plugin.getServer().getEntity(u);
                if (e instanceof Interaction) {
                    ItemDisplay display;
                    UUID uuid;
                    Interaction interaction = (Interaction)e;
                    ItemDisplay docked = TARDISDisplayItemUtils.getSonic(interaction);
                    if (docked != null) {
                        ItemStack sonic = docked.getItemStack();
                        SonicLore.setChargeLevel(sonic);
                        e.getWorld().dropItemNaturally(e.getLocation(), sonic);
                        docked.remove();
                    }
                    if ((uuid = (UUID)e.getPersistentDataContainer().get(this.plugin.getModelUuidKey(), this.plugin.getPersistentDataTypeUUID())) != null && (display = (ItemDisplay)this.plugin.getServer().getEntity(uuid)) != null) {
                        display.remove();
                    }
                    e.remove();
                }
                if (!(e instanceof TextDisplay)) continue;
                TextDisplay display = (TextDisplay)e;
                display.remove();
            }
            ResultSetConsoleLabel rsc = new ResultSetConsoleLabel(this.plugin, id);
            if (rsc.resultSet()) {
                Block centre = rsc.getLocation().getBlock();
                centre.setType(Material.AIR);
                this.removeTextDisplays(rsc.getLocation());
            }
            for (String u : split = uuids.split("~")) {
                try {
                    UUID uuid = UUID.fromString(u);
                    Entity e = this.plugin.getServer().getEntity(uuid);
                    if (!(e instanceof ItemDisplay)) continue;
                    ItemDisplay display = (ItemDisplay)e;
                    ItemStack is = display.getItemStack();
                    if (colour.isEmpty() && is.hasItemMeta()) {
                        ItemMeta im = is.getItemMeta();
                        model = im.getItemModel();
                        if (model == null && im.hasCustomModelDataComponent()) {
                            float convertedCMD = ((Float)im.getCustomModelDataComponent().getFloats().getFirst()).floatValue();
                            model = convertedCMD == 1017.0f || convertedCMD == 2017.0f ? ConsolePart.CONSOLE_RUSTIC.getKey() : (convertedCMD == 1016.0f || convertedCMD == 2016.0f ? ConsolePart.CONSOLE_BROWN.getKey() : (convertedCMD == 1015.0f || convertedCMD == 2015.0f ? ConsolePart.CONSOLE_PINK.getKey() : (convertedCMD == 1014.0f || convertedCMD == 2014.0f ? ConsolePart.CONSOLE_MAGENTA.getKey() : (convertedCMD == 1013.0f || convertedCMD == 2013.0f ? ConsolePart.CONSOLE_PURPLE.getKey() : (convertedCMD == 1012.0f || convertedCMD == 2012.0f ? ConsolePart.CONSOLE_BLUE.getKey() : (convertedCMD == 1011.0f || convertedCMD == 2011.0f ? ConsolePart.CONSOLE_LIGHT_BLUE.getKey() : (convertedCMD == 1010.0f || convertedCMD == 2010.0f ? ConsolePart.CONSOLE_CYAN.getKey() : (convertedCMD == 1009.0f || convertedCMD == 2009.0f ? ConsolePart.CONSOLE_GREEN.getKey() : (convertedCMD == 1008.0f || convertedCMD == 2008.0f ? ConsolePart.CONSOLE_LIME.getKey() : (convertedCMD == 1007.0f || convertedCMD == 2007.0f ? ConsolePart.CONSOLE_YELLOW.getKey() : (convertedCMD == 1006.0f || convertedCMD == 2006.0f ? ConsolePart.CONSOLE_ORANGE.getKey() : (convertedCMD == 1005.0f || convertedCMD == 2005.0f ? ConsolePart.CONSOLE_RED.getKey() : (convertedCMD == 1004.0f || convertedCMD == 2004.0f ? ConsolePart.CONSOLE_WHITE.getKey() : (convertedCMD == 1003.0f || convertedCMD == 2003.0f ? ConsolePart.CONSOLE_BLACK.getKey() : (convertedCMD == 1002.0f || convertedCMD == 2002.0f ? ConsolePart.CONSOLE_GRAY.getKey() : ConsolePart.CONSOLE_LIGHT_GRAY.getKey())))))))))))))));
                        } else {
                            this.plugin.debug("found model -> " + model.getKey());
                        }
                        colour = ColourType.COLOURS.getOrDefault(model, "LIGHT_GRAY");
                    }
                    display.remove();
                }
                catch (IllegalArgumentException uuid) {
                    // empty catch block
                }
            }
            new ClearInteractions(this.plugin).removeRecords(id);
            boolean isRustic = model != null && (model.equals((Object)ConsolePart.CONSOLE_RUSTIC.getKey()) || model.equals((Object)ConsolePart.CONSOLE_CENTRE_RUSTIC.getKey()) || model.equals((Object)ConsolePart.CONSOLE_DIVISION_RUSTIC.getKey()));
            Material material = isRustic ? Material.WAXED_OXIDIZED_COPPER : Material.valueOf((String)(colour + "_CONCRETE"));
            ItemStack console = ItemStack.of((Material)material, (int)1);
            ItemMeta im = console.getItemMeta();
            String dn = (isRustic ? "Rustic" : TARDISStringUtils.capitalise(colour)) + " Console";
            im.displayName((Component)ComponentUtils.toWhite(dn));
            im.lore(List.of(Component.text((String)"Integration with interaction")));
            String which = model.getKey().replace("division_", "").replace("centre_", "");
            this.plugin.debug(which);
            im.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)which);
            console.setItemMeta(im);
            return console;
        }
        return null;
    }

    private void removeTextDisplays(Location centre) {
        Location spawn = centre.clone().add(0.5, 0.0, 0.5);
        for (Entity e : spawn.getWorld().getNearbyEntities(spawn, 4.0, 3.0, 4.0, t -> t.getType() == EntityType.TEXT_DISPLAY)) {
            if (!(e instanceof TextDisplay)) continue;
            e.remove();
        }
    }
}

