/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.give;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemRegistry;
import me.eccentric_nz.TARDIS.custommodels.keys.BoneDoorVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.ClassicDoorVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.TardisDoorVariant;
import me.eccentric_nz.TARDIS.doors.Door;
import me.eccentric_nz.TARDIS.rotors.Rotor;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class TARDISDisplayBlockCommand {
    private final TARDIS plugin;

    public TARDISDisplayBlockCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public ItemStack getStack(String arg) {
        String display = TARDISStringUtils.toEnumUppercase(arg);
        if (display.startsWith("DOOR") || display.endsWith("_DOOR")) {
            Door door = Door.byName.get(display);
            ItemStack is = ItemStack.of((Material)door.getMaterial(), (int)1);
            ItemMeta im = is.getItemMeta();
            im.displayName((Component)ComponentUtils.toWhite("Door " + TARDISStringUtils.capitalise(door.getName())));
            NamespacedKey key = switch (door.getMaterial()) {
                case Material.IRON_DOOR -> TardisDoorVariant.TARDIS_DOOR_CLOSED.getKey();
                case Material.BIRCH_DOOR -> BoneDoorVariant.BONE_DOOR_CLOSED.getKey();
                case Material.CHERRY_DOOR -> ClassicDoorVariant.CLASSIC_DOOR_CLOSED.getKey();
                default -> Door.getClosedModel(door.getMaterial());
            };
            im.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)key.getKey());
            im.setItemModel(key);
            is.setItemMeta(im);
            return is;
        }
        if (display.startsWith("TIME_")) {
            Rotor rotor = Rotor.byName.get(display);
            ItemStack is = ItemStack.of((Material)Material.LIGHT_GRAY_DYE, (int)1);
            ItemMeta im = is.getItemMeta();
            im.displayName((Component)ComponentUtils.toWhite("Time Rotor " + rotor.name()));
            im.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)rotor.offModel().getKey());
            im.setItemModel(rotor.offModel());
            is.setItemMeta(im);
            return is;
        }
        try {
            TARDISDisplayItem tdi = TARDISDisplayItemRegistry.valueOf(display);
            ItemStack is = ItemStack.of((Material)tdi.getMaterial(), (int)1);
            ItemMeta im = is.getItemMeta();
            im.displayName((Component)ComponentUtils.toWhite(tdi.getDisplayName()));
            if (tdi.getCustomModel() != null) {
                im.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)tdi.getCustomModel().getKey());
            }
            is.setItemMeta(im);
            return is;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

