/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev;

import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISUpdateBlocksCommand;
import me.eccentric_nz.TARDIS.console.ConsoleBuilder;
import me.eccentric_nz.TARDIS.customblocks.TARDISBlockDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemRegistry;
import me.eccentric_nz.TARDIS.custommodels.keys.ChameleonVariant;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.flight.vehicle.InterpolatedAnimation;
import me.eccentric_nz.TARDIS.flight.vehicle.VehicleUtility;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import me.eccentric_nz.tardisshop.ShopItem;
import net.kyori.adventure.text.Component;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Transformation;

public class TARDISDisplayItemCommand {
    private final TARDIS plugin;

    public TARDISDisplayItemCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean display(Player player, String[] args) {
        Block block = player.getTargetBlock(null, 8);
        switch (args[1].toLowerCase(Locale.ROOT)) {
            case "add": {
                Material material;
                if (args.length < 3) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
                    return true;
                }
                ItemDisplay.ItemDisplayTransform transform = ItemDisplay.ItemDisplayTransform.GROUND;
                try {
                    material = Material.valueOf((String)args[2]);
                    if (args.length > 3) {
                        transform = ItemDisplay.ItemDisplayTransform.valueOf((String)args[3]);
                    }
                }
                catch (IllegalArgumentException e) {
                    material = Material.DIAMOND_AXE;
                }
                ItemDisplay display = (ItemDisplay)block.getWorld().spawnEntity(block.getLocation().clone().add(0.5, 1.25, 0.5), EntityType.ITEM_DISPLAY);
                ItemStack is = ItemStack.of((Material)material);
                if (args.length > 4) {
                    try {
                        ShopItem shopItem = ShopItem.valueOf(args[4].toUpperCase(Locale.ROOT));
                        ItemMeta im = is.getItemMeta();
                        im.setItemModel(shopItem.getModel());
                        is.setItemMeta(im);
                    }
                    catch (IllegalArgumentException shopItem) {
                        // empty catch block
                    }
                }
                display.setItemStack(is);
                display.setItemDisplayTransform(transform);
                display.setBillboard(Display.Billboard.VERTICAL);
                display.setInvulnerable(true);
                if (args.length <= 3 || !args[4].equalsIgnoreCase("true")) break;
                TextDisplay text = (TextDisplay)block.getWorld().spawnEntity(block.getLocation().clone().add(0.5, 1.75, 0.5), EntityType.TEXT_DISPLAY);
                text.setAlignment(TextDisplay.TextAlignment.CENTER);
                text.text((Component)Component.text((String)(TARDISStringUtils.capitalise(material.toString()) + ", Cost: 25.00")));
                text.setTransformation(new Transformation(TARDISConstants.VECTOR_ZERO, TARDISConstants.AXIS_ANGLE_ZERO, TARDISConstants.VECTOR_QUARTER, TARDISConstants.AXIS_ANGLE_ZERO));
                text.setBillboard(Display.Billboard.VERTICAL);
                break;
            }
            case "animate": {
                if (player.getPassengers().isEmpty()) {
                    if (args.length == 2) {
                        ItemStack box = ItemStack.of((Material)Material.BLUE_DYE, (int)1);
                        ItemMeta im = box.getItemMeta();
                        im.setItemModel(ChameleonVariant.BLUE_CLOSED.getKey());
                        box.setItemMeta(im);
                        ItemDisplay display = VehicleUtility.getItemDisplay(player, box, 1.75f);
                        int period = 40;
                        this.plugin.getTrackerKeeper().setAnimateTask(this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new InterpolatedAnimation(display, period), 5L, (long)period));
                        break;
                    }
                    Bee bee = (Bee)player.getWorld().spawnEntity(player.getLocation(), EntityType.BEE);
                    bee.setAI(false);
                    player.addPassenger((Entity)bee);
                    break;
                }
                for (Entity e : player.getPassengers()) {
                    e.eject();
                    e.remove();
                }
                this.plugin.getServer().getScheduler().cancelTask(this.plugin.getTrackerKeeper().getAnimateTask());
                break;
            }
            case "remove": {
                BoundingBox box = new BoundingBox((double)block.getX(), (double)block.getY(), (double)block.getZ(), (double)(block.getX() + 1), (double)block.getY() + 2.5, (double)(block.getZ() + 1));
                for (Entity e : block.getWorld().getNearbyEntities(box)) {
                    if (e instanceof ItemDisplay || e instanceof TextDisplay || e instanceof Interaction) {
                        e.remove();
                    }
                    block.setType(Material.AIR);
                }
                break;
            }
            case "place": {
                if (args.length < 3) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
                    return true;
                }
                TARDISDisplayItem tdi = TARDISDisplayItemRegistry.getBY_NAME().get(args[2]);
                if (tdi == null) break;
                ItemStack is = ItemStack.of((Material)tdi.getMaterial());
                ItemMeta im = is.getItemMeta();
                im.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)tdi.getCustomModel().getKey());
                im.setItemModel(tdi.getCustomModel());
                im.displayName((Component)Component.text((String)TARDISStringUtils.capitalise(args[2])));
                is.setItemMeta(im);
                Block up = block.getRelative(BlockFace.UP);
                if (tdi == TARDISBlockDisplayItem.DOOR || tdi == TARDISBlockDisplayItem.CLASSIC_DOOR || tdi == TARDISBlockDisplayItem.BONE_DOOR || tdi.isLight()) {
                    Interaction interaction = (Interaction)block.getWorld().spawnEntity(up.getLocation().clone().add(0.5, 0.0, 0.5), EntityType.INTERACTION);
                    interaction.setResponsive(true);
                    interaction.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)tdi.getCustomModel().getKey());
                    interaction.setPersistent(true);
                    if (tdi.isLight()) {
                        Levelled light = TARDISConstants.LIGHT;
                        int level = tdi.isLit() ? 15 : 0;
                        light.setLevel(level);
                        up.setBlockData((BlockData)light);
                    }
                    if (tdi == TARDISBlockDisplayItem.DOOR || tdi == TARDISBlockDisplayItem.CLASSIC_DOOR || tdi == TARDISBlockDisplayItem.BONE_DOOR) {
                        interaction.setInteractionHeight(2.0f);
                        interaction.setInteractionWidth(1.0f);
                    }
                } else {
                    up.setType(tdi == TARDISBlockDisplayItem.ARTRON_FURNACE ? Material.FURNACE : Material.BARRIER);
                }
                double ay = tdi == TARDISBlockDisplayItem.DOOR || tdi == TARDISBlockDisplayItem.CLASSIC_DOOR || tdi == TARDISBlockDisplayItem.BONE_DOOR ? 0.0 : 0.5;
                ItemDisplay display = (ItemDisplay)block.getWorld().spawnEntity(up.getLocation().add(0.5, ay, 0.5), EntityType.ITEM_DISPLAY);
                display.setItemStack(is);
                display.setPersistent(true);
                display.setInvulnerable(true);
                if (tdi == TARDISBlockDisplayItem.DOOR || tdi == TARDISBlockDisplayItem.CLASSIC_DOOR || tdi == TARDISBlockDisplayItem.BONE_DOOR || tdi == TARDISBlockDisplayItem.UNTEMPERED_SCHISM) {
                    display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.FIXED);
                }
                if (tdi.getMaterial() == Material.AMETHYST_SHARD) {
                    display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.HEAD);
                }
                if (tdi != TARDISBlockDisplayItem.ARTRON_FURNACE) break;
                display.setBrightness(new Display.Brightness(15, 15));
                break;
            }
            case "break": {
                if (!block.getType().equals((Object)Material.BARRIER)) break;
                for (Entity e : block.getWorld().getNearbyEntities(block.getBoundingBox().expand(0.1))) {
                    if (e instanceof ItemDisplay) {
                        ItemDisplay display = (ItemDisplay)e;
                        ItemStack is = display.getItemStack();
                        block.getWorld().dropItemNaturally(block.getLocation(), is);
                        e.remove();
                    }
                    if (!(e instanceof Interaction)) continue;
                    e.remove();
                }
                block.setType(Material.AIR);
                break;
            }
            case "convert": {
                return new TARDISUpdateBlocksCommand(this.plugin).convert(player);
            }
            case "chunk": {
                Chunk chunk = player.getLocation().getChunk();
                for (Entity entity : chunk.getEntities()) {
                    if (!(entity instanceof ItemDisplay) && !(entity instanceof Interaction) && !(entity instanceof TextDisplay)) continue;
                    entity.remove();
                }
                return true;
            }
            case "console": {
                if (args.length < 3) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
                    return true;
                }
                String colour = args[2].toLowerCase(Locale.ROOT);
                if (!TARDISConstants.COLOURS.contains(colour)) {
                    this.plugin.getMessenger().message((CommandSender)player, "Must be a valid console type!");
                    return true;
                }
                ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
                String uuid = player.getUniqueId().toString();
                if (rs.fromUUID(uuid)) {
                    new ConsoleBuilder(this.plugin).create(block, colour, rs.getTardisId(), uuid);
                }
                return true;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

