/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.builders.exterior;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.builders.exterior.TARDISMaterialisePreset;
import me.eccentric_nz.TARDIS.chameleon.construct.TARDISConstructColumn;
import me.eccentric_nz.TARDIS.chameleon.utils.CustomPreset;
import me.eccentric_nz.TARDIS.chameleon.utils.TARDISChameleonColumn;
import me.eccentric_nz.TARDIS.chameleon.utils.TARDISCustomPreset;
import me.eccentric_nz.TARDIS.customblocks.TARDISBlockDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetConstructSign;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCustomPreset;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoors;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.move.TARDISDoorListener;
import me.eccentric_nz.TARDIS.travel.TARDISDoorLocation;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import me.eccentric_nz.TARDIS.utility.TARDISSponge;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import me.eccentric_nz.tardischunkgenerator.worldgen.TARDISChunkGenerator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.bukkit.block.data.Rotatable;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TARDISInstantPreset {
    private final TARDIS plugin;
    private final BuildData bd;
    private final BlockData chameleonBlockData;
    private final boolean rebuild;
    private final ChameleonPreset preset;
    private final Material random_colour;
    private final NamedTextColor sign_colour;
    private final List<ProblemBlock> do_at_end = new ArrayList<ProblemBlock>();

    public TARDISInstantPreset(TARDIS plugin, BuildData bd, ChameleonPreset preset, BlockData chameleonBlockData, boolean rebuild) {
        this.plugin = plugin;
        this.bd = bd;
        this.preset = preset;
        this.chameleonBlockData = chameleonBlockData;
        this.rebuild = rebuild;
        Material[] colours = new Material[]{Material.WHITE_WOOL, Material.ORANGE_WOOL, Material.MAGENTA_WOOL, Material.LIGHT_BLUE_WOOL, Material.YELLOW_WOOL, Material.LIME_WOOL, Material.PINK_WOOL, Material.CYAN_WOOL, Material.PURPLE_WOOL, Material.BLUE_WOOL, Material.BROWN_WOOL, Material.GREEN_WOOL, Material.RED_WOOL};
        this.random_colour = colours[TARDISConstants.RANDOM.nextInt(13)];
        this.sign_colour = plugin.getUtils().getSignColour();
    }

    public void buildPreset() {
        int signx;
        TARDISChameleonColumn column;
        if (this.preset.equals((Object)ChameleonPreset.ANGEL)) {
            this.plugin.getPresets().setR(TARDISConstants.RANDOM.nextInt(2));
        }
        if (this.preset.equals((Object)ChameleonPreset.CONSTRUCT)) {
            column = new TARDISConstructColumn(this.plugin, this.bd.getTardisID(), "blueprintData", this.bd.getDirection().forPreset()).getColumn();
            if (column == null) {
                if (this.bd.getPlayer().getPlayer() != null) {
                    this.plugin.getMessenger().sendColouredCommand((CommandSender)this.bd.getPlayer().getPlayer(), "INVALID_CONSTRUCT", "/tardistravel stop", this.plugin);
                }
                this.plugin.getTrackerKeeper().getMaterialising().removeAll(Collections.singleton(this.bd.getTardisID()));
                this.plugin.getTrackerKeeper().getDematerialising().removeAll(Collections.singleton(this.bd.getTardisID()));
                this.plugin.getTrackerKeeper().getInVortex().removeAll(Collections.singleton(this.bd.getTardisID()));
                this.plugin.getTrackerKeeper().getDestinationVortex().remove(this.bd.getTardisID());
                return;
            }
        } else {
            column = this.plugin.getPresets().getColumn(this.preset, this.bd.getDirection().forPreset());
        }
        int x = this.bd.getLocation().getBlockX();
        int plusx = this.bd.getLocation().getBlockX() + 1;
        int minusx = this.bd.getLocation().getBlockX() - 1;
        int y = this.preset.equals((Object)ChameleonPreset.SUBMERGED) ? this.bd.getLocation().getBlockY() - 1 : this.bd.getLocation().getBlockY();
        int z = this.bd.getLocation().getBlockZ();
        int plusz = this.bd.getLocation().getBlockZ() + 1;
        int minusz = this.bd.getLocation().getBlockZ() - 1;
        World world = this.bd.getLocation().getWorld();
        if (this.plugin.getTrackerKeeper().getRescue().containsKey(this.bd.getTardisID())) {
            UUID playerUUID = this.plugin.getTrackerKeeper().getRescue().get(this.bd.getTardisID());
            Player saved = this.plugin.getServer().getPlayer(playerUUID);
            if (saved != null) {
                TARDISDoorLocation idl = TARDISDoorListener.getDoor(1, this.bd.getTardisID());
                Location l = idl.getL();
                this.plugin.getGeneralKeeper().getDoorListener().movePlayer(saved, l, false, world, false, 0, this.bd.useMinecartSounds(), false);
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("tardis_id", this.bd.getTardisID());
                set.put("uuid", playerUUID.toString());
                this.plugin.getQueryFactory().doInsert("travellers", set);
            }
            this.plugin.getTrackerKeeper().getRescue().remove(this.bd.getTardisID());
        }
        int signz = switch (this.bd.getDirection().forPreset()) {
            case COMPASS.SOUTH -> {
                signx = x;
                yield minusz - 1;
            }
            case COMPASS.EAST -> {
                signx = minusx - 1;
                yield z;
            }
            case COMPASS.NORTH -> {
                signx = x;
                yield plusz + 1;
            }
            default -> {
                signx = plusx + 1;
                yield z;
            }
        };
        BlockData[][] data = column.blockData();
        for (int i = 0; i < 10; ++i) {
            int xx;
            BlockData[] colData = data[i];
            int zz = switch (i) {
                case 0 -> {
                    xx = minusx;
                    yield minusz;
                }
                case 1 -> {
                    xx = x;
                    yield minusz;
                }
                case 2 -> {
                    xx = plusx;
                    yield minusz;
                }
                case 3 -> {
                    xx = plusx;
                    yield z;
                }
                case 4 -> {
                    xx = plusx;
                    yield plusz;
                }
                case 5 -> {
                    xx = x;
                    yield plusz;
                }
                case 6 -> {
                    xx = minusx;
                    yield plusz;
                }
                case 7 -> {
                    xx = minusx;
                    yield z;
                }
                case 8 -> {
                    xx = x;
                    yield z;
                }
                default -> {
                    xx = signx;
                    yield signz;
                }
            };
            block38: for (int yy = 0; yy < 4; ++yy) {
                boolean change = true;
                if (yy == 0 && i == 9) {
                    Block rail = world.getBlockAt(xx, y, zz);
                    if (rail.getType().equals((Object)Material.RAIL) || rail.getType().equals((Object)Material.POWERED_RAIL)) {
                        change = false;
                        TARDISBlockSetters.setBlockAndRemember(world, xx, y, zz, rail.getBlockData(), this.bd.getTardisID());
                    }
                    if (world.getEnvironment().equals((Object)World.Environment.NETHER) || world.getEnvironment().equals((Object)World.Environment.THE_END) || world.getGenerator() instanceof TARDISChunkGenerator) {
                        TARDISBlockSetters.setUnderDoorBlock(world, xx, y - 1, zz, this.bd.getTardisID(), false);
                    }
                }
                if (yy == 0 && i == 8 && !this.plugin.getPresetBuilder().no_block_under_door.contains((Object)this.preset)) {
                    TARDISBlockSetters.setUnderDoorBlock(world, xx, y - 1, zz, this.bd.getTardisID(), true);
                }
                Material mat = colData[yy].getMaterial();
                if (yy == 0 && (i == 1 || i == 3 || i == 5 || i == 7) && this.preset.equals((Object)ChameleonPreset.INVISIBLE) && mat.isAir()) {
                    String invisible_door = world.getName() + ":" + xx + ":" + y + ":" + zz;
                    this.processDoor(invisible_door);
                    TARDISBlockSetters.setUnderDoorBlock(world, xx, y - 1, zz, this.bd.getTardisID(), true);
                }
                if (Tag.STANDING_SIGNS.isTagged((Keyed)mat) && this.preset.equals((Object)ChameleonPreset.APPERTURE)) {
                    TARDISBlockSetters.setUnderDoorBlock(world, xx, y - 1, zz, this.bd.getTardisID(), false);
                    continue;
                }
                if (Tag.WALL_SIGNS.isTagged((Keyed)mat)) {
                    String line2;
                    String line1;
                    if (this.preset.equals((Object)ChameleonPreset.JUNK_MODE)) {
                        TARDISBlockSetters.setBlock(world, xx, y + yy, zz, colData[yy]);
                        String location = new Location(world, (double)xx, (double)(y + yy), (double)zz).toString();
                        this.plugin.getGeneralKeeper().getProtectBlockMap().put(location, this.bd.getTardisID());
                        TARDISMaterialisePreset.saveJunkControl(location, "save_sign", this.bd.getTardisID());
                        Block sign = world.getBlockAt(xx, y + yy, zz);
                        if (!Tag.WALL_SIGNS.isTagged((Keyed)sign.getType())) continue;
                        Sign s = (Sign)sign.getState();
                        SignSide front = s.getSide(Side.FRONT);
                        SignSide back = s.getSide(Side.BACK);
                        front.line(0, (Component)Component.text((String)"TARDIS"));
                        front.line(1, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("saves").getFirst())));
                        front.line(2, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("saves").get(1))));
                        front.line(3, (Component)Component.text((String)""));
                        back.line(0, (Component)Component.text((String)"TARDIS"));
                        back.line(1, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("saves").getFirst())));
                        back.line(2, (Component)Component.text((String)((String)this.plugin.getSigns().getStringList("saves").get(1))));
                        back.line(3, (Component)Component.text((String)""));
                        s.setWaxed(true);
                        s.update();
                        continue;
                    }
                    if (!this.bd.shouldAddSign()) continue;
                    TARDISBlockSetters.setBlock(world, xx, y + yy, zz, colData[yy]);
                    Block sign = world.getBlockAt(xx, y + yy, zz);
                    this.plugin.getGeneralKeeper().getProtectBlockMap().put(sign.getLocation().toString(), this.bd.getTardisID());
                    if (!Tag.SIGNS.isTagged((Keyed)sign.getType())) continue;
                    Sign s = (Sign)sign.getState();
                    SignSide front = s.getSide(Side.FRONT);
                    if (this.plugin.getConfig().getBoolean("police_box.name_tardis")) {
                        HashMap<String, Object> wheret = new HashMap<String, Object>();
                        wheret.put("tardis_id", this.bd.getTardisID());
                        ResultSetTardis rst = new ResultSetTardis(this.plugin, wheret, "", false);
                        if (rst.resultSet()) {
                            Tardis tardis = rst.getTardis();
                            String player_name = TARDISStaticUtils.getNick(tardis.getUuid());
                            if (player_name == null) {
                                player_name = tardis.getOwner();
                            }
                            if (this.plugin.getServer().getPluginManager().getPlugin("Essentials") != null) {
                                Essentials essentials = (Essentials)this.plugin.getServer().getPluginManager().getPlugin("Essentials");
                                User user = essentials.getUser(tardis.getUuid());
                                player_name = ChatColor.stripColor((String)user.getNick(false));
                            }
                            Object owner = this.preset.equals((Object)ChameleonPreset.GRAVESTONE) || this.preset.equals((Object)ChameleonPreset.PUNKED) || this.preset.equals((Object)ChameleonPreset.ROBOT) ? (player_name.length() > 14 ? player_name.substring(0, 14) : player_name) : (player_name.length() > 14 ? player_name.substring(0, 12) + "'s" : player_name + "'s");
                            switch (this.preset) {
                                case GRAVESTONE: {
                                    front.line(3, (Component)Component.text((String)owner));
                                    break;
                                }
                                case ANGEL: 
                                case JAIL: {
                                    front.line(2, (Component)Component.text((String)owner));
                                    break;
                                }
                                default: {
                                    front.line(0, (Component)Component.text((String)owner));
                                }
                            }
                        }
                    }
                    if (this.preset.equals((Object)ChameleonPreset.CUSTOM)) {
                        ResultSetCustomPreset rscp = new ResultSetCustomPreset(this.plugin);
                        String key = rscp.fromId(this.bd.getTardisID()) ? rscp.getPreset() : "custom";
                        CustomPreset custom = TARDISCustomPreset.CUSTOM_PRESETS.get(key);
                        line1 = custom.lines().get(0);
                        line2 = custom.lines().get(1);
                    } else {
                        line1 = this.preset.getFirstLine();
                        line2 = this.preset.getSecondLine();
                    }
                    switch (this.preset) {
                        case ANGEL: {
                            front.line(0, (Component)Component.text((String)line1, (TextColor)this.sign_colour));
                            front.line(1, (Component)Component.text((String)line2, (TextColor)this.sign_colour));
                            front.line(3, (Component)Component.text((String)"TARDIS", (TextColor)this.sign_colour));
                            break;
                        }
                        case APPERTURE: {
                            front.line(1, (Component)Component.text((String)line1, (TextColor)this.sign_colour));
                            front.line(2, (Component)Component.text((String)line2, (TextColor)this.sign_colour));
                            front.line(3, (Component)Component.text((String)"LAB", (TextColor)this.sign_colour));
                            break;
                        }
                        case JAIL: {
                            front.line(0, (Component)Component.text((String)line1, (TextColor)this.sign_colour));
                            front.line(1, (Component)Component.text((String)line2, (TextColor)this.sign_colour));
                            front.line(3, (Component)Component.text((String)"CAPTURE", (TextColor)this.sign_colour));
                            break;
                        }
                        case THEEND: {
                            front.line(1, (Component)Component.text((String)line1, (TextColor)this.sign_colour));
                            front.line(2, (Component)Component.text((String)line2, (TextColor)this.sign_colour));
                            front.line(3, (Component)Component.text((String)"HOT ROD", (TextColor)this.sign_colour));
                            break;
                        }
                        case CONSTRUCT: {
                            ResultSetConstructSign rscs = new ResultSetConstructSign(this.plugin, this.bd.getTardisID());
                            if (!rscs.resultSet()) break;
                            if (rscs.getLine1().isEmpty() && rscs.getLine2().isEmpty() && rscs.getLine3().isEmpty() && rscs.getLine4().isEmpty()) {
                                front.line(1, (Component)Component.text((String)line1, (TextColor)this.sign_colour));
                                front.line(2, (Component)Component.text((String)line2, (TextColor)this.sign_colour));
                                break;
                            }
                            front.line(0, (Component)Component.text((String)rscs.getLine1()));
                            front.line(1, (Component)Component.text((String)rscs.getLine2()));
                            front.line(2, (Component)Component.text((String)rscs.getLine3()));
                            front.line(3, (Component)Component.text((String)rscs.getLine4()));
                            break;
                        }
                        default: {
                            front.line(1, (Component)Component.text((String)line1, (TextColor)this.sign_colour));
                            front.line(2, (Component)Component.text((String)line2, (TextColor)this.sign_colour));
                        }
                    }
                    s.setWaxed(true);
                    s.update();
                    continue;
                }
                if (Tag.DOORS.isTagged((Keyed)mat) || Tag.TRAPDOORS.isTagged((Keyed)mat) || mat == Material.RAIL || Tag.BUTTONS.isTagged((Keyed)mat) && this.preset.equals((Object)ChameleonPreset.CONSTRUCT)) {
                    boolean door = false;
                    if (Tag.DOORS.isTagged((Keyed)mat)) {
                        Bisected bisected = (Bisected)colData[yy];
                        door = bisected.getHalf().equals((Object)Bisected.Half.BOTTOM);
                    }
                    if (Tag.TRAPDOORS.isTagged((Keyed)mat) || Tag.BUTTONS.isTagged((Keyed)mat)) {
                        door = true;
                    }
                    if (door) {
                        String doorloc = world.getName() + ":" + xx + ":" + (y + yy) + ":" + zz;
                        Block doorBlock = world.getBlockAt(xx, y + yy, zz);
                        String doorStr = doorBlock.getLocation().toString();
                        this.plugin.getGeneralKeeper().getProtectBlockMap().put(doorStr, this.bd.getTardisID());
                        if (!Tag.BUTTONS.isTagged((Keyed)mat)) {
                            String under = doorBlock.getRelative(BlockFace.DOWN).getLocation().toString();
                            this.plugin.getGeneralKeeper().getProtectBlockMap().put(under, this.bd.getTardisID());
                            TARDISBlockSetters.rememberBlock(world, xx, y - 1, zz, this.bd.getTardisID());
                        }
                        this.processDoor(doorloc);
                        if (yy == 0) {
                            if (this.bd.isSubmarine() && this.plugin.isWorldGuardOnServer()) {
                                int sy = y - 1;
                                TARDISBlockSetters.setBlockAndRemember(world, xx, sy, zz, Material.SPONGE, this.bd.getTardisID());
                                Block sponge = world.getBlockAt(xx, sy, zz);
                                TARDISSponge.removeWater(sponge);
                            } else if (!this.plugin.getPresetBuilder().no_block_under_door.contains((Object)this.preset)) {
                                TARDISBlockSetters.setUnderDoorBlock(world, xx, y - 1, zz, this.bd.getTardisID(), false);
                            }
                        }
                    } else {
                        String doorStr = world.getBlockAt(xx, y + yy, zz).getLocation().toString();
                        this.plugin.getGeneralKeeper().getProtectBlockMap().put(doorStr, this.bd.getTardisID());
                    }
                    if (mat.equals((Object)Material.RAIL)) {
                        this.do_at_end.add(new ProblemBlock(new Location(world, (double)xx, (double)(y + yy), (double)zz), colData[yy]));
                        continue;
                    }
                    TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, colData[yy], this.bd.getTardisID());
                    continue;
                }
                switch (mat) {
                    case GRASS_BLOCK: 
                    case DIRT: {
                        BlockData subi = this.preset.equals((Object)ChameleonPreset.SUBMERGED) ? this.chameleonBlockData : colData[yy];
                        TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, subi, this.bd.getTardisID());
                        continue block38;
                    }
                    case BEDROCK: {
                        if (this.preset.equals((Object)ChameleonPreset.THEEND)) {
                            TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, colData[yy], this.bd.getTardisID());
                            world.getBlockAt(xx, y + yy + 1, zz).setBlockData(TARDISConstants.FIRE);
                            continue block38;
                        }
                        TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, colData[yy], this.bd.getTardisID());
                        continue block38;
                    }
                    case WHITE_WOOL: 
                    case ORANGE_WOOL: 
                    case MAGENTA_WOOL: 
                    case LIGHT_BLUE_WOOL: 
                    case YELLOW_WOOL: 
                    case LIME_WOOL: 
                    case PINK_WOOL: 
                    case GRAY_WOOL: 
                    case LIGHT_GRAY_WOOL: 
                    case CYAN_WOOL: 
                    case PURPLE_WOOL: 
                    case BLUE_WOOL: 
                    case BROWN_WOOL: 
                    case GREEN_WOOL: 
                    case RED_WOOL: 
                    case BLACK_WOOL: {
                        if (this.preset.equals((Object)ChameleonPreset.PARTY) || this.preset.equals((Object)ChameleonPreset.FLOWER) && mat.equals((Object)Material.WHITE_WOOL)) {
                            TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, this.random_colour, this.bd.getTardisID());
                        }
                        if (!this.preset.equals((Object)ChameleonPreset.JUNK_MODE) && !this.preset.equals((Object)ChameleonPreset.JUNK) || !mat.equals((Object)Material.ORANGE_WOOL)) continue block38;
                        TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, TARDISConstants.BARRIER, this.bd.getTardisID());
                        TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.HEXAGON, world, xx, y + yy, zz);
                        continue block38;
                    }
                    case TORCH: 
                    case GLOWSTONE: 
                    case REDSTONE_LAMP: {
                        BlockData light = this.bd.isSubmarine() && mat.equals((Object)Material.TORCH) ? Material.GLOWSTONE.createBlockData() : colData[yy];
                        if (mat.equals((Object)Material.TORCH)) {
                            this.do_at_end.add(new ProblemBlock(new Location(world, (double)xx, (double)(y + yy), (double)zz), light));
                            continue block38;
                        }
                        if (light instanceof Lightable) {
                            Lightable lit = (Lightable)light;
                            lit.setLit(true);
                            TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, (BlockData)lit, this.bd.getTardisID());
                            continue block38;
                        }
                        TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, light, this.bd.getTardisID());
                        continue block38;
                    }
                    case NETHERRACK: {
                        TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, colData[yy], this.bd.getTardisID());
                        if (!this.preset.equals((Object)ChameleonPreset.TORCH)) continue block38;
                        world.getBlockAt(xx, y + yy + 1, zz).setBlockData(TARDISConstants.FIRE);
                        continue block38;
                    }
                    case NETHER_PORTAL: {
                        TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy + 1, zz, Material.OBSIDIAN, this.bd.getTardisID());
                        TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, colData[yy], this.bd.getTardisID());
                        continue block38;
                    }
                    case SKELETON_SKULL: {
                        if (this.bd.isSubmarine()) {
                            TARDISBlockSetters.setBlock(world, xx, y + yy, zz, Material.GLOWSTONE);
                            continue block38;
                        }
                        Rotatable rotatable = (Rotatable)colData[yy];
                        rotatable.setRotation(this.plugin.getPresetBuilder().getSkullDirection(this.bd.getDirection().forPreset()));
                        TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, (BlockData)rotatable, this.bd.getTardisID());
                        continue block38;
                    }
                    case WHITE_TERRACOTTA: 
                    case ORANGE_TERRACOTTA: 
                    case MAGENTA_TERRACOTTA: 
                    case LIGHT_BLUE_TERRACOTTA: 
                    case YELLOW_TERRACOTTA: 
                    case LIME_TERRACOTTA: 
                    case PINK_TERRACOTTA: 
                    case GRAY_TERRACOTTA: 
                    case LIGHT_GRAY_TERRACOTTA: 
                    case CYAN_TERRACOTTA: 
                    case PURPLE_TERRACOTTA: 
                    case BLUE_TERRACOTTA: 
                    case BROWN_TERRACOTTA: 
                    case GREEN_TERRACOTTA: 
                    case RED_TERRACOTTA: 
                    case BLACK_TERRACOTTA: {
                        BlockData chai = this.preset.equals((Object)ChameleonPreset.FACTORY) ? this.chameleonBlockData : colData[yy];
                        TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, chai, this.bd.getTardisID());
                        continue block38;
                    }
                    default: {
                        if (!change) continue block38;
                        if (mat.equals((Object)Material.LEVER) || mat.equals((Object)Material.STONE_BUTTON) || mat.equals((Object)Material.OAK_BUTTON)) {
                            this.do_at_end.add(new ProblemBlock(new Location(world, (double)xx, (double)(y + yy), (double)zz), colData[yy]));
                            continue block38;
                        }
                        TARDISBlockSetters.setBlockAndRemember(world, xx, y + yy, zz, colData[yy], this.bd.getTardisID());
                    }
                }
            }
        }
        this.do_at_end.forEach(pb -> TARDISBlockSetters.setBlockAndRemember(pb.getL().getWorld(), pb.getL().getBlockX(), pb.getL().getBlockY(), pb.getL().getBlockZ(), pb.getData(), this.bd.getTardisID()));
        if (!this.rebuild) {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", this.bd.getTardisID());
            ResultSetTravellers rst = new ResultSetTravellers(this.plugin, where, true);
            if (rst.resultSet()) {
                List<UUID> travellers = rst.getData();
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> travellers.forEach(s -> {
                    Player trav = this.plugin.getServer().getPlayer(s);
                    if (trav != null) {
                        String message = this.bd.isMalfunction() ? "MALFUNCTION" : "HANDBRAKE_LEFT_CLICK";
                        this.plugin.getMessenger().sendStatus(trav, message);
                        this.plugin.getTrackerKeeper().getHasTravelled().add((UUID)s);
                    }
                }), 30L);
            }
        }
        this.plugin.getTrackerKeeper().getMaterialising().removeAll(Collections.singleton(this.bd.getTardisID()));
        this.plugin.getTrackerKeeper().getDematerialising().removeAll(Collections.singleton(this.bd.getTardisID()));
        this.plugin.getTrackerKeeper().getInVortex().removeAll(Collections.singleton(this.bd.getTardisID()));
        this.plugin.getTrackerKeeper().getDestinationVortex().remove(this.bd.getTardisID());
        if (this.plugin.getTrackerKeeper().getDidDematToVortex().contains(this.bd.getTardisID())) {
            this.plugin.getTrackerKeeper().getDidDematToVortex().removeAll(Collections.singleton(this.bd.getTardisID()));
        }
        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(this.bd.getTardisID())) {
            int taskID = this.plugin.getTrackerKeeper().getDestinationVortex().get(this.bd.getTardisID());
            this.plugin.getServer().getScheduler().cancelTask(taskID);
        }
        if (!this.bd.isRebuild() && this.bd.getPlayer().getPlayer() != null) {
            this.plugin.getTrackerKeeper().getActiveForceFields().remove(this.bd.getPlayer().getPlayer().getUniqueId());
        }
    }

    private void processDoor(String doorloc) {
        HashMap<String, Object> whered = new HashMap<String, Object>();
        whered.put("door_type", 0);
        whered.put("tardis_id", this.bd.getTardisID());
        ResultSetDoors rsd = new ResultSetDoors(this.plugin, whered, false);
        HashMap<String, Object> setd = new HashMap<String, Object>();
        setd.put("door_location", doorloc);
        setd.put("door_direction", this.bd.getDirection().forPreset().toString());
        if (rsd.resultSet()) {
            HashMap<String, Object> whereid = new HashMap<String, Object>();
            whereid.put("door_id", rsd.getDoor_id());
            this.plugin.getQueryFactory().doUpdate("doors", setd, whereid);
        } else {
            setd.put("tardis_id", this.bd.getTardisID());
            setd.put("door_type", 0);
            this.plugin.getQueryFactory().doInsert("doors", setd);
        }
    }

    public static class ProblemBlock {
        final Location l;
        final BlockData data;

        public ProblemBlock(Location l, BlockData data) {
            this.l = l;
            this.data = data;
        }

        Location getL() {
            return this.l;
        }

        BlockData getData() {
            return this.data;
        }
    }
}

