/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisregeneration;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetRegenerations;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.skins.DoctorSkins;
import me.eccentric_nz.TARDIS.skins.Skin;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.tardisregeneration.RegenerationEmitter;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Regenerator {
    private static void display(TARDIS plugin, Player player, Skin skin) {
        player.setInvulnerable(true);
        ItemStack totem = ItemStack.of((Material)Material.TOTEM_OF_UNDYING, (int)1);
        ItemMeta im = totem.getItemMeta();
        for (Player p : plugin.getServer().getOnlinePlayers()) {
            if (!p.canSee(player)) continue;
            p.hidePlayer((Plugin)plugin, player);
        }
        im.setItemModel(DoctorSkins.MODELS.get(skin));
        totem.setItemMeta(im);
        float yaw = Location.normalizeYaw((float)player.getLocation().getYaw());
        ItemDisplay display = (ItemDisplay)player.getWorld().spawnEntity(player.getLocation().clone().add(0.0, 0.725, 0.0), EntityType.ITEM_DISPLAY);
        display.setItemStack(totem);
        display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.HEAD);
        display.setRotation(yaw, 0.0f);
        plugin.getSkinChanger().set(player, skin);
        player.getAttribute(Attribute.SCALE).setBaseValue(0.5);
        player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, -1, 1, false, false, false));
        plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, () -> display.addPassenger((Entity)player), 2L);
        RegenerationEmitter emitter = new RegenerationEmitter(plugin, player, player.getLocation(), yaw);
        int task = plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, (Runnable)emitter, 0L, 20L);
        emitter.setTaskID(task);
    }

    public void dev(TARDIS plugin, Player player, String[] args) {
        int random = TARDISConstants.RANDOM.nextInt(DoctorSkins.DOCTORS.size());
        Skin skin = args.length == 1 ? DoctorSkins.DOCTORS.get(random) : DoctorSkins.DOCTORS.get(TARDISNumberParsers.parseInt(args[1]));
        Regenerator.display(plugin, player, skin);
    }

    public void processPlayer(TARDIS plugin, Player player) {
        if (!TARDISPermission.hasPermission(player, "tardis.regenerate")) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.REGENERATION, "NO_PERM_REGENERATION");
            return;
        }
        ResultSetRegenerations rsr = new ResultSetRegenerations(plugin);
        String uuid = player.getUniqueId().toString();
        if (rsr.fromUUID(uuid)) {
            int which;
            if (rsr.isRegenBlockOn()) {
                plugin.getMessenger().sendColouredCommand((CommandSender)player, "REGENERATION_BLOCKED", "/regeneration block off", plugin);
                return;
            }
            int playerRemaining = rsr.getCount();
            if (playerRemaining <= 0) {
                plugin.getMessenger().send((CommandSender)player, TardisModule.REGENERATION, "REGENERATION_COUNT");
                return;
            }
            if (plugin.getRegenerationConfig().getBoolean("artron.consume")) {
                int cost = plugin.getRegenerationConfig().getInt("artron.amount");
                if (rsr.getArtronLevel() < cost) {
                    plugin.getMessenger().send((CommandSender)player, TardisModule.REGENERATION, "REGENERATION_ARTRON");
                    return;
                }
                HashMap<String, Object> wheretl = new HashMap<String, Object>();
                wheretl.put("uuid", uuid);
                plugin.getQueryFactory().alterEnergyLevel("player_prefs", -cost, wheretl, player);
            }
            int maxRegenerations = plugin.getRegenerationConfig().getInt("regenerations");
            int decrement = 1;
            if (playerRemaining > maxRegenerations) {
                decrement = playerRemaining - maxRegenerations + 1;
            }
            if ((which = maxRegenerations - playerRemaining) < 0 || which > 15) {
                which = 0;
            }
            Skin skin = DoctorSkins.DOCTORS.get(which);
            Regenerator.display(plugin, player, skin);
            int reduced = playerRemaining - decrement;
            plugin.getQueryFactory().setRegenerationCount(player.getUniqueId(), reduced);
            plugin.getMessenger().send((CommandSender)player, TardisModule.REGENERATION, "REGENERATION_REMAINING", reduced);
        }
    }
}

