/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.skins;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.skins.Skin;
import me.eccentric_nz.TARDIS.skins.SkinUtils;
import org.bukkit.command.CommandSender;

public class SkinPersister {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String prefix;
    private PreparedStatement ps = null;
    private ResultSet rs = null;
    private int count = 0;

    public SkinPersister(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    public void load() {
        try {
            this.ps = this.connection.prepareStatement("SELECT * FROM " + this.prefix + "skins");
            this.rs = this.ps.executeQuery();
            if (this.rs.isBeforeFirst()) {
                while (this.rs.next()) {
                    UUID uuid = UUID.fromString(this.rs.getString("uuid"));
                    Skin skin = SkinUtils.deserializeSkin(this.rs.getString("skin"));
                    SkinUtils.SKINNED.put(uuid, skin);
                    ++this.count;
                }
            }
            if (this.count > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Loaded " + this.count + " skins.");
            }
            this.ps = this.connection.prepareStatement("DELETE FROM " + this.prefix + "skins");
            this.ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.debug("ResultSet error for skins table: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing skins statement or resultset: " + ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            this.ps = this.connection.prepareStatement("INSERT INTO " + this.prefix + "skins (uuid, skin) VALUES (?,?)");
            for (Map.Entry<UUID, Skin> map : SkinUtils.SKINNED.entrySet()) {
                String skin = SkinUtils.serializeSkin(map.getValue());
                this.ps.setString(1, map.getKey().toString());
                this.ps.setString(2, skin);
                this.count += this.ps.executeUpdate();
            }
            if (this.count > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Saved " + this.count + " skins.");
            }
        }
        catch (SQLException ex) {
            this.plugin.debug("Insert error for skins table: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing skins statement: " + ex.getMessage());
            }
        }
    }
}

